/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.impl;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.AlreadyClosedException;
import com.rabbitmq.client.ChannelContinuationTimeoutException;
import com.rabbitmq.client.Command;
import com.rabbitmq.client.Method;
import com.rabbitmq.client.ShutdownSignalException;
import com.rabbitmq.client.TrafficListener;
import com.rabbitmq.client.impl.AMQCommand;
import com.rabbitmq.client.impl.AMQConnection;
import com.rabbitmq.client.impl.CompletableFutureRpcWrapper;
import com.rabbitmq.client.impl.Frame;
import com.rabbitmq.client.impl.RpcContinuationRpcWrapper;
import com.rabbitmq.client.impl.RpcWrapper;
import com.rabbitmq.client.impl.ShutdownNotifierComponent;
import com.rabbitmq.utility.BlockingValueOrException;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AMQChannel
extends ShutdownNotifierComponent {
    private static final Logger LOGGER = LoggerFactory.getLogger(AMQChannel.class);
    protected static final int NO_RPC_TIMEOUT = 0;
    protected final Object _channelMutex = new Object();
    private final AMQConnection _connection;
    private final int _channelNumber;
    private AMQCommand _command;
    private RpcWrapper _activeRpc = null;
    protected volatile boolean _blockContent = false;
    protected final int _rpcTimeout;
    private final boolean _checkRpcResponseType;
    private final TrafficListener _trafficListener;
    private final int maxInboundMessageBodySize;

    public AMQChannel(AMQConnection connection, int channelNumber) {
        this._connection = connection;
        this._channelNumber = channelNumber;
        if (connection.getChannelRpcTimeout() < 0) {
            throw new IllegalArgumentException("Continuation timeout on RPC calls cannot be less than 0");
        }
        this._rpcTimeout = connection.getChannelRpcTimeout();
        this._checkRpcResponseType = connection.willCheckRpcResponseType();
        this._trafficListener = connection.getTrafficListener();
        this.maxInboundMessageBodySize = connection.getMaxInboundMessageBodySize();
        this._command = new AMQCommand(this.maxInboundMessageBodySize);
    }

    public int getChannelNumber() {
        return this._channelNumber;
    }

    public void handleFrame(Frame frame) throws IOException {
        AMQCommand command = this._command;
        if (command.handleFrame(frame)) {
            this._command = new AMQCommand(this.maxInboundMessageBodySize);
            this.handleCompleteInboundCommand(command);
        }
    }

    public static IOException wrap(ShutdownSignalException ex) {
        return AMQChannel.wrap(ex, null);
    }

    public static IOException wrap(ShutdownSignalException ex, String message) {
        IOException ioe = new IOException(message);
        ioe.initCause(ex);
        return ioe;
    }

    public AMQCommand exnWrappingRpc(Method m) throws IOException {
        try {
            return this.privateRpc(m);
        }
        catch (AlreadyClosedException ace) {
            throw ace;
        }
        catch (ShutdownSignalException ex) {
            throw AMQChannel.wrap(ex);
        }
    }

    public CompletableFuture<Command> exnWrappingAsyncRpc(Method m) throws IOException {
        try {
            return this.privateAsyncRpc(m);
        }
        catch (AlreadyClosedException ace) {
            throw ace;
        }
        catch (ShutdownSignalException ex) {
            throw AMQChannel.wrap(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleCompleteInboundCommand(AMQCommand command) throws IOException {
        this._trafficListener.read(command);
        if (!this.processAsync(command)) {
            RpcWrapper nextOutstandingRpc;
            if (this._checkRpcResponseType) {
                Object object = this._channelMutex;
                synchronized (object) {
                    if (this._activeRpc != null && !this._activeRpc.canHandleReply(command)) {
                        return;
                    }
                }
            }
            if ((nextOutstandingRpc = this.nextOutstandingRpc()) != null) {
                nextOutstandingRpc.complete(command);
                this.markRpcFinished();
            }
        }
    }

    public void enqueueRpc(RpcContinuation k) {
        this.doEnqueueRpc(() -> new RpcContinuationRpcWrapper(k));
    }

    public void enqueueAsyncRpc(Method method, CompletableFuture<Command> future) {
        this.doEnqueueRpc(() -> new CompletableFutureRpcWrapper(method, future));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doEnqueueRpc(Supplier<RpcWrapper> rpcWrapperSupplier) {
        Object object = this._channelMutex;
        synchronized (object) {
            boolean waitClearedInterruptStatus = false;
            while (this._activeRpc != null) {
                try {
                    this._channelMutex.wait();
                }
                catch (InterruptedException e) {
                    waitClearedInterruptStatus = true;
                }
            }
            if (waitClearedInterruptStatus) {
                Thread.currentThread().interrupt();
            }
            this._activeRpc = rpcWrapperSupplier.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOutstandingRpc() {
        Object object = this._channelMutex;
        synchronized (object) {
            return this._activeRpc != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RpcWrapper nextOutstandingRpc() {
        Object object = this._channelMutex;
        synchronized (object) {
            RpcWrapper result = this._activeRpc;
            this._activeRpc = null;
            this._channelMutex.notifyAll();
            return result;
        }
    }

    protected void markRpcFinished() {
    }

    public void ensureIsOpen() throws AlreadyClosedException {
        if (!this.isOpen()) {
            throw new AlreadyClosedException(this.getCloseReason());
        }
    }

    public AMQCommand rpc(Method m) throws IOException, ShutdownSignalException {
        return this.privateRpc(m);
    }

    public AMQCommand rpc(Method m, int timeout) throws IOException, ShutdownSignalException, TimeoutException {
        return this.privateRpc(m, timeout);
    }

    private AMQCommand privateRpc(Method m) throws IOException, ShutdownSignalException {
        SimpleBlockingRpcContinuation k = new SimpleBlockingRpcContinuation(m);
        this.rpc(m, k);
        if (this._rpcTimeout == 0) {
            return (AMQCommand)k.getReply();
        }
        try {
            return (AMQCommand)k.getReply(this._rpcTimeout);
        }
        catch (TimeoutException e) {
            throw this.wrapTimeoutException(m, e);
        }
    }

    private void cleanRpcChannelState() {
        try {
            this.nextOutstandingRpc();
            this.markRpcFinished();
        }
        catch (Exception ex) {
            LOGGER.warn("Error while cleaning timed out channel RPC: {}", (Object)ex.getMessage());
        }
    }

    protected ChannelContinuationTimeoutException wrapTimeoutException(Method m, TimeoutException e) {
        this.cleanRpcChannelState();
        return new ChannelContinuationTimeoutException(e, this, this._channelNumber, m);
    }

    private CompletableFuture<Command> privateAsyncRpc(Method m) throws IOException, ShutdownSignalException {
        CompletableFuture<Command> future = new CompletableFuture<Command>();
        this.asyncRpc(m, future);
        return future;
    }

    private AMQCommand privateRpc(Method m, int timeout) throws IOException, ShutdownSignalException, TimeoutException {
        SimpleBlockingRpcContinuation k = new SimpleBlockingRpcContinuation(m);
        this.rpc(m, k);
        try {
            return (AMQCommand)k.getReply(timeout);
        }
        catch (TimeoutException e) {
            this.cleanRpcChannelState();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rpc(Method m, RpcContinuation k) throws IOException {
        Object object = this._channelMutex;
        synchronized (object) {
            this.ensureIsOpen();
            this.quiescingRpc(m, k);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void quiescingRpc(Method m, RpcContinuation k) throws IOException {
        Object object = this._channelMutex;
        synchronized (object) {
            this.enqueueRpc(k);
            this.quiescingTransmit(m);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void asyncRpc(Method m, CompletableFuture<Command> future) throws IOException {
        Object object = this._channelMutex;
        synchronized (object) {
            this.ensureIsOpen();
            this.quiescingAsyncRpc(m, future);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void quiescingAsyncRpc(Method m, CompletableFuture<Command> future) throws IOException {
        Object object = this._channelMutex;
        synchronized (object) {
            this.enqueueAsyncRpc(m, future);
            this.quiescingTransmit(m);
        }
    }

    public abstract boolean processAsync(Command var1) throws IOException;

    public String toString() {
        return "AMQChannel(" + this._connection + "," + this._channelNumber + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processShutdownSignal(ShutdownSignalException signal, boolean ignoreClosed, boolean notifyRpc) {
        try {
            Object object = this._channelMutex;
            synchronized (object) {
                if (!this.setShutdownCauseIfOpen(signal) && !ignoreClosed) {
                    throw new AlreadyClosedException(this.getCloseReason());
                }
                this._channelMutex.notifyAll();
            }
        }
        finally {
            if (notifyRpc) {
                this.notifyOutstandingRpc(signal);
            }
        }
    }

    public void notifyOutstandingRpc(ShutdownSignalException signal) {
        RpcWrapper k = this.nextOutstandingRpc();
        if (k != null) {
            k.shutdown(signal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transmit(Method m) throws IOException {
        Object object = this._channelMutex;
        synchronized (object) {
            this.transmit(new AMQCommand(m));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transmit(AMQCommand c) throws IOException {
        Object object = this._channelMutex;
        synchronized (object) {
            this.ensureIsOpen();
            this.quiescingTransmit(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void quiescingTransmit(Method m) throws IOException {
        Object object = this._channelMutex;
        synchronized (object) {
            this.quiescingTransmit(new AMQCommand(m));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void quiescingTransmit(AMQCommand c) throws IOException {
        Object object = this._channelMutex;
        synchronized (object) {
            if (c.getMethod().hasContent()) {
                while (this._blockContent) {
                    try {
                        this._channelMutex.wait();
                    }
                    catch (InterruptedException ignored) {
                        Thread.currentThread().interrupt();
                    }
                    this.ensureIsOpen();
                }
            }
            this._trafficListener.write(c);
            c.transmit(this);
        }
    }

    public AMQConnection getConnection() {
        return this._connection;
    }

    public static class SimpleBlockingRpcContinuation
    extends BlockingRpcContinuation<AMQCommand> {
        public SimpleBlockingRpcContinuation() {
        }

        public SimpleBlockingRpcContinuation(Method method) {
            super(method);
        }

        @Override
        public AMQCommand transformReply(AMQCommand command) {
            return command;
        }
    }

    public static abstract class BlockingRpcContinuation<T>
    implements RpcContinuation {
        public final BlockingValueOrException<T, ShutdownSignalException> _blocker = new BlockingValueOrException();
        protected final Method request;

        public BlockingRpcContinuation() {
            this.request = null;
        }

        public BlockingRpcContinuation(Method request) {
            this.request = request;
        }

        @Override
        public void handleCommand(AMQCommand command) {
            this._blocker.setValue(this.transformReply(command));
        }

        @Override
        public void handleShutdownSignal(ShutdownSignalException signal) {
            this._blocker.setException(signal);
        }

        public T getReply() throws ShutdownSignalException {
            return this._blocker.uninterruptibleGetValue();
        }

        public T getReply(int timeout) throws ShutdownSignalException, TimeoutException {
            return this._blocker.uninterruptibleGetValue(timeout);
        }

        @Override
        public boolean canHandleReply(AMQCommand command) {
            return BlockingRpcContinuation.isResponseCompatibleWithRequest(this.request, command.getMethod());
        }

        public abstract T transformReply(AMQCommand var1);

        public static boolean isResponseCompatibleWithRequest(Method request, Method response) {
            if (request != null) {
                if (request instanceof AMQP.Basic.Qos) {
                    return response instanceof AMQP.Basic.QosOk;
                }
                if (request instanceof AMQP.Basic.Get) {
                    return response instanceof AMQP.Basic.GetOk || response instanceof AMQP.Basic.GetEmpty;
                }
                if (request instanceof AMQP.Basic.Consume) {
                    if (!(response instanceof AMQP.Basic.ConsumeOk)) {
                        return false;
                    }
                    String consumerTag = ((AMQP.Basic.Consume)request).getConsumerTag();
                    return consumerTag == null || consumerTag.equals("") || consumerTag.equals(((AMQP.Basic.ConsumeOk)response).getConsumerTag());
                }
                if (request instanceof AMQP.Basic.Cancel) {
                    if (!(response instanceof AMQP.Basic.CancelOk)) {
                        return false;
                    }
                    return ((AMQP.Basic.Cancel)request).getConsumerTag().equals(((AMQP.Basic.CancelOk)response).getConsumerTag());
                }
                if (request instanceof AMQP.Basic.Recover) {
                    return response instanceof AMQP.Basic.RecoverOk;
                }
                if (request instanceof AMQP.Exchange.Declare) {
                    return response instanceof AMQP.Exchange.DeclareOk;
                }
                if (request instanceof AMQP.Exchange.Delete) {
                    return response instanceof AMQP.Exchange.DeleteOk;
                }
                if (request instanceof AMQP.Exchange.Bind) {
                    return response instanceof AMQP.Exchange.BindOk;
                }
                if (request instanceof AMQP.Exchange.Unbind) {
                    return response instanceof AMQP.Exchange.UnbindOk;
                }
                if (request instanceof AMQP.Queue.Declare) {
                    return response instanceof AMQP.Queue.DeclareOk;
                }
                if (request instanceof AMQP.Queue.Delete) {
                    return response instanceof AMQP.Queue.DeleteOk;
                }
                if (request instanceof AMQP.Queue.Bind) {
                    return response instanceof AMQP.Queue.BindOk;
                }
                if (request instanceof AMQP.Queue.Unbind) {
                    return response instanceof AMQP.Queue.UnbindOk;
                }
                if (request instanceof AMQP.Queue.Purge) {
                    return response instanceof AMQP.Queue.PurgeOk;
                }
                if (request instanceof AMQP.Tx.Select) {
                    return response instanceof AMQP.Tx.SelectOk;
                }
                if (request instanceof AMQP.Tx.Commit) {
                    return response instanceof AMQP.Tx.CommitOk;
                }
                if (request instanceof AMQP.Tx.Rollback) {
                    return response instanceof AMQP.Tx.RollbackOk;
                }
                if (request instanceof AMQP.Confirm.Select) {
                    return response instanceof AMQP.Confirm.SelectOk;
                }
            }
            return true;
        }
    }

    public static interface RpcContinuation {
        public void handleCommand(AMQCommand var1);

        public boolean canHandleReply(AMQCommand var1);

        public void handleShutdownSignal(ShutdownSignalException var1);
    }
}

