/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client;

import com.rabbitmq.client.ConnectionContext;
import com.rabbitmq.client.ConnectionPostProcessor;
import java.io.IOException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;

public abstract class ConnectionPostProcessors {
    public static AbstractConnectionPostProcessor hostnameVerificationConnectionPostProcessor(HostnameVerifier verifier) {
        return new HostnameVerificationConnectionPostProcessor(verifier);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private AbstractConnectionPostProcessor postProcessor = new AbstractConnectionPostProcessor(){

            @Override
            public void postProcess(ConnectionContext context) {
            }
        };

        public Builder enableHostnameVerification(HostnameVerifier hostnameVerifier) {
            this.postProcessor = this.postProcessor.andThen(ConnectionPostProcessors.hostnameVerificationConnectionPostProcessor(hostnameVerifier));
            return this;
        }

        public Builder add(ConnectionPostProcessor connectionPostProcessor) {
            this.postProcessor = this.postProcessor.andThen(connectionPostProcessor);
            return this;
        }

        public ConnectionPostProcessor build() {
            return this.postProcessor;
        }
    }

    public static abstract class AbstractConnectionPostProcessor
    implements ConnectionPostProcessor {
        public AbstractConnectionPostProcessor andThen(final ConnectionPostProcessor after) {
            if (after == null) {
                throw new NullPointerException();
            }
            return new AbstractConnectionPostProcessor(){

                @Override
                public void postProcess(ConnectionContext t) throws IOException {
                    AbstractConnectionPostProcessor.this.postProcess(t);
                    after.postProcess(t);
                }
            };
        }
    }

    private static class HostnameVerificationConnectionPostProcessor
    extends AbstractConnectionPostProcessor {
        private final HostnameVerifier verifier;

        private HostnameVerificationConnectionPostProcessor(HostnameVerifier verifier) {
            this.verifier = verifier;
        }

        @Override
        public void postProcess(ConnectionContext context) throws IOException {
            String hostname;
            SSLSession sslSession = context.getSslSession();
            if (sslSession == null && context.getSocket() instanceof SSLSocket) {
                sslSession = ((SSLSocket)context.getSocket()).getSession();
            }
            if (sslSession != null && !this.verifier.verify(hostname = context.getAddress().getHost(), sslSession)) {
                throw new SSLHandshakeException("Hostname " + hostname + " does not match TLS certificate SAN or CN");
            }
        }
    }
}

