/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.codegen.utils;

import com.querydsl.codegen.utils.AbstractCodeWriter;
import com.querydsl.codegen.utils.CodeWriter;
import com.querydsl.codegen.utils.CodegenException;
import com.querydsl.codegen.utils.MultiSuppressWarnings;
import com.querydsl.codegen.utils.StringUtils;
import com.querydsl.codegen.utils.model.Parameter;
import com.querydsl.codegen.utils.model.Type;
import com.querydsl.codegen.utils.model.Types;
import com.querydsl.codegen.utils.support.ScalaSyntaxUtils;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;

public class ScalaWriter
extends AbstractCodeWriter<ScalaWriter> {
    private static final Set<String> PRIMITIVE_TYPES = new HashSet<String>(Arrays.asList("boolean", "byte", "char", "int", "long", "short", "double", "float"));
    private static final String DEF = "def ";
    private static final String OVERRIDE_DEF = "override def ";
    private static final String EXTENDS = " extends ";
    private static final String WITH = " with ";
    private static final String IMPORT = "import ";
    private static final String IMPORT_STATIC = "import ";
    private static final String PACKAGE = "package ";
    private static final String PRIVATE = "private ";
    private static final String PRIVATE_VAL = "private val ";
    private static final String PROTECTED = "protected ";
    private static final String PROTECTED_VAL = "protected val ";
    private static final String PUBLIC = "public ";
    private static final String PUBLIC_CLASS = "class ";
    private static final String PUBLIC_OBJECT = "object ";
    private static final String CASE_CLASS = "case class ";
    private static final String VAR = "var ";
    private static final String VAL = "val ";
    private static final String THIS = "this";
    private static final String TRAIT = "trait ";
    private final Set<String> classes = new HashSet<String>();
    private final Set<String> packages = new HashSet<String>();
    private Type type;
    private final boolean compact;

    public ScalaWriter(Appendable appendable) {
        this(appendable, false);
    }

    public ScalaWriter(Appendable appendable, boolean compact) {
        super(appendable, 2);
        this.classes.add("java.lang.String");
        this.classes.add("java.lang.Object");
        this.classes.add("java.lang.Integer");
        this.classes.add("java.lang.Comparable");
        this.compact = compact;
    }

    @Override
    public ScalaWriter annotation(Annotation annotation) throws IOException {
        ((ScalaWriter)((ScalaWriter)this.beginLine(new String[0])).append("@")).appendType(annotation.annotationType());
        Method[] methods = annotation.annotationType().getDeclaredMethods();
        if (methods.length == 1 && methods[0].getName().equals("value")) {
            try {
                Object value = methods[0].invoke((Object)annotation, new Object[0]);
                this.append("(");
                this.annotationConstant(value);
                this.append(")");
            }
            catch (IllegalArgumentException e) {
                throw new CodegenException(e);
            }
            catch (IllegalAccessException e) {
                throw new CodegenException(e);
            }
            catch (InvocationTargetException e) {
                throw new CodegenException(e);
            }
        }
        boolean first = true;
        for (Method method : methods) {
            try {
                Object value = method.invoke((Object)annotation, new Object[0]);
                if (value == null || value.equals(method.getDefaultValue()) || value.getClass().isArray() && Arrays.equals((Object[])value, (Object[])method.getDefaultValue())) continue;
                if (!first) {
                    this.append(", ");
                } else {
                    this.append("(");
                }
                ((ScalaWriter)this.append(this.escape(method.getName()))).append("=");
                this.annotationConstant(value);
            }
            catch (IllegalArgumentException e) {
                throw new CodegenException(e);
            }
            catch (IllegalAccessException e) {
                throw new CodegenException(e);
            }
            catch (InvocationTargetException e) {
                throw new CodegenException(e);
            }
            first = false;
        }
        if (!first) {
            this.append(")");
        }
        return (ScalaWriter)this.nl();
    }

    @Override
    public ScalaWriter annotation(Class<? extends Annotation> annotation) throws IOException {
        return (ScalaWriter)((ScalaWriter)((ScalaWriter)this.beginLine(new String[0])).append("@")).appendType(annotation).nl();
    }

    private void annotationConstant(Object value) throws IOException {
        if (value.getClass().isArray()) {
            this.append("Array(");
            boolean first = true;
            for (Object o : (Object[])value) {
                if (!first) {
                    this.append(", ");
                }
                this.annotationConstant(o);
                first = false;
            }
            this.append(")");
        } else if (value instanceof Class) {
            this.append("classOf[");
            this.appendType((Class)value);
            this.append("]");
        } else if (value instanceof Number || value instanceof Boolean) {
            this.append(value.toString());
        } else if (value instanceof Enum) {
            Enum enumValue = (Enum)value;
            if (this.classes.contains(enumValue.getClass().getName()) || this.packages.contains(enumValue.getClass().getPackage().getName())) {
                this.append(enumValue.name());
            } else {
                ((ScalaWriter)((ScalaWriter)this.append(enumValue.getDeclaringClass().getName())).append(".")).append(enumValue.name());
            }
        } else if (value instanceof String) {
            ((ScalaWriter)((ScalaWriter)this.append("\"")).append(StringUtils.escapeJava(value.toString()))).append("\"");
        } else {
            throw new IllegalArgumentException("Unsupported annotation value : " + value);
        }
    }

    private ScalaWriter appendType(Class<?> type) throws IOException {
        if (type.isPrimitive()) {
            this.append(StringUtils.capitalize(type.getName()));
        } else if (type.getPackage() == null || this.classes.contains(type.getName()) || this.packages.contains(type.getPackage().getName())) {
            this.append(type.getSimpleName());
        } else {
            this.append(type.getName());
        }
        return this;
    }

    public ScalaWriter beginObject(String header) throws IOException {
        this.line(new String[]{PUBLIC_OBJECT, header, " {"});
        this.goIn();
        return this;
    }

    public ScalaWriter beginClass(String header) throws IOException {
        this.line(new String[]{PUBLIC_CLASS, header, " {"});
        this.goIn();
        return this;
    }

    @Override
    public ScalaWriter beginClass(Type type) throws IOException {
        return this.beginClass(type, null, new Type[0]);
    }

    @Override
    public ScalaWriter beginClass(Type type, Type superClass, Type ... interfaces) throws IOException {
        this.packages.add(type.getPackageName());
        this.beginLine(new String[]{PUBLIC_CLASS, this.getGenericName(false, type)});
        if (superClass != null) {
            ((ScalaWriter)this.append(EXTENDS)).append(this.getGenericName(false, superClass));
        }
        if (interfaces.length > 0) {
            if (superClass == null) {
                this.append(EXTENDS);
                this.append(this.getGenericName(false, interfaces[0]));
                this.append(WITH);
                for (int i = 1; i < interfaces.length; ++i) {
                    if (i > 1) {
                        this.append(", ");
                    }
                    this.append(this.getGenericName(false, interfaces[i]));
                }
            } else {
                this.append(WITH);
                for (int i = 0; i < interfaces.length; ++i) {
                    if (i > 0) {
                        this.append(", ");
                    }
                    this.append(this.getGenericName(false, interfaces[i]));
                }
            }
        }
        ((ScalaWriter)((ScalaWriter)this.append(" {")).nl()).nl();
        this.goIn();
        this.type = type;
        return this;
    }

    @Override
    public <T> ScalaWriter beginConstructor(Collection<T> parameters, Function<T, Parameter> transformer) throws IOException {
        ((ScalaWriter)((ScalaWriter)this.beginLine(new String[]{DEF, THIS})).params(parameters, transformer).append(" {")).nl();
        return (ScalaWriter)this.goIn();
    }

    @Override
    public ScalaWriter beginConstructor(Parameter ... params) throws IOException {
        ((ScalaWriter)((ScalaWriter)this.beginLine(new String[]{DEF, THIS})).params(params).append(" {")).nl();
        return (ScalaWriter)this.goIn();
    }

    @Override
    public ScalaWriter beginInterface(Type type, Type ... interfaces) throws IOException {
        this.packages.add(type.getPackageName());
        this.beginLine(new String[]{TRAIT, this.getGenericName(false, type)});
        if (interfaces.length > 0) {
            this.append(EXTENDS);
            this.append(this.getGenericName(false, interfaces[0]));
            if (interfaces.length > 1) {
                this.append(WITH);
                for (int i = 1; i < interfaces.length; ++i) {
                    if (i > 1) {
                        this.append(", ");
                    }
                    this.append(this.getGenericName(false, interfaces[i]));
                }
            }
        }
        ((ScalaWriter)((ScalaWriter)this.append(" {")).nl()).nl();
        this.goIn();
        this.type = type;
        return this;
    }

    private ScalaWriter beginMethod(String modifiers, Type returnType, String methodName, Parameter ... args) throws IOException {
        if (returnType.equals(Types.VOID)) {
            ((ScalaWriter)((ScalaWriter)this.beginLine(new String[]{modifiers, this.escape(methodName)})).params(args).append(" {")).nl();
        } else {
            ((ScalaWriter)((ScalaWriter)((ScalaWriter)((ScalaWriter)this.beginLine(new String[]{modifiers, this.escape(methodName)})).params(args).append(": ")).append(this.getGenericName(true, returnType))).append(" = {")).nl();
        }
        return (ScalaWriter)this.goIn();
    }

    @Override
    public <T> ScalaWriter beginPublicMethod(Type returnType, String methodName, Collection<T> parameters, Function<T, Parameter> transformer) throws IOException {
        return this.beginMethod(DEF, returnType, methodName, this.transform(parameters, transformer));
    }

    @Override
    public ScalaWriter beginPublicMethod(Type returnType, String methodName, Parameter ... args) throws IOException {
        return this.beginMethod(DEF, returnType, methodName, args);
    }

    public <T> ScalaWriter beginOverridePublicMethod(Type returnType, String methodName, Collection<T> parameters, Function<T, Parameter> transformer) throws IOException {
        return this.beginMethod(OVERRIDE_DEF, returnType, methodName, this.transform(parameters, transformer));
    }

    public ScalaWriter beginOverridePublicMethod(Type returnType, String methodName, Parameter ... args) throws IOException {
        return this.beginMethod(OVERRIDE_DEF, returnType, methodName, args);
    }

    @Override
    public <T> ScalaWriter beginStaticMethod(Type returnType, String methodName, Collection<T> parameters, Function<T, Parameter> transformer) throws IOException {
        return this.beginMethod(DEF, returnType, methodName, this.transform(parameters, transformer));
    }

    @Override
    public ScalaWriter beginStaticMethod(Type returnType, String methodName, Parameter ... args) throws IOException {
        return this.beginMethod(DEF, returnType, methodName, args);
    }

    public ScalaWriter caseClass(String header, Parameter ... parameters) throws IOException {
        ((ScalaWriter)this.beginLine(new String[]{CASE_CLASS, header})).params(parameters).nl();
        return this;
    }

    @Override
    public ScalaWriter end() throws IOException {
        this.goOut();
        return (ScalaWriter)((ScalaWriter)this.line(new String[]{"}"})).nl();
    }

    @Override
    public ScalaWriter field(Type type, String name) throws IOException {
        this.line(new String[]{VAR, this.escape(name), ": ", this.getGenericName(true, type)});
        return this.compact ? this : (ScalaWriter)this.nl();
    }

    private ScalaWriter field(String modifier, Type type, String name) throws IOException {
        this.line(new String[]{modifier, this.escape(name), ": ", this.getGenericName(true, type)});
        return this.compact ? this : (ScalaWriter)this.nl();
    }

    private ScalaWriter field(String modifier, Type type, String name, String value) throws IOException {
        this.line(new String[]{modifier, this.escape(name), ": ", this.getGenericName(true, type), " = ", value});
        return this.compact ? this : (ScalaWriter)this.nl();
    }

    @Override
    public String getClassConstant(String className) {
        return "classOf[" + className + "]";
    }

    @Override
    public String getGenericName(boolean asArgType, Type type) {
        if (type.getParameters().isEmpty()) {
            return this.getRawName(type);
        }
        StringBuilder builder = new StringBuilder();
        builder.append(this.getRawName(type));
        builder.append("[");
        boolean first = true;
        String fullName = type.getFullName();
        for (Type parameter : type.getParameters()) {
            if (!first) {
                builder.append(", ");
            }
            if (parameter == null || parameter.getFullName().equals(fullName)) {
                builder.append("_");
            } else {
                builder.append(this.getGenericName(false, parameter));
            }
            first = false;
        }
        builder.append("]");
        return builder.toString();
    }

    @Override
    public String getRawName(Type type) {
        String packageName;
        String fullName = type.getFullName();
        if (PRIMITIVE_TYPES.contains(fullName)) {
            fullName = StringUtils.capitalize(fullName);
        }
        fullName = (packageName = type.getPackageName()) != null && packageName.length() > 0 ? packageName + "." + fullName.substring(packageName.length() + 1).replace('.', '$') : fullName.replace('.', '$');
        String rv = fullName;
        if (type.isPrimitive() && packageName.isEmpty()) {
            rv = Character.toUpperCase(rv.charAt(0)) + rv.substring(1);
        }
        if ((this.packages.contains(packageName) || this.classes.contains(fullName)) && packageName.length() > 0) {
            rv = fullName.substring(packageName.length() + 1);
        }
        if (rv.endsWith("[]")) {
            if (PRIMITIVE_TYPES.contains(rv = rv.substring(0, rv.length() - 2))) {
                rv = StringUtils.capitalize(rv);
            } else if (this.classes.contains(rv)) {
                rv = rv.substring(packageName.length() + 1);
            }
            return "Array[" + rv + "]";
        }
        return rv;
    }

    @Override
    public ScalaWriter imports(Class<?> ... imports) throws IOException {
        for (Class<?> cl : imports) {
            this.classes.add(cl.getName());
            this.line(new String[]{"import ", cl.getName()});
        }
        this.nl();
        return this;
    }

    @Override
    public ScalaWriter imports(Package ... imports) throws IOException {
        for (Package p : imports) {
            this.packages.add(p.getName());
            this.line(new String[]{"import ", p.getName(), "._"});
        }
        this.nl();
        return this;
    }

    @Override
    public ScalaWriter importClasses(String ... imports) throws IOException {
        for (String cl : imports) {
            this.classes.add(cl);
            this.line(new String[]{"import ", cl});
        }
        this.nl();
        return this;
    }

    @Override
    public ScalaWriter importPackages(String ... imports) throws IOException {
        for (String p : imports) {
            this.packages.add(p);
            this.line(new String[]{"import ", p, "._"});
        }
        this.nl();
        return this;
    }

    @Override
    public ScalaWriter javadoc(String ... lines) throws IOException {
        this.line(new String[]{"/**"});
        for (String line : lines) {
            this.line(new String[]{" * ", line});
        }
        return (ScalaWriter)this.line(new String[]{" */"});
    }

    @Override
    public ScalaWriter packageDecl(String packageName) throws IOException {
        this.packages.add(packageName);
        return (ScalaWriter)((ScalaWriter)this.line(new String[]{PACKAGE, packageName})).nl();
    }

    private <T> ScalaWriter params(Collection<T> parameters, Function<T, Parameter> transformer) throws IOException {
        this.append("(");
        boolean first = true;
        for (T param : parameters) {
            if (!first) {
                this.append(", ");
            }
            this.param(transformer.apply(param));
            first = false;
        }
        this.append(")");
        return this;
    }

    private ScalaWriter params(Parameter ... params) throws IOException {
        this.append("(");
        for (int i = 0; i < params.length; ++i) {
            if (i > 0) {
                this.append(", ");
            }
            this.param(params[i]);
        }
        this.append(")");
        return this;
    }

    private ScalaWriter param(Parameter parameter) throws IOException {
        this.append(this.escape(parameter.getName()));
        this.append(": ");
        this.append(this.getGenericName(true, parameter.getType()));
        return this;
    }

    @Override
    public ScalaWriter privateField(Type type, String name) throws IOException {
        return this.field(PRIVATE, type, name);
    }

    @Override
    public ScalaWriter privateFinal(Type type, String name) throws IOException {
        return this.field(PRIVATE_VAL, type, name);
    }

    @Override
    public ScalaWriter privateFinal(Type type, String name, String value) throws IOException {
        return this.field(PRIVATE_VAL, type, name, value);
    }

    @Override
    public ScalaWriter privateStaticFinal(Type type, String name, String value) throws IOException {
        return this.field(PRIVATE_VAL, type, name, value);
    }

    @Override
    public ScalaWriter protectedField(Type type, String name) throws IOException {
        return this.field(PROTECTED, type, name);
    }

    @Override
    public ScalaWriter protectedFinal(Type type, String name) throws IOException {
        return this.field(PROTECTED_VAL, type, name);
    }

    @Override
    public ScalaWriter protectedFinal(Type type, String name, String value) throws IOException {
        return this.field(PROTECTED_VAL, type, name, value);
    }

    @Override
    public ScalaWriter publicField(Type type, String name) throws IOException {
        return this.field(VAR, type, name);
    }

    @Override
    public ScalaWriter publicField(Type type, String name, String value) throws IOException {
        return this.field(VAR, type, name, value);
    }

    @Override
    public ScalaWriter publicFinal(Type type, String name) throws IOException {
        return this.field(VAL, type, name);
    }

    @Override
    public ScalaWriter publicFinal(Type type, String name, String value) throws IOException {
        return this.field(VAL, type, name, value);
    }

    @Override
    public ScalaWriter publicStaticFinal(Type type, String name, String value) throws IOException {
        return this.field(VAL, type, name, value);
    }

    @Override
    public ScalaWriter staticimports(Class<?> ... imports) throws IOException {
        for (Class<?> cl : imports) {
            this.line(new String[]{"import ", cl.getName(), "._;"});
        }
        return this;
    }

    @Override
    public ScalaWriter suppressWarnings(String type) throws IOException {
        return (ScalaWriter)this.line(new String[]{"@SuppressWarnings(\"", type, "\")"});
    }

    @Override
    public CodeWriter suppressWarnings(String ... types) throws IOException {
        return this.annotation(new MultiSuppressWarnings(types));
    }

    private <T> Parameter[] transform(Collection<T> parameters, Function<T, Parameter> transformer) {
        Parameter[] rv = new Parameter[parameters.size()];
        int i = 0;
        for (T value : parameters) {
            rv[i++] = transformer.apply(value);
        }
        return rv;
    }

    private String escape(String token) {
        if (ScalaSyntaxUtils.isReserved(token)) {
            return "`" + token + "`";
        }
        return token;
    }
}

