/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.utils;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import com.qcloud.cos.internal.CosServiceRequest;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum CIJackson {

    private static final Logger LOG = LoggerFactory.getLogger(CIJackson.class);
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final ObjectWriter writer;

    private static Set<String> getFieldsToFilter(Class cosServiceRequestClass) {
        Field[] declaredFields;
        HashSet<String> fieldNames = new HashSet<String>();
        for (Field declaredField : declaredFields = cosServiceRequestClass.getDeclaredFields()) {
            String name = declaredField.getName();
            String fieldNameCapitalized = CIJackson.capitalizeFirstLetter(name);
            fieldNames.add(fieldNameCapitalized);
        }
        fieldNames.add("ReadLimit");
        fieldNames.add("CloneRoot");
        fieldNames.add("GeneralProgressListener");
        fieldNames.add("RequestId");
        fieldNames.add("BucketName");
        return fieldNames;
    }

    public static String toJsonString(Object value) {
        try {
            return writer.writeValueAsString(value);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static byte[] toJsonBytes(Object value) {
        try {
            return writer.writeValueAsString(value).getBytes(StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private static String capitalizeFirstLetter(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        return Character.toUpperCase(str.charAt(0)) + str.substring(1);
    }

    static {
        objectMapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        objectMapper.setPropertyNamingStrategy(PropertyNamingStrategy.PASCAL_CASE_TO_CAMEL_CASE);
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        SimpleBeanPropertyFilter filter = SimpleBeanPropertyFilter.serializeAllExcept(CIJackson.getFieldsToFilter(CosServiceRequest.class));
        SimpleFilterProvider filters = new SimpleFilterProvider().addFilter("CosServiceFilter", filter);
        objectMapper.setFilterProvider((FilterProvider)filters);
        writer = objectMapper.writer();
    }
}

