/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.internal.cihandler;

import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.internal.XmlResponsesSaxParser;
import com.qcloud.cos.internal.cihandler.CharacterFilter;
import com.qcloud.cos.utils.StringUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class CIXmlResponsesSaxParser {
    private static final Logger log = LoggerFactory.getLogger(XmlResponsesSaxParser.class);
    private XMLReader xr = null;

    public CIXmlResponsesSaxParser() {
        try {
            this.xr = XMLReaderFactory.createXMLReader();
        }
        catch (SAXException e) {
            throw new CosClientException("Couldn't initialize a SAX driver to create an XMLReader", e);
        }
    }

    public void parseXmlInputStream(DefaultHandler handler, InputStream inputStream) throws IOException {
        try {
            if (log.isDebugEnabled()) {
                log.debug("Parsing XML response document with handler: " + handler.getClass());
            }
            BufferedReader breader = new BufferedReader(new InputStreamReader(inputStream, StringUtils.UTF8));
            CharacterFilter characterFilter = new CharacterFilter(breader);
            this.xr.setContentHandler(handler);
            this.xr.setErrorHandler(handler);
            this.xr.parse(new InputSource(characterFilter));
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable t) {
            block6: {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    if (!log.isErrorEnabled()) break block6;
                    log.error("Unable to close response InputStream up after XML parse failure", (Throwable)e);
                }
            }
            throw new CosClientException("Failed to parse XML document with handler " + handler.getClass(), t);
        }
    }
}

