/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.thirdparty.org.bouncycastle.crypto.ec;

import com.qcloud.cos.thirdparty.org.bouncycastle.crypto.CipherParameters;
import com.qcloud.cos.thirdparty.org.bouncycastle.crypto.ec.ECEncryptor;
import com.qcloud.cos.thirdparty.org.bouncycastle.crypto.ec.ECPair;
import com.qcloud.cos.thirdparty.org.bouncycastle.crypto.ec.ECUtil;
import com.qcloud.cos.thirdparty.org.bouncycastle.crypto.params.ECDomainParameters;
import com.qcloud.cos.thirdparty.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.qcloud.cos.thirdparty.org.bouncycastle.crypto.params.ParametersWithRandom;
import com.qcloud.cos.thirdparty.org.bouncycastle.math.ec.ECMultiplier;
import com.qcloud.cos.thirdparty.org.bouncycastle.math.ec.ECPoint;
import com.qcloud.cos.thirdparty.org.bouncycastle.math.ec.FixedPointCombMultiplier;
import java.math.BigInteger;
import java.security.SecureRandom;

public class ECElGamalEncryptor
implements ECEncryptor {
    private ECPublicKeyParameters key;
    private SecureRandom random;

    public void init(CipherParameters cipherParameters) {
        if (cipherParameters instanceof ParametersWithRandom) {
            ParametersWithRandom parametersWithRandom = (ParametersWithRandom)cipherParameters;
            if (!(parametersWithRandom.getParameters() instanceof ECPublicKeyParameters)) {
                throw new IllegalArgumentException("ECPublicKeyParameters are required for encryption.");
            }
            this.key = (ECPublicKeyParameters)parametersWithRandom.getParameters();
            this.random = parametersWithRandom.getRandom();
        } else {
            if (!(cipherParameters instanceof ECPublicKeyParameters)) {
                throw new IllegalArgumentException("ECPublicKeyParameters are required for encryption.");
            }
            this.key = (ECPublicKeyParameters)cipherParameters;
            this.random = new SecureRandom();
        }
    }

    public ECPair encrypt(ECPoint eCPoint) {
        if (this.key == null) {
            throw new IllegalStateException("ECElGamalEncryptor not initialised");
        }
        ECDomainParameters eCDomainParameters = this.key.getParameters();
        BigInteger bigInteger = ECUtil.generateK(eCDomainParameters.getN(), this.random);
        ECMultiplier eCMultiplier = this.createBasePointMultiplier();
        ECPoint[] eCPointArray = new ECPoint[]{eCMultiplier.multiply(eCDomainParameters.getG(), bigInteger), this.key.getQ().multiply(bigInteger).add(eCPoint)};
        eCDomainParameters.getCurve().normalizeAll(eCPointArray);
        return new ECPair(eCPointArray[0], eCPointArray[1]);
    }

    protected ECMultiplier createBasePointMultiplier() {
        return new FixedPointCombMultiplier();
    }
}

