/*
 * Decompiled with CFR 0.152.
 */
package com.pyx4j.log4j;

import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.logging.Log;

public class MavenLogAppender
extends AppenderSkeleton {
    private static Log mavenLog;

    public static void startPluginLog(AbstractMojo mojo) {
        mavenLog = mojo.getLog();
    }

    public static void endPluginLog(AbstractMojo mojo) {
        mavenLog = null;
    }

    protected void append(LoggingEvent event) {
        if (mavenLog == null) {
            return;
        }
        Level level = event.getLevel();
        if (Level.DEBUG.equals((Object)level) && !mavenLog.isDebugEnabled()) {
            return;
        }
        String text = this.layout.format(event);
        Throwable throwable = null;
        if (event.getThrowableInformation() != null) {
            throwable = event.getThrowableInformation().getThrowable();
        }
        if (Level.DEBUG.equals((Object)level) || Level.TRACE.equals((Object)level)) {
            mavenLog.debug((CharSequence)text, throwable);
        } else if (Level.INFO.equals((Object)level)) {
            mavenLog.info((CharSequence)text, throwable);
        } else if (Level.WARN.equals((Object)level)) {
            mavenLog.warn((CharSequence)text, throwable);
        } else if (Level.ERROR.equals((Object)level) || Level.FATAL.equals((Object)level)) {
            mavenLog.error((CharSequence)text, throwable);
        } else {
            mavenLog.error((CharSequence)text, throwable);
        }
    }

    public void close() {
        mavenLog = null;
    }

    public boolean requiresLayout() {
        return true;
    }
}

