/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.naming;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.naming.AbstractNameCheck;
import com.puppycrawl.tools.checkstyle.checks.naming.AccessModifierOption;
import com.puppycrawl.tools.checkstyle.utils.CheckUtil;
import com.puppycrawl.tools.checkstyle.utils.ScopeUtil;
import java.util.Arrays;
import java.util.Optional;

public class ParameterNameCheck
extends AbstractNameCheck {
    private boolean ignoreOverridden;
    private AccessModifierOption[] accessModifiers = new AccessModifierOption[]{AccessModifierOption.PUBLIC, AccessModifierOption.PROTECTED, AccessModifierOption.PACKAGE, AccessModifierOption.PRIVATE};

    public ParameterNameCheck() {
        super("^[a-z][a-zA-Z0-9]*$");
    }

    public void setIgnoreOverridden(boolean ignoreOverridden) {
        this.ignoreOverridden = ignoreOverridden;
    }

    public void setAccessModifiers(AccessModifierOption ... accessModifiers) {
        this.accessModifiers = Arrays.copyOf(accessModifiers, accessModifiers.length);
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{21};
    }

    @Override
    protected boolean mustCheckName(DetailAST ast) {
        boolean checkName = true;
        if (this.ignoreOverridden && ParameterNameCheck.isOverriddenMethod(ast) || ast.getParent().getType() == 96 || ast.getParent().getParent().getType() == 181 || CheckUtil.isReceiverParameter(ast) || !this.matchAccessModifiers(ParameterNameCheck.getAccessModifier(ast))) {
            checkName = false;
        }
        return checkName;
    }

    private static AccessModifierOption getAccessModifier(DetailAST ast) {
        AccessModifierOption accessModifier;
        if (ScopeUtil.isInInterfaceOrAnnotationBlock(ast)) {
            accessModifier = AccessModifierOption.PUBLIC;
        } else {
            DetailAST params = ast.getParent();
            DetailAST meth = params.getParent();
            DetailAST modsToken = meth.findFirstToken(5);
            accessModifier = CheckUtil.getAccessModifierFromModifiersToken(modsToken);
        }
        return accessModifier;
    }

    private boolean matchAccessModifiers(AccessModifierOption accessModifier) {
        return Arrays.stream(this.accessModifiers).anyMatch(modifier -> modifier == accessModifier);
    }

    private static boolean isOverriddenMethod(DetailAST ast) {
        Optional<DetailAST> overrideToken;
        boolean overridden = false;
        DetailAST parent = ast.getParent().getParent();
        Optional<DetailAST> annotation = Optional.ofNullable(parent.getFirstChild().getFirstChild());
        if (annotation.isPresent() && (overrideToken = Optional.ofNullable(annotation.get().findFirstToken(58))).isPresent() && "Override".equals(overrideToken.get().getText())) {
            overridden = true;
        }
        return overridden;
    }
}

