/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks;

import com.puppycrawl.tools.checkstyle.FileStatefulCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.TextBlock;
import com.puppycrawl.tools.checkstyle.utils.CheckUtil;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@FileStatefulCheck
public class AvoidEscapedUnicodeCharactersCheck
extends AbstractCheck {
    public static final String MSG_KEY = "forbid.escaped.unicode.char";
    private static final Pattern UNICODE_REGEXP = Pattern.compile("\\\\u+[a-fA-F0-9]{4}");
    private static final Pattern UNICODE_CONTROL = Pattern.compile("\\\\u+(00[0-1][0-9A-Fa-f]|00[8-9][0-9A-Fa-f]|00[aA][dD]|034[fF]|070[fF]|180[eE]|200[b-fB-F]|202[a-eA-E]|206[0-4a-fA-F]|[fF]{3}[9a-bA-B]|[fF][eE][fF]{2})");
    private static final Pattern ALL_ESCAPED_CHARS = Pattern.compile("^(" + UNICODE_REGEXP.pattern() + "|\"|'|\\\\|\\\\b|\\\\f|\\\\n|\\\\r|\\\\s|\\\\t)+$");
    private static final Pattern ESCAPED_BACKSLASH = Pattern.compile("\\\\\\\\");
    private static final Pattern NON_PRINTABLE_CHARS = Pattern.compile("\\\\u0000|\\\\u0009|\\\\u000[bB]|\\\\u000[cC]|\\\\u0020|\\\\u007[fF]|\\\\u0085|\\\\u009[fF]|\\\\u00[aA]0|\\\\u00[aA][dD]|\\\\u04[fF]9|\\\\u05[bB][eE]|\\\\u05[dD]0|\\\\u05[eE][aA]|\\\\u05[fF]3|\\\\u05[fF]4|\\\\u0600|\\\\u0604|\\\\u061[cC]|\\\\u06[dD]{2}|\\\\u06[fF]{2}|\\\\u070[fF]|\\\\u0750|\\\\u077[fF]|\\\\u0[eE]00|\\\\u0[eE]7[fF]|\\\\u1680|\\\\u180[eE]|\\\\u1[eE]00|\\\\u2000|\\\\u2001|\\\\u2002|\\\\u2003|\\\\u2004|\\\\u2005|\\\\u2006|\\\\u2007|\\\\u2008|\\\\u2009|\\\\u200[aA]|\\\\u200[fF]|\\\\u2025|\\\\u2028|\\\\u2029|\\\\u202[fF]|\\\\u205[fF]|\\\\u2064|\\\\u2066|\\\\u2067|\\\\u2068|\\\\u2069|\\\\u206[aA]|\\\\u206[fF]|\\\\u20[aA][fF]|\\\\u2100|\\\\u213[aA]|\\\\u3000|\\\\u[dD]800|\\\\u[fF]8[fF]{2}|\\\\u[fF][bB]50|\\\\u[fF][dD][fF]{2}|\\\\u[fF][eE]70|\\\\u[fF][eE][fF]{2}|\\\\u[fF]{2}0[eE]|\\\\u[fF]{2}61|\\\\u[fF]{2}[dD][cC]|\\\\u[fF]{3}9|\\\\u[fF]{3}[aA]|\\\\u[fF]{3}[bB]|\\\\u[fF]{4}");
    private Map<Integer, TextBlock> singlelineComments;
    private Map<Integer, List<TextBlock>> blockComments;
    private boolean allowEscapesForControlCharacters;
    private boolean allowByTailComment;
    private boolean allowIfAllCharactersEscaped;
    private boolean allowNonPrintableEscapes;

    public final void setAllowEscapesForControlCharacters(boolean allow) {
        this.allowEscapesForControlCharacters = allow;
    }

    public final void setAllowByTailComment(boolean allow) {
        this.allowByTailComment = allow;
    }

    public final void setAllowIfAllCharactersEscaped(boolean allow) {
        this.allowIfAllCharactersEscaped = allow;
    }

    public final void setAllowNonPrintableEscapes(boolean allow) {
        this.allowNonPrintableEscapes = allow;
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{139, 138, 205};
    }

    @Override
    public void beginTree(DetailAST rootAST) {
        this.singlelineComments = this.getFileContents().getSingleLineComments();
        this.blockComments = this.getFileContents().getBlockComments();
    }

    @Override
    public void visitToken(DetailAST ast) {
        String literal = CheckUtil.stripIndentAndInitialNewLineFromTextBlock(ast.getText());
        if (!(!AvoidEscapedUnicodeCharactersCheck.hasUnicodeChar(literal) || this.allowByTailComment && this.hasTrailComment(ast) || this.isAllCharactersEscaped(literal) || this.allowEscapesForControlCharacters && AvoidEscapedUnicodeCharactersCheck.isOnlyUnicodeValidChars(literal, UNICODE_CONTROL) || this.allowNonPrintableEscapes && AvoidEscapedUnicodeCharactersCheck.isOnlyUnicodeValidChars(literal, NON_PRINTABLE_CHARS))) {
            this.log(ast, MSG_KEY, new Object[0]);
        }
    }

    private static boolean hasUnicodeChar(String literal) {
        String literalWithoutEscapedBackslashes = ESCAPED_BACKSLASH.matcher(literal).replaceAll("");
        return UNICODE_REGEXP.matcher(literalWithoutEscapedBackslashes).find();
    }

    private static boolean isOnlyUnicodeValidChars(String literal, Pattern pattern) {
        int unicodeValidMatchesCounter;
        int unicodeMatchesCounter = AvoidEscapedUnicodeCharactersCheck.countMatches(UNICODE_REGEXP, literal);
        return unicodeMatchesCounter - (unicodeValidMatchesCounter = AvoidEscapedUnicodeCharactersCheck.countMatches(pattern, literal)) == 0;
    }

    private boolean hasTrailComment(DetailAST ast) {
        int lineNo = ast.getLineNo();
        if (ast.getType() == 205) {
            lineNo = ast.getNextSibling().getLineNo();
        }
        boolean result = false;
        if (this.singlelineComments.containsKey(lineNo)) {
            result = true;
        } else {
            List<TextBlock> commentList = this.blockComments.get(lineNo);
            if (commentList != null) {
                TextBlock comment = commentList.get(commentList.size() - 1);
                String line = this.getLines()[lineNo - 1];
                result = AvoidEscapedUnicodeCharactersCheck.isTrailingBlockComment(comment, line);
            }
        }
        return result;
    }

    private static boolean isTrailingBlockComment(TextBlock comment, String line) {
        return comment.getText().length != 1 || CommonUtil.isBlank(line.substring(comment.getEndColNo() + 1));
    }

    private static int countMatches(Pattern pattern, String target) {
        int matcherCounter = 0;
        Matcher matcher = pattern.matcher(target);
        while (matcher.find()) {
            ++matcherCounter;
        }
        return matcherCounter;
    }

    private boolean isAllCharactersEscaped(String literal) {
        return this.allowIfAllCharactersEscaped && ALL_ESCAPED_CHARS.matcher(literal).find();
    }
}

