/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.javadoc;

import com.puppycrawl.tools.checkstyle.FileStatefulCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.api.LocalizedMessage;
import com.puppycrawl.tools.checkstyle.checks.javadoc.ClassResolver;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

@Deprecated
@FileStatefulCheck
public abstract class AbstractTypeAwareCheck
extends AbstractCheck {
    private final Deque<Map<String, AbstractClassInfo>> typeParams = new ArrayDeque<Map<String, AbstractClassInfo>>();
    private final Set<String> imports = new HashSet<String>();
    private FullIdent packageFullIdent;
    private String currentClassName;
    private ClassResolver classResolver;
    private boolean logLoadErrors = true;
    private boolean suppressLoadErrors;

    protected abstract void processAST(DetailAST var1);

    protected abstract void logLoadError(Token var1);

    public final void setLogLoadErrors(boolean logLoadErrors) {
        this.logLoadErrors = logLoadErrors;
    }

    public final void setSuppressLoadErrors(boolean suppressLoadErrors) {
        this.suppressLoadErrors = suppressLoadErrors;
    }

    @Override
    public final int[] getRequiredTokens() {
        return new int[]{16, 30, 14, 15, 154};
    }

    @Override
    public void beginTree(DetailAST rootAST) {
        this.packageFullIdent = FullIdent.createFullIdent(null);
        this.imports.clear();
        this.imports.add("java.lang.*");
        this.classResolver = null;
        this.currentClassName = "";
        this.typeParams.clear();
    }

    @Override
    public final void visitToken(DetailAST ast) {
        if (ast.getType() == 16) {
            this.processPackage(ast);
        } else if (ast.getType() == 30) {
            this.processImport(ast);
        } else if (ast.getType() == 14 || ast.getType() == 15 || ast.getType() == 154) {
            this.processClass(ast);
        } else {
            if (ast.getType() == 9) {
                this.processTypeParams(ast);
            }
            this.processAST(ast);
        }
    }

    @Override
    public final void leaveToken(DetailAST ast) {
        if (ast.getType() == 14 || ast.getType() == 15 || ast.getType() == 154) {
            int dotIdx = this.currentClassName.lastIndexOf(36);
            if (dotIdx == -1) {
                dotIdx = this.currentClassName.lastIndexOf(46);
            }
            this.currentClassName = dotIdx == -1 ? "" : this.currentClassName.substring(0, dotIdx);
            this.typeParams.pop();
        } else if (ast.getType() == 9) {
            this.typeParams.pop();
        }
    }

    protected static boolean isUnchecked(Class<?> exception) {
        return AbstractTypeAwareCheck.isSubclass(exception, RuntimeException.class) || AbstractTypeAwareCheck.isSubclass(exception, Error.class);
    }

    protected static boolean isSubclass(Class<?> child, Class<?> parent) {
        return parent != null && child != null && parent.isAssignableFrom(child);
    }

    private ClassResolver getClassResolver() {
        if (this.classResolver == null) {
            this.classResolver = new ClassResolver(this.getClassLoader(), this.packageFullIdent.getText(), this.imports);
        }
        return this.classResolver;
    }

    protected final Class<?> resolveClass(String resolvableClassName, String className) {
        Class<?> clazz;
        try {
            clazz = this.getClassResolver().resolve(resolvableClassName, className);
        }
        catch (Exception ignored) {
            clazz = null;
        }
        return clazz;
    }

    protected final Class<?> tryLoadClass(Token ident, String className) {
        Class<?> clazz = this.resolveClass(ident.getText(), className);
        if (clazz == null) {
            this.logLoadError(ident);
        }
        return clazz;
    }

    protected final void logLoadErrorImpl(int lineNo, int columnNo, String msgKey, Object ... values) {
        if (!this.logLoadErrors) {
            LocalizedMessage msg = new LocalizedMessage(lineNo, columnNo, this.getMessageBundle(), msgKey, values, this.getSeverityLevel(), this.getId(), this.getClass(), null);
            throw new IllegalStateException(msg.getMessage());
        }
        if (!this.suppressLoadErrors) {
            this.log(lineNo, columnNo, msgKey, values);
        }
    }

    private void processPackage(DetailAST ast) {
        DetailAST nameAST = ast.getLastChild().getPreviousSibling();
        this.packageFullIdent = FullIdent.createFullIdent(nameAST);
    }

    private void processImport(DetailAST ast) {
        FullIdent name = FullIdent.createFullIdentBelow(ast);
        this.imports.add(name.getText());
    }

    private void processTypeParams(DetailAST ast) {
        DetailAST params = ast.findFirstToken(165);
        HashMap<String, AbstractClassInfo> paramsMap = new HashMap<String, AbstractClassInfo>();
        this.typeParams.push(paramsMap);
        if (params != null) {
            for (DetailAST child = params.getFirstChild(); child != null; child = child.getNextSibling()) {
                DetailAST bounds;
                if (child.getType() != 166 || (bounds = child.findFirstToken(168)) == null) continue;
                FullIdent name = FullIdent.createFullIdentBelow(bounds);
                AbstractClassInfo classInfo = this.createClassInfo(new Token(name), this.currentClassName);
                String alias = child.findFirstToken(58).getText();
                paramsMap.put(alias, classInfo);
            }
        }
    }

    private void processClass(DetailAST ast) {
        DetailAST ident = ast.findFirstToken(58);
        String innerClass = ident.getText();
        if (!this.currentClassName.isEmpty()) {
            innerClass = "$" + innerClass;
        }
        this.currentClassName = this.currentClassName + innerClass;
        this.processTypeParams(ast);
    }

    protected final String getCurrentClassName() {
        return this.currentClassName;
    }

    protected final AbstractClassInfo createClassInfo(Token name, String surroundingClass) {
        AbstractClassInfo classInfo = this.findClassAlias(name.getText());
        AbstractClassInfo result = classInfo == null ? new RegularClass(name, surroundingClass, this) : new ClassAlias(name, classInfo);
        return result;
    }

    protected final AbstractClassInfo findClassAlias(String name) {
        Map<String, AbstractClassInfo> paramMap;
        AbstractClassInfo classInfo = null;
        Iterator<Map<String, AbstractClassInfo>> iterator = this.typeParams.descendingIterator();
        while (iterator.hasNext() && (classInfo = (paramMap = iterator.next()).get(name)) == null) {
        }
        return classInfo;
    }

    protected static class Token {
        private final int columnNo;
        private final int lineNo;
        private final String text;

        public Token(String text, int lineNo, int columnNo) {
            this.text = text;
            this.lineNo = lineNo;
            this.columnNo = columnNo;
        }

        public Token(FullIdent fullIdent) {
            this.text = fullIdent.getText();
            this.lineNo = fullIdent.getLineNo();
            this.columnNo = fullIdent.getColumnNo();
        }

        public int getLineNo() {
            return this.lineNo;
        }

        public int getColumnNo() {
            return this.columnNo;
        }

        public String getText() {
            return this.text;
        }

        public String toString() {
            return "Token[" + this.text + "(" + this.lineNo + "x" + this.columnNo + ")]";
        }
    }

    private static class ClassAlias
    extends AbstractClassInfo {
        private final AbstractClassInfo classInfo;

        ClassAlias(Token name, AbstractClassInfo classInfo) {
            super(name);
            this.classInfo = classInfo;
        }

        @Override
        public final Class<?> getClazz() {
            return this.classInfo.getClazz();
        }

        public String toString() {
            return "ClassAlias[alias " + this.getName() + " for " + this.classInfo.getName() + "]";
        }
    }

    private static final class RegularClass
    extends AbstractClassInfo {
        private final String surroundingClass;
        private final AbstractTypeAwareCheck check;
        private boolean loadable = true;
        private Class<?> classObj;

        RegularClass(Token name, String surroundingClass, AbstractTypeAwareCheck check) {
            super(name);
            this.surroundingClass = surroundingClass;
            this.check = check;
        }

        @Override
        public Class<?> getClazz() {
            if (this.loadable && this.classObj == null) {
                this.setClazz(this.check.tryLoadClass(this.getName(), this.surroundingClass));
            }
            return this.classObj;
        }

        private void setClazz(Class<?> clazz) {
            this.classObj = clazz;
            this.loadable = clazz != null;
        }

        public String toString() {
            return "RegularClass[name=" + this.getName() + ", in class='" + this.surroundingClass + '\'' + ", check=" + this.check.hashCode() + ", loadable=" + this.loadable + ", class=" + this.classObj + ']';
        }
    }

    protected static abstract class AbstractClassInfo {
        private final Token name;

        protected AbstractClassInfo(Token className) {
            if (className == null) {
                throw new IllegalArgumentException("ClassInfo's name should be non-null");
            }
            this.name = className;
        }

        public abstract Class<?> getClazz();

        public final Token getName() {
            return this.name;
        }
    }
}

