/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.sizes;

import com.puppycrawl.tools.checkstyle.FileStatefulCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.ArrayDeque;
import java.util.Deque;

@FileStatefulCheck
public final class ExecutableStatementCountCheck
extends AbstractCheck {
    public static final String MSG_KEY = "executableStatementCount";
    private static final int DEFAULT_MAX = 30;
    private final Deque<Context> contextStack = new ArrayDeque<Context>();
    private int max = 30;
    private Context context;

    @Override
    public int[] getDefaultTokens() {
        return new int[]{8, 9, 11, 12, 7};
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{7};
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{8, 9, 11, 12, 7};
    }

    public void setMax(int max) {
        this.max = max;
    }

    @Override
    public void beginTree(DetailAST rootAST) {
        this.context = new Context(null);
        this.contextStack.clear();
    }

    @Override
    public void visitToken(DetailAST ast) {
        switch (ast.getType()) {
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                this.visitMemberDef(ast);
                break;
            }
            case 7: {
                this.visitSlist(ast);
                break;
            }
            default: {
                throw new IllegalStateException(ast.toString());
            }
        }
    }

    @Override
    public void leaveToken(DetailAST ast) {
        switch (ast.getType()) {
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                this.leaveMemberDef(ast);
                break;
            }
            case 7: {
                break;
            }
            default: {
                throw new IllegalStateException(ast.toString());
            }
        }
    }

    private void visitMemberDef(DetailAST ast) {
        this.contextStack.push(this.context);
        this.context = new Context(ast);
    }

    private void leaveMemberDef(DetailAST ast) {
        int count = this.context.getCount();
        if (count > this.max) {
            this.log(ast, MSG_KEY, count, this.max);
        }
        this.context = this.contextStack.pop();
    }

    private void visitSlist(DetailAST ast) {
        if (this.context.getAST() != null) {
            DetailAST contextAST = this.context.getAST();
            DetailAST parent = ast.getParent();
            int type = parent.getType();
            while (type != 8 && type != 9 && type != 11 && type != 12) {
                parent = parent.getParent();
                type = parent.getType();
            }
            if (parent == contextAST) {
                this.context.addCount(ast.getChildCount() / 2);
            }
        }
    }

    private static class Context {
        private final DetailAST ast;
        private int count;

        Context(DetailAST ast) {
            this.ast = ast;
            this.count = 0;
        }

        public void addCount(int addition) {
            this.count += addition;
        }

        public DetailAST getAST() {
            return this.ast;
        }

        public int getCount() {
            return this.count;
        }
    }
}

