/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.javadoc;

import com.google.common.base.CharMatcher;
import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.DetailNode;
import com.puppycrawl.tools.checkstyle.checks.javadoc.AbstractJavadocCheck;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import com.puppycrawl.tools.checkstyle.utils.JavadocUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;

@StatelessCheck
public class SummaryJavadocCheck
extends AbstractJavadocCheck {
    public static final String MSG_SUMMARY_FIRST_SENTENCE = "summary.first.sentence";
    public static final String MSG_SUMMARY_JAVADOC = "summary.javaDoc";
    public static final String MSG_SUMMARY_JAVADOC_MISSING = "summary.javaDoc.missing";
    private static final Pattern JAVADOC_MULTILINE_TO_SINGLELINE_PATTERN = Pattern.compile("\n[ ]+(\\*)|^[ ]+(\\*)");
    private static final String PERIOD = ".";
    private static final Set<Integer> ALLOWED_TYPES = Collections.unmodifiableSet(new HashSet<Integer>(Arrays.asList(10074, 4)));
    private Pattern forbiddenSummaryFragments = CommonUtil.createPattern("^$");
    private String period = ".";

    public void setForbiddenSummaryFragments(Pattern pattern) {
        this.forbiddenSummaryFragments = pattern;
    }

    public void setPeriod(String period) {
        this.period = period;
    }

    @Override
    public int[] getDefaultJavadocTokens() {
        return new int[]{10000};
    }

    @Override
    public int[] getRequiredJavadocTokens() {
        return this.getAcceptableJavadocTokens();
    }

    @Override
    public void visitJavadocToken(DetailNode ast) {
        if (!SummaryJavadocCheck.startsWithInheritDoc(ast)) {
            String summaryDoc = SummaryJavadocCheck.getSummarySentence(ast);
            if (summaryDoc.isEmpty()) {
                this.log(ast.getLineNumber(), MSG_SUMMARY_JAVADOC_MISSING, new Object[0]);
            } else if (!this.period.isEmpty()) {
                String firstSentence = SummaryJavadocCheck.getFirstSentence(ast);
                int endOfSentence = firstSentence.lastIndexOf(this.period);
                if (!summaryDoc.contains(this.period)) {
                    this.log(ast.getLineNumber(), MSG_SUMMARY_FIRST_SENTENCE, new Object[0]);
                }
                if (endOfSentence != -1 && this.containsForbiddenFragment(firstSentence.substring(0, endOfSentence))) {
                    this.log(ast.getLineNumber(), MSG_SUMMARY_JAVADOC, new Object[0]);
                }
            }
        }
    }

    private static boolean startsWithInheritDoc(DetailNode root) {
        boolean found = false;
        DetailNode[] children = root.getChildren();
        int i = 0;
        while (!found) {
            DetailNode child = children[i];
            if (child.getType() == 10072 && child.getChildren()[1].getType() == 47) {
                found = true;
            } else if (child.getType() != 1 && !CommonUtil.isBlank(child.getText())) break;
            ++i;
        }
        return found;
    }

    private static String getSummarySentence(DetailNode ast) {
        boolean flag = true;
        StringBuilder result = new StringBuilder(256);
        for (DetailNode child : ast.getChildren()) {
            if (ALLOWED_TYPES.contains(child.getType())) {
                result.append(child.getText());
            } else if (child.getType() == 10001 && CommonUtil.isBlank(result.toString().trim())) {
                result.append(SummaryJavadocCheck.getStringInsideTag(result.toString(), child.getChildren()[0].getChildren()[0]));
            } else if (child.getType() == 10071) {
                flag = false;
            }
            if (!flag) break;
        }
        return result.toString().trim();
    }

    private static String getStringInsideTag(String result, DetailNode detailNode) {
        StringBuilder contents = new StringBuilder(result);
        DetailNode tempNode = detailNode;
        while (tempNode != null) {
            if (tempNode.getType() == 10074) {
                contents.append(tempNode.getText());
            }
            tempNode = JavadocUtil.getNextSibling(tempNode);
        }
        return contents.toString();
    }

    private static String getFirstSentence(DetailNode ast) {
        StringBuilder result = new StringBuilder(256);
        String periodSuffix = ". ";
        for (DetailNode child : ast.getChildren()) {
            String text = child.getChildren().length == 0 ? child.getText() : SummaryJavadocCheck.getFirstSentence(child);
            if (text.contains(". ")) {
                result.append(text, 0, text.indexOf(". ") + 1);
                break;
            }
            result.append(text);
        }
        return result.toString();
    }

    private boolean containsForbiddenFragment(String firstSentence) {
        String javadocText = JAVADOC_MULTILINE_TO_SINGLELINE_PATTERN.matcher(firstSentence).replaceAll(" ");
        javadocText = CharMatcher.whitespace().trimAndCollapseFrom((CharSequence)javadocText, ' ');
        return this.forbiddenSummaryFragments.matcher(javadocText).find();
    }
}

