/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.indentation;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.indentation.AbstractExpressionHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.IndentLevel;
import com.puppycrawl.tools.checkstyle.checks.indentation.IndentationCheck;

public class MemberDefHandler
extends AbstractExpressionHandler {
    public MemberDefHandler(IndentationCheck indentCheck, DetailAST ast, AbstractExpressionHandler parent) {
        super(indentCheck, "member def", ast, parent);
    }

    @Override
    public void checkIndentation() {
        DetailAST modifiersNode = this.getMainAst().findFirstToken(5);
        if (modifiersNode.getChildCount() == 0) {
            this.checkType();
        } else {
            this.checkModifiers();
        }
        DetailAST firstNode = this.getMainAst();
        DetailAST lastNode = MemberDefHandler.getVarDefStatementSemicolon(firstNode);
        if (lastNode != null && !MemberDefHandler.isArrayDeclaration(firstNode)) {
            this.checkWrappingIndentation(firstNode, lastNode);
        }
    }

    @Override
    public IndentLevel getSuggestedChildIndent(AbstractExpressionHandler child) {
        return this.getIndent();
    }

    @Override
    protected void checkModifiers() {
        DetailAST modifier = this.getMainAst().findFirstToken(5);
        if (this.isOnStartOfLine(modifier) && !this.getIndent().isAcceptable(this.expandedTabsColumnNo(modifier))) {
            this.logError(modifier, "modifier", this.expandedTabsColumnNo(modifier));
        }
    }

    private void checkType() {
        DetailAST type = this.getMainAst().findFirstToken(13);
        DetailAST ident = AbstractExpressionHandler.getFirstToken(type);
        int columnNo = this.expandedTabsColumnNo(ident);
        if (this.isOnStartOfLine(ident) && !this.getIndent().isAcceptable(columnNo)) {
            this.logError(ident, "type", columnNo);
        }
    }

    private static boolean isArrayDeclaration(DetailAST variableDef) {
        return variableDef.findFirstToken(13).findFirstToken(17) != null;
    }

    private static DetailAST getVarDefStatementSemicolon(DetailAST variableDef) {
        DetailAST lastNode = variableDef.getLastChild();
        if (lastNode.getType() != 45) {
            lastNode = variableDef.getNextSibling();
        }
        return lastNode;
    }
}

