/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks;

import java.util.HashSet;
import java.util.Set;

public class ClassResolver {
    private static final String PERIOD = ".";
    private static final String DOLLAR_SIGN = "$";
    private final String pkg;
    private final Set<String> imports;
    private final ClassLoader loader;

    public ClassResolver(ClassLoader loader, String pkg, Set<String> imports) {
        this.loader = loader;
        this.pkg = pkg;
        this.imports = new HashSet<String>(imports);
        this.imports.add("java.lang.*");
    }

    public Class<?> resolve(String name, String currentClass) throws ClassNotFoundException {
        Class<?> classFromQualifiedName;
        Class<?> clazz = this.resolveQualifiedName(name);
        if (clazz != null) {
            return clazz;
        }
        for (String imp : this.imports) {
            if (!imp.endsWith(PERIOD + name) || (clazz = this.resolveQualifiedName(imp)) == null) continue;
            return clazz;
        }
        if (this.pkg != null && !this.pkg.isEmpty() && (classFromQualifiedName = this.resolveQualifiedName(this.pkg + PERIOD + name)) != null) {
            return classFromQualifiedName;
        }
        Class<?> innerClass = this.resolveInnerClass(name, currentClass);
        if (innerClass != null) {
            return innerClass;
        }
        Class<?> classFromStarImport = this.resolveByStarImports(name);
        if (classFromStarImport != null) {
            return classFromStarImport;
        }
        return this.safeLoad(name);
    }

    private Class<?> resolveInnerClass(String name, String currentClass) throws ClassNotFoundException {
        Class<?> clazz = null;
        if (!currentClass.isEmpty()) {
            String innerClass = currentClass + DOLLAR_SIGN + name;
            if (!this.pkg.isEmpty()) {
                innerClass = this.pkg + PERIOD + innerClass;
            }
            if (this.isLoadable(innerClass)) {
                clazz = this.safeLoad(innerClass);
            }
        }
        return clazz;
    }

    private Class<?> resolveByStarImports(String name) {
        Class<?> clazz = null;
        for (String imp : this.imports) {
            String fqn;
            if (imp.endsWith(".*") && (clazz = this.resolveQualifiedName(fqn = imp.substring(0, imp.lastIndexOf(46) + 1) + name)) != null) break;
        }
        return clazz;
    }

    public boolean isLoadable(String name) {
        try {
            this.safeLoad(name);
            return true;
        }
        catch (ClassNotFoundException | NoClassDefFoundError ignored) {
            return false;
        }
    }

    private Class<?> safeLoad(String name) throws ClassNotFoundException, NoClassDefFoundError {
        return Class.forName(name, false, this.loader);
    }

    private Class<?> resolveQualifiedName(String name) {
        Class<?> classObj = null;
        try {
            if (this.isLoadable(name)) {
                classObj = this.safeLoad(name);
            } else {
                int dot = name.lastIndexOf(46);
                if (dot != -1) {
                    String innerName = name.substring(0, dot) + DOLLAR_SIGN + name.substring(dot + 1);
                    classObj = this.resolveQualifiedName(innerName);
                }
            }
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalStateException(ex);
        }
        return classObj;
    }
}

