/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.gui;

import antlr.ASTFactory;
import antlr.collections.AST;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.gui.AbstractTreeTableModel;
import com.puppycrawl.tools.checkstyle.gui.TreeTableModel;
import com.puppycrawl.tools.checkstyle.utils.TokenUtils;
import javax.swing.tree.TreePath;

public class ParseTreeModel
extends AbstractTreeTableModel {
    private static final String[] COLUMN_NAMES = new String[]{"Tree", "Type", "Line", "Column", "Text"};

    public ParseTreeModel(DetailAST parseTree) {
        super((Object)ParseTreeModel.createArtificialTreeRoot());
        this.setParseTree(parseTree);
    }

    private static DetailAST createArtificialTreeRoot() {
        ASTFactory factory = new ASTFactory();
        factory.setASTNodeClass(DetailAST.class.getName());
        return (DetailAST)factory.create(1, "ROOT");
    }

    final void setParseTree(DetailAST parseTree) {
        DetailAST root = (DetailAST)((Object)this.getRoot());
        root.setFirstChild((AST)parseTree);
        Object[] path = new Object[]{root};
        this.fireTreeStructureChanged(this, path, null, null);
    }

    @Override
    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    @Override
    public String getColumnName(int column) {
        return COLUMN_NAMES[column];
    }

    @Override
    public Class<?> getColumnClass(int column) {
        Class columnClass;
        switch (column) {
            case 0: {
                columnClass = TreeTableModel.class;
                break;
            }
            case 1: {
                columnClass = String.class;
                break;
            }
            case 2: {
                columnClass = Integer.class;
                break;
            }
            case 3: {
                columnClass = Integer.class;
                break;
            }
            case 4: {
                columnClass = String.class;
                break;
            }
            default: {
                columnClass = Object.class;
            }
        }
        return columnClass;
    }

    @Override
    public Object getValueAt(Object node, int column) {
        Object value;
        DetailAST ast = (DetailAST)((Object)node);
        switch (column) {
            case 1: {
                value = TokenUtils.getTokenName(ast.getType());
                break;
            }
            case 2: {
                value = ast.getLineNo();
                break;
            }
            case 3: {
                value = ast.getColumnNo();
                break;
            }
            case 4: {
                value = ast.getText();
                break;
            }
            default: {
                value = null;
            }
        }
        return value;
    }

    @Override
    public Object getChild(Object parent, int index) {
        DetailAST ast = (DetailAST)((Object)parent);
        DetailAST child = ast.getFirstChild();
        for (int currentIndex = 0; currentIndex < index; ++currentIndex) {
            child = child.getNextSibling();
        }
        return child;
    }

    @Override
    public int getChildCount(Object parent) {
        DetailAST ast = (DetailAST)((Object)parent);
        return ast.getChildCount();
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }
}

