/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.gui;

import antlr.ANTLRException;
import com.puppycrawl.tools.checkstyle.TreeWalker;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.FileText;
import com.puppycrawl.tools.checkstyle.gui.FileDrop;
import com.puppycrawl.tools.checkstyle.gui.JTreeTable;
import com.puppycrawl.tools.checkstyle.gui.Listener;
import com.puppycrawl.tools.checkstyle.gui.Main;
import com.puppycrawl.tools.checkstyle.gui.ParseTreeModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.TooManyListenersException;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;

public class ParseTreeInfoPanel
extends JPanel {
    private static final long serialVersionUID = -4243405131202059043L;
    private final transient ParseTreeModel parseTreeModel;
    private final JTextArea textArea;
    private File lastDirectory;
    private File currentFile;
    private final ReloadAction reloadAction;
    private final List<Integer> linesToPosition = new ArrayList<Integer>();

    public ParseTreeInfoPanel() {
        this.setLayout(new BorderLayout());
        this.parseTreeModel = new ParseTreeModel(null);
        JTreeTable treeTable = new JTreeTable(this.parseTreeModel);
        JScrollPane scrollPane = new JScrollPane(treeTable);
        this.add((Component)scrollPane, "First");
        JButton fileSelectionButton = new JButton(new FileSelectionAction());
        this.reloadAction = new ReloadAction();
        this.reloadAction.setEnabled(false);
        JButton reloadButton = new JButton(this.reloadAction);
        this.textArea = new JTextArea(20, 15);
        this.textArea.setEditable(false);
        treeTable.setEditor(this.textArea);
        treeTable.setLinePositionMap(this.linesToPosition);
        JScrollPane sp2 = new JScrollPane(this.textArea);
        this.add((Component)sp2, "Center");
        JPanel pane = new JPanel(new GridLayout(1, 2));
        this.add((Component)pane, "Last");
        pane.add(fileSelectionButton);
        pane.add(reloadButton);
        try {
            new FileDrop(scrollPane, new FileDropListener(scrollPane));
        }
        catch (TooManyListenersException ignored) {
            ParseTreeInfoPanel.showErrorDialog(null, "Cannot initialize Drag and Drop support");
        }
    }

    public void openAst(DetailAST parseTree) {
        this.parseTreeModel.setParseTree(parseTree);
        this.reloadAction.setEnabled(true);
        this.clearLinesToPosition();
        this.addLineToPosition(0);
        if (!this.textArea.getText().isEmpty()) {
            this.textArea.replaceRange("", 0, this.textArea.getText().length());
        }
        this.textArea.moveCaretPosition(0);
    }

    public void openFile(File file, Component parent) {
        if (file != null) {
            try {
                Main.getFrame().setTitle("Checkstyle : " + file.getName());
                FileText text = new FileText(file.getAbsoluteFile(), ParseTreeInfoPanel.getEncoding());
                DetailAST parseTree = ParseTreeInfoPanel.parseFile(text);
                this.parseTreeModel.setParseTree(parseTree);
                this.currentFile = file;
                this.lastDirectory = file.getParentFile();
                this.reloadAction.setEnabled(true);
                String[] sourceLines = text.toLinesArray();
                this.clearLinesToPosition();
                this.addLineToPosition(0);
                if (!this.textArea.getText().isEmpty()) {
                    this.textArea.replaceRange("", 0, this.textArea.getText().length());
                }
                for (String element : sourceLines) {
                    this.addLineToPosition(this.textArea.getText().length());
                    this.textArea.append(element + System.lineSeparator());
                }
                this.textArea.moveCaretPosition(0);
            }
            catch (ANTLRException | IOException ex) {
                ParseTreeInfoPanel.showErrorDialog(parent, "Could not parse" + file + ": " + ex.getMessage());
            }
        }
    }

    private static DetailAST parseFile(FileText text) throws ANTLRException {
        FileContents contents = new FileContents(text);
        return TreeWalker.parse(contents);
    }

    private static String getEncoding() {
        return System.getProperty("file.encoding", "UTF-8");
    }

    private static void showErrorDialog(Component parent, String msg) {
        FrameShower showError = new FrameShower(parent, msg);
        SwingUtilities.invokeLater(showError);
    }

    private void addLineToPosition(int value) {
        this.linesToPosition.add(value);
    }

    private void clearLinesToPosition() {
        this.linesToPosition.clear();
    }

    private class FileDropListener
    implements Listener {
        private final JScrollPane scrollPane;

        FileDropListener(JScrollPane scrollPane) {
            this.scrollPane = scrollPane;
        }

        @Override
        public void filesDropped(File ... files) {
            if (files != null && files.length > 0) {
                File file = files[0];
                ParseTreeInfoPanel.this.openFile(file, this.scrollPane);
            }
        }
    }

    private class ReloadAction
    extends AbstractAction {
        private static final long serialVersionUID = -1021880396046355863L;

        ReloadAction() {
            super("Reload Java File");
            this.putValue("MnemonicKey", 82);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Component parent = SwingUtilities.getRoot(ParseTreeInfoPanel.this);
            ParseTreeInfoPanel.this.openFile(ParseTreeInfoPanel.this.currentFile, parent);
        }
    }

    private class FileSelectionAction
    extends AbstractAction {
        private static final long serialVersionUID = -1926935338069418119L;

        FileSelectionAction() {
            super("Select Java File");
            this.putValue("MnemonicKey", 83);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            JFileChooser chooser = new JFileChooser(ParseTreeInfoPanel.this.lastDirectory);
            JavaFileFilter filter = new JavaFileFilter();
            chooser.setFileFilter(filter);
            Component parent = SwingUtilities.getRoot(ParseTreeInfoPanel.this);
            chooser.showDialog(parent, "Open");
            File file = chooser.getSelectedFile();
            ParseTreeInfoPanel.this.openFile(file, parent);
        }
    }

    private static class JavaFileFilter
    extends FileFilter {
        private JavaFileFilter() {
        }

        @Override
        public boolean accept(File file) {
            if (file == null) {
                return false;
            }
            return file.isDirectory() || file.getName().endsWith(".java");
        }

        @Override
        public String getDescription() {
            return "Java Source Code";
        }
    }

    private static class FrameShower
    implements Runnable {
        private final Component parent;
        private final String msg;

        FrameShower(Component parent, String msg) {
            this.parent = parent;
            this.msg = msg;
        }

        @Override
        public void run() {
            JOptionPane.showMessageDialog(this.parent, this.msg);
        }
    }
}

