/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.blocks;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import org.apache.commons.lang3.ArrayUtils;

public class NeedBracesCheck
extends Check {
    public static final String MSG_KEY_NEED_BRACES = "needBraces";
    private boolean allowSingleLineStatement;
    private boolean allowEmptyLoopBody;

    public void setAllowSingleLineStatement(boolean allowSingleLineStatement) {
        this.allowSingleLineStatement = allowSingleLineStatement;
    }

    public void setAllowEmptyLoopBody(boolean allowEmptyLoopBody) {
        this.allowEmptyLoopBody = allowEmptyLoopBody;
    }

    @Override
    public int[] getDefaultTokens() {
        return new int[]{85, 92, 91, 83, 84};
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{85, 92, 91, 83, 84, 93, 94, 181};
    }

    @Override
    public int[] getRequiredTokens() {
        return ArrayUtils.EMPTY_INT_ARRAY;
    }

    @Override
    public void visitToken(DetailAST ast) {
        boolean skipEmptyLoopBody;
        DetailAST slistAST = ast.findFirstToken(7);
        boolean isElseIf = false;
        if (ast.getType() == 92 && ast.findFirstToken(83) != null) {
            isElseIf = true;
        }
        boolean skipStatement = this.isSkipStatement(ast);
        boolean bl = skipEmptyLoopBody = this.allowEmptyLoopBody && this.isEmptyLoopBody(ast);
        if (!(slistAST != null || isElseIf || skipStatement || skipEmptyLoopBody)) {
            this.log(ast.getLineNo(), MSG_KEY_NEED_BRACES, ast.getText());
        }
    }

    private boolean isSkipStatement(DetailAST statement) {
        return this.allowSingleLineStatement && NeedBracesCheck.isSingleLineStatement(statement);
    }

    private boolean isEmptyLoopBody(DetailAST ast) {
        boolean noBodyLoop = false;
        if (ast.getType() == 91 || ast.getType() == 84) {
            DetailAST currentToken = ast.getFirstChild();
            while (currentToken.getNextSibling() != null) {
                currentToken = currentToken.getNextSibling();
            }
            noBodyLoop = currentToken.getType() == 38;
        }
        return noBodyLoop;
    }

    private static boolean isSingleLineStatement(DetailAST statement) {
        boolean result;
        switch (statement.getType()) {
            case 83: {
                result = NeedBracesCheck.isSingleLineIf(statement);
                break;
            }
            case 91: {
                result = NeedBracesCheck.isSingleLineFor(statement);
                break;
            }
            case 85: {
                result = NeedBracesCheck.isSingleLineDoWhile(statement);
                break;
            }
            case 84: {
                result = NeedBracesCheck.isSingleLineWhile(statement);
                break;
            }
            case 181: {
                result = NeedBracesCheck.isSingleLineLambda(statement);
                break;
            }
            case 93: {
                result = NeedBracesCheck.isSingleLineCase(statement);
                break;
            }
            case 94: {
                result = NeedBracesCheck.isSingleLineDefault(statement);
                break;
            }
            default: {
                result = NeedBracesCheck.isSingleLineElse(statement);
            }
        }
        return result;
    }

    private static boolean isSingleLineWhile(DetailAST literalWhile) {
        boolean result = false;
        if (literalWhile.getParent().getType() == 7 && literalWhile.getLastChild().getType() != 7) {
            DetailAST block = literalWhile.getLastChild().getPreviousSibling();
            result = literalWhile.getLineNo() == block.getLineNo();
        }
        return result;
    }

    private static boolean isSingleLineDoWhile(DetailAST literalDo) {
        boolean result = false;
        if (literalDo.getParent().getType() == 7 && literalDo.getFirstChild().getType() != 7) {
            DetailAST block = literalDo.getFirstChild();
            result = block.getLineNo() == literalDo.getLineNo();
        }
        return result;
    }

    private static boolean isSingleLineFor(DetailAST literalFor) {
        boolean result = false;
        if (literalFor.getLastChild().getType() == 38) {
            result = true;
        } else if (literalFor.getParent().getType() == 7 && literalFor.getLastChild().getType() != 7) {
            DetailAST block = NeedBracesCheck.findExpressionBlockInForLoop(literalFor);
            result = block == null ? literalFor.getLineNo() == literalFor.getLastChild().getLineNo() : literalFor.getLineNo() == block.getLineNo();
        }
        return result;
    }

    private static DetailAST findExpressionBlockInForLoop(DetailAST literalFor) {
        DetailAST forEachClause = literalFor.findFirstToken(156);
        DetailAST firstToken = forEachClause == null ? literalFor.findFirstToken(28) : forEachClause.findFirstToken(28);
        return firstToken;
    }

    private static boolean isSingleLineIf(DetailAST literalIf) {
        boolean result = false;
        DetailAST ifCondition = literalIf.findFirstToken(28);
        if (literalIf.getParent().getType() == 7) {
            DetailAST literalIfLastChild = literalIf.getLastChild();
            DetailAST block = literalIfLastChild.getType() == 92 ? literalIfLastChild.getPreviousSibling() : literalIfLastChild;
            result = ifCondition.getLineNo() == block.getLineNo();
        }
        return result;
    }

    private static boolean isSingleLineLambda(DetailAST lambda) {
        boolean result = false;
        DetailAST block = lambda.getLastChild();
        if (block.getType() != 7) {
            result = lambda.getLineNo() == block.getLineNo();
        }
        return result;
    }

    private static boolean isSingleLineCase(DetailAST literalCase) {
        boolean result = false;
        DetailAST slist = literalCase.getNextSibling();
        DetailAST block = slist.getFirstChild();
        if (block.getType() != 7) {
            boolean atOneLine;
            DetailAST caseBreak = slist.findFirstToken(86);
            boolean bl = atOneLine = literalCase.getLineNo() == block.getLineNo();
            if (caseBreak != null) {
                result = atOneLine && block.getLineNo() == caseBreak.getLineNo();
            }
        }
        return result;
    }

    private static boolean isSingleLineDefault(DetailAST literalDefault) {
        boolean result = false;
        DetailAST slist = literalDefault.getNextSibling();
        DetailAST block = slist.getFirstChild();
        if (block.getType() != 7) {
            result = literalDefault.getLineNo() == block.getLineNo();
        }
        return result;
    }

    private static boolean isSingleLineElse(DetailAST literalElse) {
        boolean result = false;
        DetailAST block = literalElse.getFirstChild();
        if (block.getType() != 7) {
            result = literalElse.getLineNo() == block.getLineNo();
        }
        return result;
    }
}

