/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.beanutils.ConversionException;

public class SuppressWarningsHolder
extends Check {
    public static final String MSG_KEY = "suppress.warnings.invalid.target";
    public static final String CHECKSTYLE_PREFIX = "checkstyle:";
    private static final String JAVA_LANG_PREFIX = "java.lang.";
    private static final String CHECK_SUFFIX = "Check";
    private static final String ALL_WARNING_MATCHING_ID = "all";
    private static final Map<String, String> CHECK_ALIAS_MAP = new HashMap<String, String>();
    private static final ThreadLocal<List<Entry>> ENTRIES = new ThreadLocal();

    public static String getDefaultAlias(String sourceName) {
        int startIndex = sourceName.lastIndexOf(46) + 1;
        int endIndex = sourceName.length();
        if (sourceName.endsWith(CHECK_SUFFIX)) {
            endIndex -= CHECK_SUFFIX.length();
        }
        return sourceName.substring(startIndex, endIndex).toLowerCase(Locale.ENGLISH);
    }

    public static String getAlias(String sourceName) {
        String checkAlias = CHECK_ALIAS_MAP.get(sourceName);
        if (checkAlias == null) {
            checkAlias = SuppressWarningsHolder.getDefaultAlias(sourceName);
        }
        return checkAlias;
    }

    public static void registerAlias(String sourceName, String checkAlias) {
        CHECK_ALIAS_MAP.put(sourceName, checkAlias);
    }

    public void setAliasList(String aliasList) {
        for (String sourceAlias : aliasList.split(",")) {
            int index = sourceAlias.indexOf(61);
            if (index > 0) {
                SuppressWarningsHolder.registerAlias(sourceAlias.substring(0, index), sourceAlias.substring(index + 1));
                continue;
            }
            if (sourceAlias.isEmpty()) continue;
            throw new ConversionException("'=' expected in alias list item: " + sourceAlias);
        }
    }

    public static boolean isSuppressed(String sourceName, int line, int column) {
        List<Entry> entries = ENTRIES.get();
        String checkAlias = SuppressWarningsHolder.getAlias(sourceName);
        for (Entry entry : entries) {
            boolean nameMatches;
            boolean afterStart = entry.getFirstLine() < line || entry.getFirstLine() == line && entry.getFirstColumn() <= column;
            boolean beforeEnd = entry.getLastLine() > line || entry.getLastLine() == line && entry.getLastColumn() >= column;
            boolean bl = nameMatches = ALL_WARNING_MATCHING_ID.equals(entry.getCheckName()) || entry.getCheckName().equalsIgnoreCase(checkAlias);
            if (!afterStart || !beforeEnd || !nameMatches) continue;
            return true;
        }
        return false;
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{159};
    }

    @Override
    public int[] getRequiredTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public void beginTree(DetailAST rootAST) {
        ENTRIES.set(new LinkedList());
    }

    @Override
    public void visitToken(DetailAST ast) {
        String identifier = SuppressWarningsHolder.getIdentifier(SuppressWarningsHolder.getNthChild(ast, 1));
        if (identifier.startsWith(JAVA_LANG_PREFIX)) {
            identifier = identifier.substring(JAVA_LANG_PREFIX.length());
        }
        if ("SuppressWarnings".equals(identifier)) {
            int lastColumn;
            int lastLine;
            List<String> values = SuppressWarningsHolder.getAllAnnotationValues(ast);
            if (SuppressWarningsHolder.isAnnotationEmpty(values)) {
                return;
            }
            DetailAST targetAST = SuppressWarningsHolder.getAnnotationTarget(ast);
            if (targetAST == null) {
                this.log(ast.getLineNo(), MSG_KEY, new Object[0]);
                return;
            }
            int firstLine = targetAST.getLineNo();
            int firstColumn = targetAST.getColumnNo();
            DetailAST nextAST = targetAST.getNextSibling();
            if (nextAST == null) {
                lastLine = Integer.MAX_VALUE;
                lastColumn = Integer.MAX_VALUE;
            } else {
                lastLine = nextAST.getLineNo();
                lastColumn = nextAST.getColumnNo() - 1;
            }
            List<Entry> entries = ENTRIES.get();
            Iterator<String> iterator = values.iterator();
            while (iterator.hasNext()) {
                String value;
                String checkName = value = iterator.next();
                checkName = SuppressWarningsHolder.removeCheckstylePrefixIfExists(checkName);
                entries.add(new Entry(checkName, firstLine, firstColumn, lastLine, lastColumn));
            }
        }
    }

    private static String removeCheckstylePrefixIfExists(String checkName) {
        String result = checkName;
        if (checkName.startsWith(CHECKSTYLE_PREFIX)) {
            result = checkName.substring(CHECKSTYLE_PREFIX.length());
        }
        return result;
    }

    private static List<String> getAllAnnotationValues(DetailAST ast) {
        List<String> values = null;
        DetailAST lparenAST = ast.findFirstToken(76);
        if (lparenAST != null) {
            DetailAST nextAST = lparenAST.getNextSibling();
            int nextType = nextAST.getType();
            switch (nextType) {
                case 28: 
                case 162: {
                    values = SuppressWarningsHolder.getAnnotationValues(nextAST);
                    break;
                }
                case 160: {
                    values = SuppressWarningsHolder.getAnnotationValues(SuppressWarningsHolder.getNthChild(nextAST, 2));
                    break;
                }
                case 77: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected AST: " + (Object)((Object)nextAST));
                }
            }
        }
        return values;
    }

    private static boolean isAnnotationEmpty(List<String> values) {
        return values == null;
    }

    private static DetailAST getAnnotationTarget(DetailAST ast) {
        DetailAST targetAST;
        DetailAST parentAST = ast.getParent();
        switch (parentAST.getType()) {
            case 5: 
            case 158: {
                targetAST = SuppressWarningsHolder.getAcceptableParent(parentAST);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected container AST: " + (Object)((Object)parentAST));
            }
        }
        return targetAST;
    }

    private static DetailAST getAcceptableParent(DetailAST child) {
        DetailAST result;
        DetailAST parent = child.getParent();
        switch (parent.getType()) {
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 21: 
            case 59: 
            case 81: 
            case 136: 
            case 154: 
            case 155: 
            case 157: 
            case 161: 
            case 164: {
                result = parent;
                break;
            }
            default: {
                result = null;
            }
        }
        return result;
    }

    private static DetailAST getNthChild(DetailAST ast, int index) {
        DetailAST child = ast.getFirstChild();
        for (int i = 0; i < index && child != null; child = child.getNextSibling(), ++i) {
        }
        return child;
    }

    private static String getIdentifier(DetailAST ast) {
        if (ast != null) {
            if (ast.getType() == 58) {
                return ast.getText();
            }
            return SuppressWarningsHolder.getIdentifier(ast.getFirstChild()) + "." + SuppressWarningsHolder.getIdentifier(ast.getLastChild());
        }
        throw new IllegalArgumentException("Identifier AST expected, but get null.");
    }

    private static String getStringExpr(DetailAST ast) {
        DetailAST firstChild = ast.getFirstChild();
        String expr = "";
        switch (firstChild.getType()) {
            case 139: {
                String quotedText = firstChild.getText();
                expr = quotedText.substring(1, quotedText.length() - 1);
                break;
            }
            case 58: {
                expr = firstChild.getText();
                break;
            }
            case 59: {
                expr = firstChild.getLastChild().getText();
                break;
            }
        }
        return expr;
    }

    private static List<String> getAnnotationValues(DetailAST ast) {
        switch (ast.getType()) {
            case 28: {
                return ImmutableList.of((Object)SuppressWarningsHolder.getStringExpr(ast));
            }
            case 162: {
                return SuppressWarningsHolder.findAllExpressionsInChildren(ast);
            }
        }
        throw new IllegalArgumentException("Expression or annotation array initializer AST expected: " + (Object)((Object)ast));
    }

    private static List<String> findAllExpressionsInChildren(DetailAST parent) {
        LinkedList valueList = Lists.newLinkedList();
        for (DetailAST childAST = parent.getFirstChild(); childAST != null; childAST = childAST.getNextSibling()) {
            if (childAST.getType() != 28) continue;
            valueList.add(SuppressWarningsHolder.getStringExpr(childAST));
        }
        return valueList;
    }

    private static class Entry {
        private final String checkName;
        private final int firstLine;
        private final int firstColumn;
        private final int lastLine;
        private final int lastColumn;

        Entry(String checkName, int firstLine, int firstColumn, int lastLine, int lastColumn) {
            this.checkName = checkName;
            this.firstLine = firstLine;
            this.firstColumn = firstColumn;
            this.lastLine = lastLine;
            this.lastColumn = lastColumn;
        }

        public String getCheckName() {
            return this.checkName;
        }

        public int getFirstLine() {
            return this.firstLine;
        }

        public int getFirstColumn() {
            return this.firstColumn;
        }

        public int getLastLine() {
            return this.lastLine;
        }

        public int getLastColumn() {
            return this.lastColumn;
        }
    }
}

