/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle;

import antlr.CommonHiddenStreamToken;
import antlr.RecognitionException;
import antlr.Token;
import antlr.TokenStream;
import antlr.TokenStreamException;
import antlr.TokenStreamHiddenTokenFilter;
import antlr.TokenStreamRecognitionException;
import antlr.collections.AST;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.puppycrawl.tools.checkstyle.DefaultContext;
import com.puppycrawl.tools.checkstyle.ModuleFactory;
import com.puppycrawl.tools.checkstyle.PropertyCacheFile;
import com.puppycrawl.tools.checkstyle.api.AbstractFileSetCheck;
import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.Configuration;
import com.puppycrawl.tools.checkstyle.api.Context;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.FileText;
import com.puppycrawl.tools.checkstyle.grammars.GeneratedJavaLexer;
import com.puppycrawl.tools.checkstyle.grammars.GeneratedJavaRecognizer;
import com.puppycrawl.tools.checkstyle.utils.CommonUtils;
import com.puppycrawl.tools.checkstyle.utils.TokenUtils;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public final class TreeWalker
extends AbstractFileSetCheck {
    private static final int DEFAULT_TAB_WIDTH = 8;
    private final Multimap<String, Check> tokenToOrdinaryChecks = HashMultimap.create();
    private final Multimap<String, Check> tokenToCommentChecks = HashMultimap.create();
    private final Set<Check> ordinaryChecks = Sets.newHashSet();
    private final Set<Check> commentChecks = Sets.newHashSet();
    private int tabWidth = 8;
    private PropertyCacheFile cache;
    private ClassLoader classLoader;
    private Context childContext;
    private ModuleFactory moduleFactory;

    public TreeWalker() {
        this.setFileExtensions("java");
    }

    public void setTabWidth(int tabWidth) {
        this.tabWidth = tabWidth;
    }

    public void setCacheFile(String fileName) throws IOException {
        Configuration configuration = this.getConfiguration();
        this.cache = new PropertyCacheFile(configuration, fileName);
        this.cache.load();
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setModuleFactory(ModuleFactory moduleFactory) {
        this.moduleFactory = moduleFactory;
    }

    @Override
    public void finishLocalSetup() {
        DefaultContext checkContext = new DefaultContext();
        checkContext.add("classLoader", this.classLoader);
        checkContext.add("messages", this.getMessageCollector());
        checkContext.add("severity", this.getSeverity());
        checkContext.add("tabWidth", String.valueOf(this.tabWidth));
        this.childContext = checkContext;
    }

    @Override
    public void setupChild(Configuration childConf) throws CheckstyleException {
        String name = childConf.getName();
        Object module = this.moduleFactory.createModule(name);
        if (!(module instanceof Check)) {
            throw new CheckstyleException("TreeWalker is not allowed as a parent of " + name);
        }
        Check check = (Check)module;
        check.contextualize(this.childContext);
        check.configure(childConf);
        check.init();
        this.registerCheck(check);
    }

    @Override
    protected void processFiltered(File file, List<String> lines) throws CheckstyleException {
        String fileName = file.getPath();
        long timestamp = file.lastModified();
        if (this.cache != null && (this.cache.isInCache(fileName, timestamp) || !CommonUtils.matchesFileExtension(file, this.getFileExtensions()))) {
            return;
        }
        String msg = "%s occurred during the analysis of file %s.";
        try {
            FileText text = FileText.fromLines(file, lines);
            FileContents contents = new FileContents(text);
            DetailAST rootAST = TreeWalker.parse(contents);
            this.getMessageCollector().reset();
            this.walk(rootAST, contents, AstState.ORDINARY);
            DetailAST astWithComments = TreeWalker.appendHiddenCommentNodes(rootAST);
            this.walk(astWithComments, contents, AstState.WITH_COMMENTS);
        }
        catch (TokenStreamRecognitionException tre) {
            String exceptionMsg = String.format(Locale.ROOT, "%s occurred during the analysis of file %s.", "TokenStreamRecognitionException", fileName);
            throw new CheckstyleException(exceptionMsg, tre);
        }
        catch (RecognitionException | TokenStreamException ex) {
            String exceptionMsg = String.format(Locale.ROOT, "%s occurred during the analysis of file %s.", ex.getClass().getSimpleName(), fileName);
            throw new CheckstyleException(exceptionMsg, ex);
        }
        if (this.cache != null && this.getMessageCollector().size() == 0) {
            this.cache.put(fileName, timestamp);
        }
    }

    private void registerCheck(Check check) throws CheckstyleException {
        int[] tokens;
        TreeWalker.validateDefaultTokens(check);
        Set<String> checkTokens = check.getTokenNames();
        if (checkTokens.isEmpty()) {
            tokens = check.getDefaultTokens();
        } else {
            tokens = check.getRequiredTokens();
            int[] acceptableTokens = check.getAcceptableTokens();
            Arrays.sort(acceptableTokens);
            for (String token : checkTokens) {
                int tokenId = TokenUtils.getTokenId(token);
                if (Arrays.binarySearch(acceptableTokens, tokenId) >= 0) {
                    this.registerCheck(token, check);
                    continue;
                }
                String message = String.format(Locale.ROOT, "Token \"%s\" was not found in Acceptable tokens list in check %s", token, check.getClass().getName());
                throw new CheckstyleException(message);
            }
        }
        for (int element : tokens) {
            this.registerCheck(element, check);
        }
        if (check.isCommentNodesRequired()) {
            this.commentChecks.add(check);
        } else {
            this.ordinaryChecks.add(check);
        }
    }

    private void registerCheck(int tokenID, Check check) throws CheckstyleException {
        this.registerCheck(TokenUtils.getTokenName(tokenID), check);
    }

    private void registerCheck(String token, Check check) throws CheckstyleException {
        if (check.isCommentNodesRequired()) {
            this.tokenToCommentChecks.put((Object)token, (Object)check);
        } else {
            if (TokenUtils.isCommentType(token)) {
                String message = String.format(Locale.ROOT, "Check '%s' waits for comment type token ('%s') and should override 'isCommentNodesRequired()' method to return 'true'", check.getClass().getName(), token);
                throw new CheckstyleException(message);
            }
            this.tokenToOrdinaryChecks.put((Object)token, (Object)check);
        }
    }

    private static void validateDefaultTokens(Check check) throws CheckstyleException {
        if (check.getRequiredTokens().length != 0) {
            int[] defaultTokens = check.getDefaultTokens();
            Arrays.sort(defaultTokens);
            for (int token : check.getRequiredTokens()) {
                if (Arrays.binarySearch(defaultTokens, token) >= 0) continue;
                String message = String.format(Locale.ROOT, "Token \"%s\" from required tokens was not found in default tokens list in check %s", token, check.getClass().getName());
                throw new CheckstyleException(message);
            }
        }
    }

    private void walk(DetailAST ast, FileContents contents, AstState astState) {
        this.notifyBegin(ast, contents, astState);
        if (ast != null) {
            this.processIter(ast, astState);
        }
        this.notifyEnd(ast, astState);
    }

    private void notifyBegin(DetailAST rootAST, FileContents contents, AstState astState) {
        Set<Check> checks = astState == AstState.WITH_COMMENTS ? this.commentChecks : this.ordinaryChecks;
        for (Check check : checks) {
            check.setFileContents(contents);
            check.beginTree(rootAST);
        }
    }

    private void notifyEnd(DetailAST rootAST, AstState astState) {
        Set<Check> checks = astState == AstState.WITH_COMMENTS ? this.commentChecks : this.ordinaryChecks;
        for (Check check : checks) {
            check.finishTree(rootAST);
        }
    }

    private void notifyVisit(DetailAST ast, AstState astState) {
        Collection<Check> visitors = this.getListOfChecks(ast, astState);
        if (visitors != null) {
            for (Check check : visitors) {
                check.visitToken(ast);
            }
        }
    }

    private void notifyLeave(DetailAST ast, AstState astState) {
        Collection<Check> visitors = this.getListOfChecks(ast, astState);
        if (visitors != null) {
            for (Check check : visitors) {
                check.leaveToken(ast);
            }
        }
    }

    private Collection<Check> getListOfChecks(DetailAST ast, AstState astState) {
        Collection visitors = null;
        String tokenType = TokenUtils.getTokenName(ast.getType());
        if (astState == AstState.WITH_COMMENTS) {
            if (this.tokenToCommentChecks.containsKey((Object)tokenType)) {
                visitors = this.tokenToCommentChecks.get((Object)tokenType);
            }
        } else if (this.tokenToOrdinaryChecks.containsKey((Object)tokenType)) {
            visitors = this.tokenToOrdinaryChecks.get((Object)tokenType);
        }
        return visitors;
    }

    public static DetailAST parse(FileContents contents) throws RecognitionException, TokenStreamException {
        String fullText = contents.getText().getFullText().toString();
        StringReader reader = new StringReader(fullText);
        GeneratedJavaLexer lexer = new GeneratedJavaLexer(reader);
        lexer.setFilename(contents.getFileName());
        lexer.setCommentListener(contents);
        lexer.setTreatAssertAsKeyword(true);
        lexer.setTreatEnumAsKeyword(true);
        lexer.setTokenObjectClass("antlr.CommonHiddenStreamToken");
        TokenStreamHiddenTokenFilter filter = new TokenStreamHiddenTokenFilter((TokenStream)lexer);
        filter.hide(144);
        filter.hide(145);
        GeneratedJavaRecognizer parser = new GeneratedJavaRecognizer((TokenStream)filter);
        parser.setFilename(contents.getFileName());
        parser.setASTNodeClass(DetailAST.class.getName());
        parser.compilationUnit();
        return (DetailAST)parser.getAST();
    }

    @Override
    public void destroy() {
        for (Check check : this.ordinaryChecks) {
            check.destroy();
        }
        for (Check check : this.commentChecks) {
            check.destroy();
        }
        if (this.cache != null) {
            try {
                this.cache.persist();
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to persist cache file", e);
            }
        }
        super.destroy();
    }

    private void processIter(DetailAST root, AstState astState) {
        DetailAST curNode = root;
        while (curNode != null) {
            this.notifyVisit(curNode, astState);
            DetailAST toVisit = curNode.getFirstChild();
            while (curNode != null && toVisit == null) {
                this.notifyLeave(curNode, astState);
                toVisit = curNode.getNextSibling();
                if (toVisit != null) continue;
                curNode = curNode.getParent();
            }
            curNode = toVisit;
        }
    }

    private static DetailAST appendHiddenCommentNodes(DetailAST root) {
        DetailAST newCommentNode;
        DetailAST currentSibling;
        DetailAST result = root;
        DetailAST curNode = root;
        DetailAST lastNode = root;
        while (curNode != null) {
            if (TreeWalker.isPositionGreater(curNode, lastNode)) {
                lastNode = curNode;
            }
            currentSibling = curNode;
            for (CommonHiddenStreamToken tokenBefore = curNode.getHiddenBefore(); tokenBefore != null; tokenBefore = tokenBefore.getHiddenBefore()) {
                newCommentNode = TreeWalker.createCommentAstFromToken((Token)tokenBefore);
                currentSibling.addPreviousSibling(newCommentNode);
                if (currentSibling == result) {
                    result = newCommentNode;
                }
                currentSibling = newCommentNode;
            }
            DetailAST toVisit = curNode.getFirstChild();
            while (curNode != null && toVisit == null) {
                toVisit = curNode.getNextSibling();
                if (toVisit != null) continue;
                curNode = curNode.getParent();
            }
            curNode = toVisit;
        }
        if (lastNode != null) {
            currentSibling = lastNode;
            for (CommonHiddenStreamToken tokenAfter = lastNode.getHiddenAfter(); tokenAfter != null; tokenAfter = tokenAfter.getHiddenAfter()) {
                newCommentNode = TreeWalker.createCommentAstFromToken((Token)tokenAfter);
                currentSibling.addNextSibling(newCommentNode);
                currentSibling = newCommentNode;
            }
        }
        return result;
    }

    private static boolean isPositionGreater(DetailAST ast1, DetailAST ast2) {
        if (ast1.getLineNo() == ast2.getLineNo()) {
            return ast1.getColumnNo() > ast2.getColumnNo();
        }
        return ast1.getLineNo() > ast2.getLineNo();
    }

    private static DetailAST createCommentAstFromToken(Token token) {
        if (token.getType() == 144) {
            return TreeWalker.createSlCommentNode(token);
        }
        return TreeWalker.createBlockCommentNode(token);
    }

    private static DetailAST createSlCommentNode(Token token) {
        DetailAST slComment = new DetailAST();
        slComment.setType(144);
        slComment.setText("//");
        slComment.setColumnNo(token.getColumn() - 1);
        slComment.setLineNo(token.getLine());
        DetailAST slCommentContent = new DetailAST();
        slCommentContent.initialize(token);
        slCommentContent.setType(183);
        slCommentContent.setColumnNo(token.getColumn() - 1 + 2);
        slCommentContent.setLineNo(token.getLine());
        slCommentContent.setText(token.getText());
        slComment.addChild((AST)slCommentContent);
        return slComment;
    }

    private static DetailAST createBlockCommentNode(Token token) {
        DetailAST blockComment = new DetailAST();
        blockComment.initialize(145, "/*");
        blockComment.setColumnNo(token.getColumn() - 1);
        blockComment.setLineNo(token.getLine());
        DetailAST blockCommentContent = new DetailAST();
        blockCommentContent.initialize(token);
        blockCommentContent.setType(183);
        blockCommentContent.setColumnNo(token.getColumn() - 1 + 2);
        blockCommentContent.setLineNo(token.getLine());
        blockCommentContent.setText(token.getText());
        DetailAST blockCommentClose = new DetailAST();
        blockCommentClose.initialize(182, "*/");
        Map.Entry<Integer, Integer> linesColumns = TreeWalker.countLinesColumns(token.getText(), token.getLine(), token.getColumn());
        blockCommentClose.setLineNo(linesColumns.getKey());
        blockCommentClose.setColumnNo(linesColumns.getValue());
        blockComment.addChild((AST)blockCommentContent);
        blockComment.addChild((AST)blockCommentClose);
        return blockComment;
    }

    private static Map.Entry<Integer, Integer> countLinesColumns(String text, int initialLinesCnt, int initialColumnsCnt) {
        int lines = initialLinesCnt;
        int columns = initialColumnsCnt;
        for (char c : text.toCharArray()) {
            if (c == '\n') {
                ++lines;
                columns = 0;
                continue;
            }
            ++columns;
        }
        return new AbstractMap.SimpleEntry<Integer, Integer>(lines, columns);
    }

    private static enum AstState {
        ORDINARY,
        WITH_COMMENTS;

    }
}

