/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.whitespace;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import org.apache.commons.lang3.ArrayUtils;

public class EmptyLineSeparatorCheck
extends Check {
    public static final String MSG_SHOULD_BE_SEPARATED = "empty.line.separator";
    public static final String MSG_MULTIPLE_LINES = "empty.line.separator.multiple.lines";
    private boolean allowNoEmptyLineBetweenFields;
    private boolean allowMultipleEmptyLines = true;

    public final void setAllowNoEmptyLineBetweenFields(boolean allow) {
        this.allowNoEmptyLineBetweenFields = allow;
    }

    public void setAllowMultipleEmptyLines(boolean allow) {
        this.allowMultipleEmptyLines = allow;
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{16, 30, 14, 15, 154, 12, 11, 9, 8, 10};
    }

    @Override
    public int[] getRequiredTokens() {
        return ArrayUtils.EMPTY_INT_ARRAY;
    }

    @Override
    public void visitToken(DetailAST ast) {
        DetailAST nextToken = ast.getNextSibling();
        if (nextToken != null) {
            int astType = ast.getType();
            switch (astType) {
                case 10: {
                    this.processVariableDef(ast, nextToken);
                    break;
                }
                case 30: {
                    this.processImport(ast, nextToken, astType);
                    break;
                }
                case 16: {
                    this.processPackage(ast, nextToken);
                    break;
                }
                default: {
                    if (nextToken.getType() != 73 && !EmptyLineSeparatorCheck.hasEmptyLineAfter(ast)) {
                        this.log(nextToken.getLineNo(), MSG_SHOULD_BE_SEPARATED, nextToken.getText());
                    }
                    if (!this.hasNotAllowedTwoEmptyLinesBefore(ast)) break;
                    this.log(ast.getLineNo(), MSG_MULTIPLE_LINES, ast.getText());
                }
            }
        }
    }

    private void processPackage(DetailAST ast, DetailAST nextToken) {
        if (ast.getLineNo() > 1 && !this.hasEmptyLineBefore(ast)) {
            this.log(ast.getLineNo(), MSG_SHOULD_BE_SEPARATED, ast.getText());
        }
        if (!EmptyLineSeparatorCheck.hasEmptyLineAfter(ast)) {
            this.log(nextToken.getLineNo(), MSG_SHOULD_BE_SEPARATED, nextToken.getText());
        }
        if (this.hasNotAllowedTwoEmptyLinesBefore(ast)) {
            this.log(ast.getLineNo(), MSG_MULTIPLE_LINES, ast.getText());
        }
    }

    private void processImport(DetailAST ast, DetailAST nextToken, int astType) {
        if (astType != nextToken.getType() && !EmptyLineSeparatorCheck.hasEmptyLineAfter(ast)) {
            this.log(nextToken.getLineNo(), MSG_SHOULD_BE_SEPARATED, nextToken.getText());
        }
        if (this.hasNotAllowedTwoEmptyLinesBefore(ast)) {
            this.log(ast.getLineNo(), MSG_MULTIPLE_LINES, ast.getText());
        }
    }

    private void processVariableDef(DetailAST ast, DetailAST nextToken) {
        if (EmptyLineSeparatorCheck.isTypeField(ast) && !EmptyLineSeparatorCheck.hasEmptyLineAfter(ast) && this.isViolatingEmptyLineBetweenFieldsPolicy(nextToken)) {
            this.log(nextToken.getLineNo(), MSG_SHOULD_BE_SEPARATED, nextToken.getText());
        }
        if (EmptyLineSeparatorCheck.isTypeField(ast) && this.hasNotAllowedTwoEmptyLinesBefore(ast)) {
            this.log(ast.getLineNo(), MSG_MULTIPLE_LINES, ast.getText());
        }
    }

    private boolean isViolatingEmptyLineBetweenFieldsPolicy(DetailAST detailAST) {
        return this.allowNoEmptyLineBetweenFields && detailAST.getType() != 10 && detailAST.getType() != 73 || !this.allowNoEmptyLineBetweenFields && detailAST.getType() != 73;
    }

    private boolean hasNotAllowedTwoEmptyLinesBefore(DetailAST token) {
        return !this.allowMultipleEmptyLines && this.hasEmptyLineBefore(token) && this.isPrePreviousLineEmpty(token);
    }

    private boolean isPrePreviousLineEmpty(DetailAST token) {
        boolean result = false;
        int lineNo = token.getLineNo();
        int number = 3;
        if (lineNo >= 3) {
            String prePreviousLine = this.getLines()[lineNo - 3];
            result = prePreviousLine.trim().isEmpty();
        }
        return result;
    }

    private static boolean hasEmptyLineAfter(DetailAST token) {
        DetailAST lastToken = token.getLastChild().getLastChild();
        if (lastToken == null) {
            lastToken = token.getLastChild();
        }
        return token.getNextSibling().getLineNo() - lastToken.getLineNo() > 1;
    }

    private boolean hasEmptyLineBefore(DetailAST token) {
        int lineNo = token.getLineNo();
        if (lineNo == 1) {
            return false;
        }
        String lineBefore = this.getLines()[lineNo - 2];
        return lineBefore.trim().isEmpty();
    }

    private static boolean isTypeField(DetailAST variableDef) {
        int parentType = variableDef.getParent().getParent().getType();
        return parentType == 14;
    }
}

