/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.naming;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.AbstractFormatCheck;

public final class AbstractClassNameCheck
extends AbstractFormatCheck {
    public static final String ILLEGAL_ABSTRACT_CLASS_NAME = "illegal.abstract.class.name";
    public static final String NO_ABSTRACT_CLASS_MODIFIER = "no.abstract.class.modifier";
    private static final String DEFAULT_FORMAT = "^Abstract.+$";
    private boolean ignoreModifier;
    private boolean ignoreName;

    public AbstractClassNameCheck() {
        super(DEFAULT_FORMAT);
    }

    public void setIgnoreModifier(boolean value) {
        this.ignoreModifier = value;
    }

    public void setIgnoreName(boolean value) {
        this.ignoreName = value;
    }

    @Override
    public int[] getDefaultTokens() {
        return new int[]{14};
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{14};
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{14};
    }

    @Override
    public void visitToken(DetailAST ast) {
        this.visitClassDef(ast);
    }

    private void visitClassDef(DetailAST ast) {
        String className = ast.findFirstToken(58).getText();
        if (AbstractClassNameCheck.isAbstract(ast)) {
            if (!this.ignoreName && !this.isMatchingClassName(className)) {
                this.log(ast.getLineNo(), ast.getColumnNo(), ILLEGAL_ABSTRACT_CLASS_NAME, className, this.getFormat());
            }
        } else if (!this.ignoreModifier && this.isMatchingClassName(className)) {
            this.log(ast.getLineNo(), ast.getColumnNo(), NO_ABSTRACT_CLASS_MODIFIER, className);
        }
    }

    private static boolean isAbstract(DetailAST ast) {
        DetailAST abstractAST = ast.findFirstToken(5).findFirstToken(40);
        return abstractAST != null;
    }

    private boolean isMatchingClassName(String className) {
        return this.getRegexp().matcher(className).find();
    }
}

