/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.metrics;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.metrics.AbstractComplexityCheck;
import java.math.BigInteger;

public final class NPathComplexityCheck
extends AbstractComplexityCheck {
    public static final String MSG_KEY = "npathComplexity";
    private static final int DEFAULT_MAX = 200;

    public NPathComplexityCheck() {
        super(200);
    }

    @Override
    public int[] getDefaultTokens() {
        return new int[]{8, 9, 12, 11, 84, 85, 91, 83, 92, 89, 93, 95, 96, 109};
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{8, 9, 12, 11, 84, 85, 91, 83, 92, 89, 93, 95, 96, 109};
    }

    @Override
    public void visitToken(DetailAST ast) {
        switch (ast.getType()) {
            case 83: 
            case 84: 
            case 85: 
            case 89: 
            case 91: 
            case 95: 
            case 109: {
                this.visitMultiplyingConditional();
                break;
            }
            case 92: 
            case 93: 
            case 96: {
                this.visitAddingConditional();
                break;
            }
            default: {
                super.visitToken(ast);
            }
        }
    }

    @Override
    public void leaveToken(DetailAST ast) {
        switch (ast.getType()) {
            case 83: 
            case 84: 
            case 85: 
            case 89: 
            case 91: 
            case 95: 
            case 109: {
                this.leaveMultiplyingConditional();
                break;
            }
            case 92: 
            case 93: 
            case 96: {
                this.leaveAddingConditional();
                break;
            }
            default: {
                super.leaveToken(ast);
            }
        }
    }

    @Override
    protected String getMessageID() {
        return MSG_KEY;
    }

    private void visitAddingConditional() {
        this.pushValue();
    }

    private void leaveAddingConditional() {
        this.setCurrentValue(this.getCurrentValue().subtract(BigInteger.ONE).add(this.popValue()));
    }

    private void visitMultiplyingConditional() {
        this.pushValue();
    }

    private void leaveMultiplyingConditional() {
        this.setCurrentValue(this.getCurrentValue().add(BigInteger.ONE).multiply(this.popValue()));
    }
}

