/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.indentation;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.indentation.AbstractExpressionHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.IndentLevel;
import com.puppycrawl.tools.checkstyle.checks.indentation.IndentationCheck;
import com.puppycrawl.tools.checkstyle.checks.indentation.LineWrappingHandler;

public class MemberDefHandler
extends AbstractExpressionHandler {
    public MemberDefHandler(IndentationCheck indentCheck, DetailAST ast, AbstractExpressionHandler parent) {
        super(indentCheck, "member def", ast, parent);
    }

    @Override
    public void checkIndentation() {
        DetailAST modifiersNode = this.getMainAst().findFirstToken(5);
        if (modifiersNode.getChildCount() == 0) {
            this.checkType();
        } else {
            this.checkModifiers();
        }
        LineWrappingHandler lineWrap = new LineWrappingHandler(this.getIndentCheck(), this.getMainAst(), MemberDefHandler.getVarDefStatementSemicolon(this.getMainAst()));
        if (lineWrap.getLastNode() != null && !MemberDefHandler.isArrayDeclaration(this.getMainAst())) {
            lineWrap.checkIndentation();
        }
    }

    @Override
    public IndentLevel suggestedChildLevel(AbstractExpressionHandler child) {
        return this.getLevel();
    }

    @Override
    protected void checkModifiers() {
        DetailAST modifier = this.getMainAst().findFirstToken(5);
        if (this.startsLine(modifier) && !this.getLevel().isAcceptable(this.expandedTabsColumnNo(modifier))) {
            this.logError(modifier, "modifier", this.expandedTabsColumnNo(modifier));
        }
    }

    private void checkType() {
        DetailAST type = this.getMainAst().findFirstToken(13);
        DetailAST ident = AbstractExpressionHandler.getFirstToken(type);
        int columnNo = this.expandedTabsColumnNo(ident);
        if (this.startsLine(ident) && !this.getLevel().isAcceptable(columnNo)) {
            this.logError(ident, "type", columnNo);
        }
    }

    private static boolean isArrayDeclaration(DetailAST variableDef) {
        return variableDef.findFirstToken(13).findFirstToken(17) != null;
    }

    private static DetailAST getVarDefStatementSemicolon(DetailAST variableDef) {
        DetailAST lastNode = variableDef.getLastChild();
        if (lastNode.getType() != 45) {
            lastNode = variableDef.getNextSibling();
        }
        return lastNode;
    }
}

