/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.metrics;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FastStack;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.checks.CheckUtils;
import java.util.Set;

public abstract class AbstractClassCouplingCheck
extends Check {
    private static final Set<String> DEFAULT_EXCLUDED_CLASSES = ImmutableSet.builder().add((Object[])new String[]{"boolean", "byte", "char", "double", "float", "int"}).add((Object[])new String[]{"long", "short", "void"}).add((Object[])new String[]{"Boolean", "Byte", "Character", "Double", "Float"}).add((Object[])new String[]{"Integer", "Long", "Short", "Void"}).add((Object[])new String[]{"Object", "Class"}).add((Object[])new String[]{"String", "StringBuffer", "StringBuilder"}).add((Object[])new String[]{"ArrayIndexOutOfBoundsException", "Exception"}).add((Object[])new String[]{"RuntimeException", "IllegalArgumentException"}).add((Object[])new String[]{"IllegalStateException", "IndexOutOfBoundsException"}).add((Object[])new String[]{"NullPointerException", "Throwable", "SecurityException"}).add((Object)"UnsupportedOperationException").add((Object[])new String[]{"List", "ArrayList", "Deque", "Queue", "LinkedList"}).add((Object[])new String[]{"Set", "HashSet", "SortedSet", "TreeSet"}).add((Object[])new String[]{"Map", "HashMap", "SortedMap", "TreeMap"}).build();
    private Set<String> mExcludedClasses = DEFAULT_EXCLUDED_CLASSES;
    private int mMax;
    private String mPackageName;
    private final FastStack<Context> mContextStack = FastStack.newInstance();
    private Context mContext;

    protected AbstractClassCouplingCheck(int aDefaultMax) {
        this.setMax(aDefaultMax);
    }

    public final int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    public final int getMax() {
        return this.mMax;
    }

    public final void setMax(int aMax) {
        this.mMax = aMax;
    }

    public final void setExcludedClasses(String[] aExcludedClasses) {
        this.mExcludedClasses = ImmutableSet.copyOf((Object[])aExcludedClasses);
    }

    public final void beginTree(DetailAST aAST) {
        this.mPackageName = "";
    }

    protected abstract String getLogMessageId();

    public void visitToken(DetailAST aAST) {
        switch (aAST.getType()) {
            case 16: {
                this.visitPackageDef(aAST);
                break;
            }
            case 14: 
            case 15: 
            case 154: 
            case 157: {
                this.visitClassDef(aAST);
                break;
            }
            case 13: {
                this.mContext.visitType(aAST);
                break;
            }
            case 136: {
                this.mContext.visitLiteralNew(aAST);
                break;
            }
            case 81: {
                this.mContext.visitLiteralThrows(aAST);
                break;
            }
            default: {
                throw new IllegalStateException(aAST.toString());
            }
        }
    }

    public void leaveToken(DetailAST aAST) {
        switch (aAST.getType()) {
            case 14: 
            case 15: 
            case 154: 
            case 157: {
                this.leaveClassDef();
                break;
            }
        }
    }

    private void visitPackageDef(DetailAST aPkg) {
        FullIdent ident = FullIdent.createFullIdent(aPkg.getLastChild().getPreviousSibling());
        this.mPackageName = ident.getText();
    }

    private void visitClassDef(DetailAST aClassDef) {
        this.mContextStack.push(this.mContext);
        String className = aClassDef.findFirstToken(58).getText();
        this.mContext = new Context(className, aClassDef.getLineNo(), aClassDef.getColumnNo());
    }

    private void leaveClassDef() {
        this.mContext.checkCoupling();
        this.mContext = this.mContextStack.pop();
    }

    private class Context {
        private final Set<String> mReferencedClassNames = Sets.newTreeSet();
        private final String mClassName;
        private final int mLineNo;
        private final int mColumnNo;

        public Context(String aClassName, int aLineNo, int aColumnNo) {
            this.mClassName = aClassName;
            this.mLineNo = aLineNo;
            this.mColumnNo = aColumnNo;
        }

        public void visitLiteralThrows(DetailAST aThrows) {
            for (DetailAST childAST = aThrows.getFirstChild(); childAST != null; childAST = childAST.getNextSibling()) {
                if (childAST.getType() == 74) continue;
                this.addReferencedClassName(childAST);
            }
        }

        public void visitType(DetailAST aAST) {
            String className = CheckUtils.createFullType(aAST).getText();
            AbstractClassCouplingCheck.this.mContext.addReferencedClassName(className);
        }

        public void visitLiteralNew(DetailAST aAST) {
            AbstractClassCouplingCheck.this.mContext.addReferencedClassName(aAST.getFirstChild());
        }

        private void addReferencedClassName(DetailAST aAST) {
            String className = FullIdent.createFullIdent(aAST).getText();
            this.addReferencedClassName(className);
        }

        private void addReferencedClassName(String aClassName) {
            if (this.isSignificant(aClassName)) {
                this.mReferencedClassNames.add(aClassName);
            }
        }

        public void checkCoupling() {
            this.mReferencedClassNames.remove(this.mClassName);
            this.mReferencedClassNames.remove(AbstractClassCouplingCheck.this.mPackageName + "." + this.mClassName);
            if (this.mReferencedClassNames.size() > AbstractClassCouplingCheck.this.mMax) {
                AbstractClassCouplingCheck.this.log(this.mLineNo, this.mColumnNo, AbstractClassCouplingCheck.this.getLogMessageId(), this.mReferencedClassNames.size(), AbstractClassCouplingCheck.this.getMax(), this.mReferencedClassNames.toString());
            }
        }

        private boolean isSignificant(String aClassName) {
            return aClassName.length() > 0 && !AbstractClassCouplingCheck.this.mExcludedClasses.contains(aClassName) && !aClassName.startsWith("java.lang.");
        }
    }
}

