/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.Utils;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.beanutils.ConversionException;

public abstract class AbstractFormatCheck
extends Check {
    private int mCompileFlags;
    private Pattern mRegexp;
    private String mFormat;

    public AbstractFormatCheck(String aDefaultFormat) throws ConversionException {
        this(aDefaultFormat, 0);
    }

    public AbstractFormatCheck(String aDefaultFormat, int aCompileFlags) throws ConversionException {
        this.updateRegexp(aDefaultFormat, aCompileFlags);
    }

    public final void setFormat(String aFormat) throws ConversionException {
        this.updateRegexp(aFormat, this.mCompileFlags);
    }

    public final void setCompileFlags(int aCompileFlags) {
        this.updateRegexp(this.mFormat, aCompileFlags);
    }

    public final Pattern getRegexp() {
        return this.mRegexp;
    }

    public final String getFormat() {
        return this.mFormat;
    }

    private void updateRegexp(String aFormat, int aCompileFlags) {
        try {
            this.mRegexp = Utils.getPattern(aFormat, aCompileFlags);
            this.mFormat = aFormat;
            this.mCompileFlags |= aCompileFlags;
        }
        catch (PatternSyntaxException e) {
            throw new ConversionException("unable to parse " + aFormat, (Throwable)e);
        }
    }
}

