/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.gui;

import antlr.ANTLRException;
import com.puppycrawl.tools.checkstyle.TreeWalker;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.FileText;
import com.puppycrawl.tools.checkstyle.gui.FileDrop;
import com.puppycrawl.tools.checkstyle.gui.JTreeTable;
import com.puppycrawl.tools.checkstyle.gui.Main;
import com.puppycrawl.tools.checkstyle.gui.ParseTreeModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.TooManyListenersException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;

public class ParseTreeInfoPanel
extends JPanel {
    private final JTreeTable mTreeTable;
    private final ParseTreeModel mParseTreeModel;
    private final JTextArea mJTextArea;
    private File mLastDirectory = null;
    private File mCurrentFile = null;
    private final Action reloadAction;

    public void openFile(File aFile, Component aParent) {
        if (aFile != null) {
            try {
                Main.frame.setTitle("Checkstyle : " + aFile.getName());
                FileText text = new FileText(aFile.getAbsoluteFile(), ParseTreeInfoPanel.getEncoding());
                DetailAST parseTree = ParseTreeInfoPanel.parseFile(text);
                this.mParseTreeModel.setParseTree(parseTree);
                this.mCurrentFile = aFile;
                this.mLastDirectory = aFile.getParentFile();
                this.reloadAction.setEnabled(true);
                String[] sourceLines = text.toLinesArray();
                if (this.mJTextArea.getText().length() != 0) {
                    this.mJTextArea.replaceRange("", 0, this.mJTextArea.getText().length());
                }
                for (String element : sourceLines) {
                    this.mJTextArea.append(element + "\n");
                }
                this.mJTextArea.moveCaretPosition(0);
            }
            catch (IOException ex) {
                this.showErrorDialog(aParent, "Could not open " + aFile + ": " + ex.getMessage());
            }
            catch (ANTLRException ex) {
                this.showErrorDialog(aParent, "Could not parse " + aFile + ": " + ex.getMessage());
            }
        }
    }

    @Deprecated
    public static DetailAST parseFile(String aFileName) throws IOException, ANTLRException {
        return ParseTreeInfoPanel.parseFile(new FileText(new File(aFileName), ParseTreeInfoPanel.getEncoding()));
    }

    public static DetailAST parseFile(FileText aText) throws ANTLRException {
        FileContents contents = new FileContents(aText);
        return TreeWalker.parse(contents);
    }

    private static String getEncoding() {
        return System.getProperty("file.encoding", "UTF-8");
    }

    public ParseTreeInfoPanel() {
        this.setLayout(new BorderLayout());
        DetailAST treeRoot = null;
        this.mParseTreeModel = new ParseTreeModel(treeRoot);
        this.mTreeTable = new JTreeTable(this.mParseTreeModel);
        JScrollPane sp = new JScrollPane(this.mTreeTable);
        this.add((Component)sp, "North");
        JButton fileSelectionButton = new JButton(new FileSelectionAction());
        this.reloadAction = new ReloadAction();
        this.reloadAction.setEnabled(false);
        JButton reloadButton = new JButton(this.reloadAction);
        this.mJTextArea = new JTextArea(20, 15);
        this.mJTextArea.setEditable(false);
        JScrollPane sp2 = new JScrollPane(this.mJTextArea);
        this.add((Component)sp2, "Center");
        JPanel p = new JPanel(new GridLayout(1, 2));
        this.add((Component)p, "South");
        p.add(fileSelectionButton);
        p.add(reloadButton);
        try {
            new FileDrop(sp, new FileDropListener(sp));
        }
        catch (TooManyListenersException ex) {
            this.showErrorDialog(null, "Cannot initialize Drag and Drop support");
        }
    }

    private void showErrorDialog(final Component parent, final String msg) {
        Runnable showError = new Runnable(){

            public void run() {
                JOptionPane.showMessageDialog(parent, msg);
            }
        };
        SwingUtilities.invokeLater(showError);
    }

    private class FileDropListener
    implements FileDrop.Listener {
        private final JScrollPane mSp;

        public void filesDropped(File[] files) {
            if (files != null && files.length > 0) {
                File file = files[0];
                ParseTreeInfoPanel.this.openFile(file, this.mSp);
            }
        }

        public FileDropListener(JScrollPane aSp) {
            this.mSp = aSp;
        }
    }

    private class ReloadAction
    extends AbstractAction {
        public ReloadAction() {
            super("Reload Java File");
            this.putValue("MnemonicKey", 82);
        }

        public void actionPerformed(ActionEvent e) {
            Component parent = SwingUtilities.getRoot(ParseTreeInfoPanel.this);
            ParseTreeInfoPanel.this.openFile(ParseTreeInfoPanel.this.mCurrentFile, parent);
        }
    }

    private class FileSelectionAction
    extends AbstractAction {
        public FileSelectionAction() {
            super("Select Java File");
            this.putValue("MnemonicKey", 83);
        }

        public void actionPerformed(ActionEvent e) {
            JFileChooser fc = new JFileChooser(ParseTreeInfoPanel.this.mLastDirectory);
            JavaFileFilter filter = new JavaFileFilter();
            fc.setFileFilter(filter);
            Component parent = SwingUtilities.getRoot(ParseTreeInfoPanel.this);
            fc.showDialog(parent, "Open");
            File file = fc.getSelectedFile();
            ParseTreeInfoPanel.this.openFile(file, parent);
        }
    }

    private static class JavaFileFilter
    extends FileFilter {
        private JavaFileFilter() {
        }

        public boolean accept(File f) {
            if (f == null) {
                return false;
            }
            return f.isDirectory() || f.getName().endsWith(".java");
        }

        public String getDescription() {
            return "Java Source Code";
        }
    }
}

