/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.javadoc;

import com.puppycrawl.tools.checkstyle.checks.javadoc.HtmlTag;
import java.util.ArrayList;
import java.util.List;

class TagParser {
    private final List<HtmlTag> tags = new ArrayList<HtmlTag>();

    TagParser(String[] text, int lineNo) {
        this.parseTags(text, lineNo);
    }

    public HtmlTag nextTag() {
        return this.tags.removeFirst();
    }

    public boolean hasNextTag() {
        return !this.tags.isEmpty();
    }

    private void add(HtmlTag tag) {
        this.tags.add(tag);
    }

    private void parseTags(String[] text, int lineNo) {
        int nLines = text.length;
        Point position = new Point(0, 0);
        while (position.lineNo() < nLines) {
            position = TagParser.isCommentTag(text, position) ? TagParser.skipHtmlComment(text, position) : (TagParser.isTag(text, position) ? this.parseTag(text, lineNo, nLines, position) : TagParser.getNextPoint(text, position));
            position = TagParser.findChar(text, '<', position);
        }
    }

    private Point parseTag(String[] text, int lineNo, int nLines, Point position) {
        Point endTag = TagParser.findChar(text, '>', position);
        boolean incompleteTag = endTag.lineNo() >= nLines;
        String tagId = TagParser.getTagId(text, position);
        boolean closedTag = endTag.lineNo() < nLines && text[endTag.lineNo()].charAt(endTag.columnNo() - 1) == '/';
        this.add(new HtmlTag(tagId, position.lineNo() + lineNo, position.columnNo(), closedTag, incompleteTag, text[position.lineNo()]));
        return endTag;
    }

    private static boolean isTag(String[] javadocText, Point pos) {
        String text;
        int column = pos.columnNo() + 1;
        return column >= (text = javadocText[pos.lineNo()]).length() || Character.isJavaIdentifierStart(text.charAt(column)) || text.charAt(column) == '/';
    }

    private static String getTagId(String[] javadocText, Point tagStart) {
        String text;
        String tagId = "";
        int column = tagStart.columnNo() + 1;
        if (column < (text = javadocText[tagStart.lineNo()]).length()) {
            int position;
            if (text.charAt(column) == '/') {
                ++column;
            }
            text = text.substring(column);
            for (position = 0; position < text.length() && Character.isJavaIdentifierPart(text.charAt(position)); ++position) {
            }
            tagId = text.substring(0, position);
        }
        return tagId;
    }

    private static boolean isCommentTag(String[] text, Point pos) {
        return text[pos.lineNo()].startsWith("<!--", pos.columnNo());
    }

    private static Point skipHtmlComment(String[] text, Point fromPoint) {
        Point toPoint = fromPoint;
        while (toPoint.lineNo() < text.length && !text[toPoint.lineNo()].substring(0, toPoint.columnNo() + 1).endsWith("-->")) {
            toPoint = TagParser.getNextPoint(text, toPoint);
        }
        return toPoint;
    }

    private static Point findChar(String[] text, char character, Point from) {
        Point curr = new Point(from.lineNo(), from.columnNo());
        while (curr.lineNo() < text.length && text[curr.lineNo()].charAt(curr.columnNo()) != character) {
            curr = TagParser.getNextPoint(text, curr);
        }
        return curr;
    }

    private static Point getNextPoint(String[] text, Point from) {
        int line;
        int column = from.columnNo() + 1;
        for (line = from.lineNo(); line < text.length && column >= text[line].length(); ++line) {
            column = 0;
        }
        return new Point(line, column);
    }

    private record Point(int lineNo, int columnNo) {
    }
}

