/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.FileStatefulCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.ScopeUtil;
import java.util.ArrayDeque;
import java.util.Deque;

@FileStatefulCheck
public abstract class AbstractSuperCheck
extends AbstractCheck {
    public static final String MSG_KEY = "missing.super.call";
    private final Deque<MethodNode> methodStack = new ArrayDeque<MethodNode>();

    protected abstract String getMethodName();

    @Override
    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{9, 79};
    }

    @Override
    public void beginTree(DetailAST rootAST) {
        this.methodStack.clear();
    }

    @Override
    public void visitToken(DetailAST ast) {
        if (this.isOverridingMethod(ast)) {
            this.methodStack.add(new MethodNode(ast));
        } else if (this.isSuperCall(ast)) {
            MethodNode methodNode = this.methodStack.getLast();
            methodNode.setCallingSuper();
        }
    }

    private boolean isSuperCall(DetailAST literalSuperAst) {
        DetailAST parent;
        boolean superCall = false;
        if (!(this.isSameNameMethod(literalSuperAst) || (parent = literalSuperAst.getParent()).getType() != 180 && AbstractSuperCheck.hasArguments(parent))) {
            superCall = this.isSuperCallInOverridingMethod(parent);
        }
        return superCall;
    }

    private boolean isSuperCallInOverridingMethod(DetailAST ast) {
        boolean inOverridingMethod = false;
        DetailAST dotAst = ast;
        while (dotAst.getType() != 8 && dotAst.getType() != 11) {
            if (dotAst.getType() == 9) {
                inOverridingMethod = this.isOverridingMethod(dotAst);
                break;
            }
            dotAst = dotAst.getParent();
        }
        return inOverridingMethod;
    }

    private static boolean hasArguments(DetailAST methodCallDotAst) {
        DetailAST argumentsList = methodCallDotAst.getNextSibling();
        return argumentsList.hasChildren();
    }

    private boolean isSameNameMethod(DetailAST ast) {
        DetailAST sibling = ast.getNextSibling();
        if (sibling != null && sibling.getType() == 163) {
            sibling = sibling.getNextSibling();
        }
        return sibling == null || !this.getMethodName().equals(sibling.getText());
    }

    @Override
    public void leaveToken(DetailAST ast) {
        MethodNode methodNode;
        if (this.isOverridingMethod(ast) && !(methodNode = this.methodStack.removeLast()).isCallingSuper()) {
            DetailAST methodAST = methodNode.getMethod();
            DetailAST nameAST = methodAST.findFirstToken(58);
            this.log(nameAST, MSG_KEY, nameAST.getText());
        }
    }

    private boolean isOverridingMethod(DetailAST ast) {
        boolean overridingMethod = false;
        if (ast.getType() == 9 && !ScopeUtil.isInInterfaceOrAnnotationBlock(ast)) {
            DetailAST nameAST = ast.findFirstToken(58);
            String name = nameAST.getText();
            DetailAST modifiersAST = ast.findFirstToken(5);
            if (this.getMethodName().equals(name) && modifiersAST.findFirstToken(66) == null) {
                DetailAST params = ast.findFirstToken(20);
                overridingMethod = !params.hasChildren();
            }
        }
        return overridingMethod;
    }

    private static final class MethodNode {
        private final DetailAST method;
        private boolean callingSuper;

        private MethodNode(DetailAST ast) {
            this.method = ast;
        }

        void setCallingSuper() {
            this.callingSuper = true;
        }

        boolean isCallingSuper() {
            return this.callingSuper;
        }

        DetailAST getMethod() {
            return this.method;
        }
    }
}

