/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle;

import com.puppycrawl.tools.checkstyle.api.DetailNode;
import com.puppycrawl.tools.checkstyle.checks.javadoc.JavadocNodeImpl;
import com.puppycrawl.tools.checkstyle.grammar.javadoc.JavadocCommentsParser;
import com.puppycrawl.tools.checkstyle.grammar.javadoc.JavadocCommentsParserBaseVisitor;
import com.puppycrawl.tools.checkstyle.utils.JavadocUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.antlr.v4.runtime.BufferedTokenStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;

public class JavadocCommentsAstVisitor
extends JavadocCommentsParserBaseVisitor<JavadocNodeImpl> {
    private static final Set<Integer> JAVADOC_TAG_TYPES = Set.of(9, 10, 16, 35, 37, 38, 39, 40, 19, 110, 42, 111, 17, 18, 20, 46, 45, 48, 49, 50, 52, 108, 109, 53, 54, 55);
    private final int blockCommentLineNumber;
    private final int javadocColumnNumber;
    private final BufferedTokenStream tokens;
    private final Set<Integer> processedTokenIndices = new HashSet<Integer>();
    private final TextAccumulator accumulator = new TextAccumulator();
    private DetailNode firstNonTightHtmlTag;

    public JavadocCommentsAstVisitor(CommonTokenStream tokens, int blockCommentLineNumber, int javadocColumnNumber) {
        this.tokens = tokens;
        this.blockCommentLineNumber = blockCommentLineNumber;
        this.javadocColumnNumber = javadocColumnNumber;
    }

    @Override
    public JavadocNodeImpl visitJavadoc(JavadocCommentsParser.JavadocContext ctx) {
        return this.buildImaginaryNode(1, ctx);
    }

    @Override
    public JavadocNodeImpl visitMainDescription(JavadocCommentsParser.MainDescriptionContext ctx) {
        return this.flattenedTree(ctx);
    }

    @Override
    public JavadocNodeImpl visitBlockTag(JavadocCommentsParser.BlockTagContext ctx) {
        JavadocNodeImpl blockTagNode = this.createImaginary(75);
        ParseTree tag = ctx.getChild(0);
        if (tag instanceof ParserRuleContext) {
            ParserRuleContext context = (ParserRuleContext)tag;
            Token tagName = (Token)context.getChild(1).getPayload();
            int tokenType = tagName.getType();
            JavadocNodeImpl specificTagNode = switch (tokenType) {
                case 17 -> this.buildImaginaryNode(88, ctx);
                case 18 -> this.buildImaginaryNode(89, ctx);
                case 19 -> this.buildImaginaryNode(90, ctx);
                case 20 -> this.buildImaginaryNode(91, ctx);
                case 46 -> this.buildImaginaryNode(93, ctx);
                case 45 -> this.buildImaginaryNode(92, ctx);
                case 48 -> this.buildImaginaryNode(94, ctx);
                case 49 -> this.buildImaginaryNode(95, ctx);
                case 50 -> this.buildImaginaryNode(96, ctx);
                case 52 -> this.buildImaginaryNode(97, ctx);
                case 108 -> this.buildImaginaryNode(98, ctx);
                case 109 -> this.buildImaginaryNode(99, ctx);
                case 53 -> this.buildImaginaryNode(100, ctx);
                case 54 -> this.buildImaginaryNode(101, ctx);
                case 55 -> this.buildImaginaryNode(102, ctx);
                default -> this.buildImaginaryNode(103, ctx);
            };
            blockTagNode.addChild(specificTagNode);
        }
        return blockTagNode;
    }

    @Override
    public JavadocNodeImpl visitAuthorTag(JavadocCommentsParser.AuthorTagContext ctx) {
        return this.flattenedTree(ctx);
    }

    @Override
    public JavadocNodeImpl visitDeprecatedTag(JavadocCommentsParser.DeprecatedTagContext ctx) {
        return this.flattenedTree(ctx);
    }

    @Override
    public JavadocNodeImpl visitReturnTag(JavadocCommentsParser.ReturnTagContext ctx) {
        return this.flattenedTree(ctx);
    }

    @Override
    public JavadocNodeImpl visitParameterTag(JavadocCommentsParser.ParameterTagContext ctx) {
        return this.flattenedTree(ctx);
    }

    @Override
    public JavadocNodeImpl visitThrowsTag(JavadocCommentsParser.ThrowsTagContext ctx) {
        return this.flattenedTree(ctx);
    }

    @Override
    public JavadocNodeImpl visitExceptionTag(JavadocCommentsParser.ExceptionTagContext ctx) {
        return this.flattenedTree(ctx);
    }

    @Override
    public JavadocNodeImpl visitSinceTag(JavadocCommentsParser.SinceTagContext ctx) {
        return this.flattenedTree(ctx);
    }

    @Override
    public JavadocNodeImpl visitVersionTag(JavadocCommentsParser.VersionTagContext ctx) {
        return this.flattenedTree(ctx);
    }

    @Override
    public JavadocNodeImpl visitSeeTag(JavadocCommentsParser.SeeTagContext ctx) {
        return this.flattenedTree(ctx);
    }

    @Override
    public JavadocNodeImpl visitHiddenTag(JavadocCommentsParser.HiddenTagContext ctx) {
        return this.flattenedTree(ctx);
    }

    @Override
    public JavadocNodeImpl visitUsesTag(JavadocCommentsParser.UsesTagContext ctx) {
        return this.flattenedTree(ctx);
    }

    @Override
    public JavadocNodeImpl visitProvidesTag(JavadocCommentsParser.ProvidesTagContext ctx) {
        return this.flattenedTree(ctx);
    }

    @Override
    public JavadocNodeImpl visitSerialTag(JavadocCommentsParser.SerialTagContext ctx) {
        return this.flattenedTree(ctx);
    }

    @Override
    public JavadocNodeImpl visitSerialDataTag(JavadocCommentsParser.SerialDataTagContext ctx) {
        return this.flattenedTree(ctx);
    }

    @Override
    public JavadocNodeImpl visitSerialFieldTag(JavadocCommentsParser.SerialFieldTagContext ctx) {
        return this.flattenedTree(ctx);
    }

    @Override
    public JavadocNodeImpl visitCustomBlockTag(JavadocCommentsParser.CustomBlockTagContext ctx) {
        return this.flattenedTree(ctx);
    }

    @Override
    public JavadocNodeImpl visitInlineTag(JavadocCommentsParser.InlineTagContext ctx) {
        JavadocNodeImpl inlineTagNode = this.createImaginary(6);
        ParseTree tagContent = ctx.inlineTagContent().getChild(0);
        if (tagContent instanceof ParserRuleContext) {
            ParserRuleContext context = (ParserRuleContext)tagContent;
            Token tagName = (Token)context.getChild(0).getPayload();
            int tokenType = tagName.getType();
            JavadocNodeImpl specificTagNode = switch (tokenType) {
                case 9 -> this.buildImaginaryNode(76, ctx);
                case 10 -> this.buildImaginaryNode(77, ctx);
                case 16 -> this.buildImaginaryNode(78, ctx);
                case 35 -> this.buildImaginaryNode(79, ctx);
                case 37 -> this.buildImaginaryNode(80, ctx);
                case 38 -> this.buildImaginaryNode(81, ctx);
                case 39 -> this.buildImaginaryNode(82, ctx);
                case 40 -> this.buildImaginaryNode(83, ctx);
                case 19 -> this.buildImaginaryNode(84, ctx);
                case 110 -> this.buildImaginaryNode(85, ctx);
                case 42 -> this.buildImaginaryNode(86, ctx);
                default -> this.buildImaginaryNode(87, ctx);
            };
            inlineTagNode.addChild(specificTagNode);
        }
        return inlineTagNode;
    }

    @Override
    public JavadocNodeImpl visitInlineTagContent(JavadocCommentsParser.InlineTagContentContext ctx) {
        return this.flattenedTree(ctx);
    }

    @Override
    public JavadocNodeImpl visitCodeInlineTag(JavadocCommentsParser.CodeInlineTagContext ctx) {
        return this.flattenedTree(ctx);
    }

    @Override
    public JavadocNodeImpl visitLinkPlainInlineTag(JavadocCommentsParser.LinkPlainInlineTagContext ctx) {
        return this.flattenedTree(ctx);
    }

    @Override
    public JavadocNodeImpl visitLinkInlineTag(JavadocCommentsParser.LinkInlineTagContext ctx) {
        return this.flattenedTree(ctx);
    }

    @Override
    public JavadocNodeImpl visitValueInlineTag(JavadocCommentsParser.ValueInlineTagContext ctx) {
        return this.flattenedTree(ctx);
    }

    @Override
    public JavadocNodeImpl visitInheritDocInlineTag(JavadocCommentsParser.InheritDocInlineTagContext ctx) {
        return this.flattenedTree(ctx);
    }

    @Override
    public JavadocNodeImpl visitSummaryInlineTag(JavadocCommentsParser.SummaryInlineTagContext ctx) {
        return this.flattenedTree(ctx);
    }

    @Override
    public JavadocNodeImpl visitSystemPropertyInlineTag(JavadocCommentsParser.SystemPropertyInlineTagContext ctx) {
        return this.flattenedTree(ctx);
    }

    @Override
    public JavadocNodeImpl visitIndexInlineTag(JavadocCommentsParser.IndexInlineTagContext ctx) {
        return this.flattenedTree(ctx);
    }

    @Override
    public JavadocNodeImpl visitReturnInlineTag(JavadocCommentsParser.ReturnInlineTagContext ctx) {
        return this.flattenedTree(ctx);
    }

    @Override
    public JavadocNodeImpl visitLiteralInlineTag(JavadocCommentsParser.LiteralInlineTagContext ctx) {
        return this.flattenedTree(ctx);
    }

    @Override
    public JavadocNodeImpl visitSnippetInlineTag(JavadocCommentsParser.SnippetInlineTagContext ctx) {
        JavadocNodeImpl dummyRoot = new JavadocNodeImpl();
        if (!ctx.snippetAttributes.isEmpty()) {
            JavadocNodeImpl snippetAttributes = this.createImaginary(65);
            ctx.snippetAttributes.forEach(snippetAttributeContext -> {
                JavadocNodeImpl snippetAttribute = (JavadocNodeImpl)this.visit((ParseTree)snippetAttributeContext);
                snippetAttributes.addChild(snippetAttribute);
            });
            dummyRoot.addChild(snippetAttributes);
        }
        if (ctx.COLON() != null) {
            dummyRoot.addChild(this.create((Token)ctx.COLON().getPayload()));
        }
        if (ctx.snippetBody() != null) {
            dummyRoot.addChild((DetailNode)this.visit((ParseTree)ctx.snippetBody()));
        }
        return dummyRoot.getFirstChild();
    }

    @Override
    public JavadocNodeImpl visitCustomInlineTag(JavadocCommentsParser.CustomInlineTagContext ctx) {
        return this.flattenedTree(ctx);
    }

    @Override
    public JavadocNodeImpl visitReference(JavadocCommentsParser.ReferenceContext ctx) {
        return this.buildImaginaryNode(59, ctx);
    }

    @Override
    public JavadocNodeImpl visitTypeName(JavadocCommentsParser.TypeNameContext ctx) {
        return this.flattenedTree(ctx);
    }

    @Override
    public JavadocNodeImpl visitQualifiedName(JavadocCommentsParser.QualifiedNameContext ctx) {
        return this.flattenedTree(ctx);
    }

    @Override
    public JavadocNodeImpl visitTypeArguments(JavadocCommentsParser.TypeArgumentsContext ctx) {
        return this.buildImaginaryNode(62, ctx);
    }

    @Override
    public JavadocNodeImpl visitTypeArgument(JavadocCommentsParser.TypeArgumentContext ctx) {
        return this.buildImaginaryNode(63, ctx);
    }

    @Override
    public JavadocNodeImpl visitMemberReference(JavadocCommentsParser.MemberReferenceContext ctx) {
        return this.buildImaginaryNode(60, ctx);
    }

    @Override
    public JavadocNodeImpl visitParameterTypeList(JavadocCommentsParser.ParameterTypeListContext ctx) {
        return this.buildImaginaryNode(61, ctx);
    }

    @Override
    public JavadocNodeImpl visitDescription(JavadocCommentsParser.DescriptionContext ctx) {
        return this.buildImaginaryNode(64, ctx);
    }

    @Override
    public JavadocNodeImpl visitSnippetAttribute(JavadocCommentsParser.SnippetAttributeContext ctx) {
        return this.buildImaginaryNode(66, ctx);
    }

    @Override
    public JavadocNodeImpl visitSnippetBody(JavadocCommentsParser.SnippetBodyContext ctx) {
        return this.buildImaginaryNode(67, ctx);
    }

    @Override
    public JavadocNodeImpl visitHtmlElement(JavadocCommentsParser.HtmlElementContext ctx) {
        return this.buildImaginaryNode(68, ctx);
    }

    @Override
    public JavadocNodeImpl visitVoidElement(JavadocCommentsParser.VoidElementContext ctx) {
        return this.buildImaginaryNode(69, ctx);
    }

    @Override
    public JavadocNodeImpl visitTightElement(JavadocCommentsParser.TightElementContext ctx) {
        return this.flattenedTree(ctx);
    }

    @Override
    public JavadocNodeImpl visitNonTightElement(JavadocCommentsParser.NonTightElementContext ctx) {
        if (this.firstNonTightHtmlTag == null) {
            ParseTree htmlTagStart = ctx.getChild(0);
            ParseTree tagNameToken = htmlTagStart.getChild(1);
            this.firstNonTightHtmlTag = this.create((Token)tagNameToken.getPayload());
        }
        return this.flattenedTree(ctx);
    }

    @Override
    public JavadocNodeImpl visitSelfClosingElement(JavadocCommentsParser.SelfClosingElementContext ctx) {
        JavadocNodeImpl javadocNode = this.createImaginary(69);
        javadocNode.addChild(this.create((Token)ctx.TAG_OPEN().getPayload()));
        javadocNode.addChild(this.create((Token)ctx.TAG_NAME().getPayload()));
        if (!ctx.htmlAttributes.isEmpty()) {
            JavadocNodeImpl htmlAttributes = this.createImaginary(73);
            ctx.htmlAttributes.forEach(htmlAttributeContext -> {
                JavadocNodeImpl htmlAttribute = (JavadocNodeImpl)this.visit((ParseTree)htmlAttributeContext);
                htmlAttributes.addChild(htmlAttribute);
            });
            javadocNode.addChild(htmlAttributes);
        }
        javadocNode.addChild(this.create((Token)ctx.TAG_SLASH_CLOSE().getPayload()));
        return javadocNode;
    }

    @Override
    public JavadocNodeImpl visitHtmlTagStart(JavadocCommentsParser.HtmlTagStartContext ctx) {
        JavadocNodeImpl javadocNode = this.createImaginary(71);
        javadocNode.addChild(this.create((Token)ctx.TAG_OPEN().getPayload()));
        javadocNode.addChild(this.create((Token)ctx.TAG_NAME().getPayload()));
        if (!ctx.htmlAttributes.isEmpty()) {
            JavadocNodeImpl htmlAttributes = this.createImaginary(73);
            ctx.htmlAttributes.forEach(htmlAttributeContext -> {
                JavadocNodeImpl htmlAttribute = (JavadocNodeImpl)this.visit((ParseTree)htmlAttributeContext);
                htmlAttributes.addChild(htmlAttribute);
            });
            javadocNode.addChild(htmlAttributes);
        }
        Token tagClose = (Token)ctx.TAG_CLOSE().getPayload();
        this.addHiddenTokensToTheLeft(tagClose, javadocNode);
        javadocNode.addChild(this.create(tagClose));
        return javadocNode;
    }

    @Override
    public JavadocNodeImpl visitHtmlTagEnd(JavadocCommentsParser.HtmlTagEndContext ctx) {
        return this.buildImaginaryNode(72, ctx);
    }

    @Override
    public JavadocNodeImpl visitHtmlAttribute(JavadocCommentsParser.HtmlAttributeContext ctx) {
        return this.buildImaginaryNode(74, ctx);
    }

    @Override
    public JavadocNodeImpl visitHtmlContent(JavadocCommentsParser.HtmlContentContext ctx) {
        return this.buildImaginaryNode(70, ctx);
    }

    @Override
    public JavadocNodeImpl visitNonTightHtmlContent(JavadocCommentsParser.NonTightHtmlContentContext ctx) {
        return this.buildImaginaryNode(70, ctx);
    }

    @Override
    public JavadocNodeImpl visitHtmlComment(JavadocCommentsParser.HtmlCommentContext ctx) {
        return this.buildImaginaryNode(106, ctx);
    }

    @Override
    public JavadocNodeImpl visitHtmlCommentContent(JavadocCommentsParser.HtmlCommentContentContext ctx) {
        return this.buildImaginaryNode(107, ctx);
    }

    private JavadocNodeImpl buildImaginaryNode(int tokenType, ParserRuleContext ctx) {
        JavadocNodeImpl javadocNode = this.createImaginary(tokenType);
        this.processChildren(javadocNode, ctx.children);
        return javadocNode;
    }

    private JavadocNodeImpl flattenedTree(ParserRuleContext ctx) {
        JavadocNodeImpl dummyNode = new JavadocNodeImpl();
        this.processChildren(dummyNode, ctx.children);
        return dummyNode.getFirstChild();
    }

    private void processChildren(JavadocNodeImpl parent, List<? extends ParseTree> children) {
        for (ParseTree parseTree : children) {
            Token token;
            if (parseTree instanceof TerminalNode) {
                TerminalNode terminalNode = (TerminalNode)parseTree;
                token = (Token)terminalNode.getPayload();
                this.addHiddenTokensToTheLeft(token, parent);
                if (JavadocCommentsAstVisitor.isTextToken(token)) {
                    this.accumulator.append(token);
                    continue;
                }
                if (token.getType() == -1) continue;
                this.accumulator.flushTo(parent);
                parent.addChild(this.create(token));
                continue;
            }
            this.accumulator.flushTo(parent);
            token = ((ParserRuleContext)parseTree).getStart();
            this.addHiddenTokensToTheLeft(token, parent);
            parent.addChild((DetailNode)this.visit(parseTree));
        }
        this.accumulator.flushTo(parent);
    }

    private static boolean isTextToken(Token token) {
        return token.getType() == 4;
    }

    private void addHiddenTokensToTheLeft(Token token, JavadocNodeImpl parent) {
        int tokenIndex;
        List hiddenTokens;
        boolean alreadyProcessed;
        boolean bl = alreadyProcessed = !this.processedTokenIndices.add(token.getTokenIndex());
        if (!alreadyProcessed && (hiddenTokens = this.tokens.getHiddenTokensToLeft(tokenIndex = token.getTokenIndex())) != null) {
            this.accumulator.flushTo(parent);
            for (Token hiddenToken : hiddenTokens) {
                parent.addChild(this.create(hiddenToken));
            }
        }
    }

    private JavadocNodeImpl create(Token token) {
        JavadocNodeImpl node = new JavadocNodeImpl();
        node.initialize(token);
        node.setLineNumber(node.getLineNumber() + this.blockCommentLineNumber);
        if (node.getLineNumber() == this.blockCommentLineNumber) {
            node.setColumnNumber(node.getColumnNumber() + this.javadocColumnNumber);
        }
        if (JavadocCommentsAstVisitor.isJavadocTag(token.getType())) {
            node.setType(26);
        }
        if (token.getType() == 5) {
            node.setType(4);
        }
        return node;
    }

    private static boolean isJavadocTag(int type) {
        return JAVADOC_TAG_TYPES.contains(type);
    }

    private JavadocNodeImpl createImaginary(int tokenType) {
        JavadocNodeImpl node = new JavadocNodeImpl();
        node.setType(tokenType);
        node.setText(JavadocUtil.getTokenName(tokenType));
        if (tokenType == 1) {
            node.setLineNumber(this.blockCommentLineNumber);
            node.setColumnNumber(this.javadocColumnNumber);
        }
        return node;
    }

    public DetailNode getFirstNonTightHtmlTag() {
        return this.firstNonTightHtmlTag;
    }

    private final class TextAccumulator {
        private final StringBuilder buffer = new StringBuilder(256);
        private Token startToken;

        private TextAccumulator() {
        }

        void append(Token token) {
            if (this.buffer.isEmpty()) {
                this.startToken = token;
            }
            this.buffer.append(token.getText());
        }

        void flushTo(JavadocNodeImpl parent) {
            if (!this.buffer.isEmpty()) {
                JavadocNodeImpl startNode = JavadocCommentsAstVisitor.this.create(this.startToken);
                startNode.setText(this.buffer.toString());
                parent.addChild(startNode);
                this.buffer.setLength(0);
            }
        }
    }
}

