/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle;

import com.puppycrawl.tools.checkstyle.AbstractAutomaticBean;
import com.puppycrawl.tools.checkstyle.LocalizedMessage;
import com.puppycrawl.tools.checkstyle.api.AuditEvent;
import com.puppycrawl.tools.checkstyle.api.AuditListener;
import com.puppycrawl.tools.checkstyle.api.AutomaticBean;
import com.puppycrawl.tools.checkstyle.api.SeverityLevel;
import com.puppycrawl.tools.checkstyle.meta.ModuleDetails;
import com.puppycrawl.tools.checkstyle.meta.XmlMetaReader;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.regex.Pattern;

public final class SarifLogger
extends AbstractAutomaticBean
implements AuditListener {
    private static final int UNICODE_LENGTH = 4;
    private static final int UNICODE_ESCAPE_UPPER_LIMIT = 31;
    private static final int BUFFER_SIZE = 1024;
    private static final String MESSAGE_PLACEHOLDER = "${message}";
    private static final String MESSAGE_TEXT_PLACEHOLDER = "${messageText}";
    private static final String MESSAGE_ID_PLACEHOLDER = "${messageId}";
    private static final String SEVERITY_LEVEL_PLACEHOLDER = "${severityLevel}";
    private static final String URI_PLACEHOLDER = "${uri}";
    private static final String LINE_PLACEHOLDER = "${line}";
    private static final String COLUMN_PLACEHOLDER = "${column}";
    private static final String RULE_ID_PLACEHOLDER = "${ruleId}";
    private static final String VERSION_PLACEHOLDER = "${version}";
    private static final String RESULTS_PLACEHOLDER = "${results}";
    private static final String RULES_PLACEHOLDER = "${rules}";
    private static final String TWO_BACKSLASHES = "\\\\";
    private static final Pattern A_SPACE_PATTERN = Pattern.compile(" ");
    private static final Pattern TWO_BACKSLASHES_PATTERN = Pattern.compile("\\\\");
    private static final Pattern WINDOWS_DRIVE_LETTER_PATTERN = Pattern.compile("\\A[A-Z]:", 2);
    private static final String COMMA_LINE_SEPARATOR = ",\n";
    private final PrintWriter writer;
    private final boolean closeStream;
    private final List<String> results = new ArrayList<String>();
    private final Map<String, ModuleDetails> allModuleMetadata = new HashMap<String, ModuleDetails>();
    private final Map<RuleKey, ModuleDetails> ruleMetadata = new LinkedHashMap<RuleKey, ModuleDetails>();
    private final String report;
    private final String resultLineColumn;
    private final String resultLineOnly;
    private final String resultFileOnly;
    private final String resultErrorOnly;
    private final String rule;
    private final String messageStrings;
    private final String messageTextOnly;
    private final String messageWithId;

    public SarifLogger(OutputStream outputStream, AutomaticBean.OutputStreamOptions outputStreamOptions) throws IOException {
        this(outputStream, AbstractAutomaticBean.OutputStreamOptions.valueOf(outputStreamOptions.name()));
    }

    public SarifLogger(OutputStream outputStream, AbstractAutomaticBean.OutputStreamOptions outputStreamOptions) throws IOException {
        if (outputStreamOptions == null) {
            throw new IllegalArgumentException("Parameter outputStreamOptions can not be null");
        }
        this.writer = new PrintWriter(new OutputStreamWriter(outputStream, StandardCharsets.UTF_8));
        this.closeStream = outputStreamOptions == AbstractAutomaticBean.OutputStreamOptions.CLOSE;
        this.loadModuleMetadata();
        this.report = SarifLogger.readResource("/com/puppycrawl/tools/checkstyle/sarif/SarifReport.template");
        this.resultLineColumn = SarifLogger.readResource("/com/puppycrawl/tools/checkstyle/sarif/ResultLineColumn.template");
        this.resultLineOnly = SarifLogger.readResource("/com/puppycrawl/tools/checkstyle/sarif/ResultLineOnly.template");
        this.resultFileOnly = SarifLogger.readResource("/com/puppycrawl/tools/checkstyle/sarif/ResultFileOnly.template");
        this.resultErrorOnly = SarifLogger.readResource("/com/puppycrawl/tools/checkstyle/sarif/ResultErrorOnly.template");
        this.rule = SarifLogger.readResource("/com/puppycrawl/tools/checkstyle/sarif/Rule.template");
        this.messageStrings = SarifLogger.readResource("/com/puppycrawl/tools/checkstyle/sarif/MessageStrings.template");
        this.messageTextOnly = SarifLogger.readResource("/com/puppycrawl/tools/checkstyle/sarif/MessageTextOnly.template");
        this.messageWithId = SarifLogger.readResource("/com/puppycrawl/tools/checkstyle/sarif/MessageWithId.template");
    }

    private void loadModuleMetadata() {
        List<ModuleDetails> allModules = XmlMetaReader.readAllModulesIncludingThirdPartyIfAny(new String[0]);
        for (ModuleDetails module : allModules) {
            this.allModuleMetadata.put(module.getFullQualifiedName(), module);
        }
    }

    @Override
    protected void finishLocalSetup() {
    }

    @Override
    public void auditStarted(AuditEvent event) {
    }

    @Override
    public void auditFinished(AuditEvent event) {
        String rendered = SarifLogger.replaceVersionString(this.report);
        rendered = rendered.replace(RESULTS_PLACEHOLDER, String.join((CharSequence)COMMA_LINE_SEPARATOR, this.results)).replace(RULES_PLACEHOLDER, String.join((CharSequence)COMMA_LINE_SEPARATOR, this.generateRules()));
        this.writer.print(rendered);
        if (this.closeStream) {
            this.writer.close();
        } else {
            this.writer.flush();
        }
    }

    private List<String> generateRules() {
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<RuleKey, ModuleDetails> entry : this.ruleMetadata.entrySet()) {
            String messageStringsFragment;
            String fullDescription;
            String shortDescription;
            RuleKey ruleKey = entry.getKey();
            ModuleDetails module = entry.getValue();
            if (module == null) {
                shortDescription = CommonUtil.baseClassName(ruleKey.sourceName());
                fullDescription = "No description available";
                messageStringsFragment = "";
            } else {
                shortDescription = module.getName();
                fullDescription = module.getDescription();
                messageStringsFragment = String.join((CharSequence)COMMA_LINE_SEPARATOR, this.generateMessageStrings(module));
            }
            result.add(this.rule.replace(RULE_ID_PLACEHOLDER, ruleKey.toRuleId()).replace("${shortDescription}", shortDescription).replace("${fullDescription}", SarifLogger.escape(fullDescription)).replace("${messageStrings}", messageStringsFragment));
        }
        return result;
    }

    private List<String> generateMessageStrings(ModuleDetails module) {
        Map<String, String> messages = SarifLogger.getMessages(module);
        return module.getViolationMessageKeys().stream().filter(messages::containsKey).map(key -> {
            String message = (String)messages.get(key);
            return this.messageStrings.replace("${key}", (CharSequence)key).replace("${text}", SarifLogger.escape(message));
        }).toList();
    }

    private static Map<String, String> getMessages(ModuleDetails moduleDetails) {
        String fullQualifiedName = moduleDetails.getFullQualifiedName();
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        try {
            int lastDot = fullQualifiedName.lastIndexOf(46);
            String packageName = fullQualifiedName.substring(0, lastDot);
            String bundleName = packageName + ".messages";
            Class<?> moduleClass = Class.forName(fullQualifiedName);
            ResourceBundle bundle = ResourceBundle.getBundle(bundleName, Locale.ROOT, moduleClass.getClassLoader(), new LocalizedMessage.Utf8Control());
            for (String key : moduleDetails.getViolationMessageKeys()) {
                result.put(key, bundle.getString(key));
            }
        }
        catch (ClassNotFoundException | MissingResourceException exception) {
            // empty catch block
        }
        return result;
    }

    private static String replaceVersionString(String report) {
        String version = SarifLogger.class.getPackage().getImplementationVersion();
        return report.replace(VERSION_PLACEHOLDER, String.valueOf(version));
    }

    @Override
    public void addError(AuditEvent event) {
        RuleKey ruleKey = this.cacheRuleMetadata(event);
        String message = this.generateMessage(ruleKey, event);
        if (event.getColumn() > 0) {
            this.results.add(this.resultLineColumn.replace(SEVERITY_LEVEL_PLACEHOLDER, SarifLogger.renderSeverityLevel(event.getSeverityLevel())).replace(URI_PLACEHOLDER, SarifLogger.renderFileNameUri(event.getFileName())).replace(COLUMN_PLACEHOLDER, Integer.toString(event.getColumn())).replace(LINE_PLACEHOLDER, Integer.toString(event.getLine())).replace(MESSAGE_PLACEHOLDER, message).replace(RULE_ID_PLACEHOLDER, ruleKey.toRuleId()));
        } else {
            this.results.add(this.resultLineOnly.replace(SEVERITY_LEVEL_PLACEHOLDER, SarifLogger.renderSeverityLevel(event.getSeverityLevel())).replace(URI_PLACEHOLDER, SarifLogger.renderFileNameUri(event.getFileName())).replace(LINE_PLACEHOLDER, Integer.toString(event.getLine())).replace(MESSAGE_PLACEHOLDER, message).replace(RULE_ID_PLACEHOLDER, ruleKey.toRuleId()));
        }
    }

    private RuleKey cacheRuleMetadata(AuditEvent event) {
        String sourceName = event.getSourceName();
        RuleKey key = new RuleKey(sourceName, event.getModuleId());
        ModuleDetails module = this.allModuleMetadata.get(sourceName);
        this.ruleMetadata.putIfAbsent(key, module);
        return key;
    }

    private String generateMessage(RuleKey ruleKey, AuditEvent event) {
        String violationKey = event.getViolation().getKey();
        ModuleDetails module = this.ruleMetadata.get(ruleKey);
        String result = module != null && module.getViolationMessageKeys().contains(violationKey) ? this.messageWithId.replace(MESSAGE_ID_PLACEHOLDER, violationKey).replace(MESSAGE_TEXT_PLACEHOLDER, SarifLogger.escape(event.getMessage())) : this.messageTextOnly.replace(MESSAGE_TEXT_PLACEHOLDER, SarifLogger.escape(event.getMessage()));
        return result;
    }

    @Override
    public void addException(AuditEvent event, Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printer = new PrintWriter(stringWriter);
        throwable.printStackTrace(printer);
        String message = this.messageTextOnly.replace(MESSAGE_TEXT_PLACEHOLDER, SarifLogger.escape(stringWriter.toString()));
        if (event.getFileName() == null) {
            this.results.add(this.resultErrorOnly.replace(SEVERITY_LEVEL_PLACEHOLDER, SarifLogger.renderSeverityLevel(event.getSeverityLevel())).replace(MESSAGE_PLACEHOLDER, message));
        } else {
            this.results.add(this.resultFileOnly.replace(SEVERITY_LEVEL_PLACEHOLDER, SarifLogger.renderSeverityLevel(event.getSeverityLevel())).replace(URI_PLACEHOLDER, SarifLogger.renderFileNameUri(event.getFileName())).replace(MESSAGE_PLACEHOLDER, message));
        }
    }

    @Override
    public void fileStarted(AuditEvent event) {
    }

    @Override
    public void fileFinished(AuditEvent event) {
    }

    private static String renderFileNameUri(String fileName) {
        Object normalized = A_SPACE_PATTERN.matcher(TWO_BACKSLASHES_PATTERN.matcher(fileName).replaceAll("/")).replaceAll("%20");
        if (WINDOWS_DRIVE_LETTER_PATTERN.matcher((CharSequence)normalized).find()) {
            normalized = "/" + (String)normalized;
        }
        return "file:" + (String)normalized;
    }

    private static String renderSeverityLevel(SeverityLevel severityLevel) {
        return switch (severityLevel) {
            default -> throw new MatchException(null, null);
            case SeverityLevel.IGNORE -> "none";
            case SeverityLevel.INFO -> "note";
            case SeverityLevel.WARNING -> "warning";
            case SeverityLevel.ERROR -> "error";
        };
    }

    public static String escape(String value) {
        int length = value.length();
        StringBuilder sb = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            char chr = value.charAt(i);
            String replacement = switch (chr) {
                case '\"' -> "\\\"";
                case '\\' -> TWO_BACKSLASHES;
                case '\b' -> "\\b";
                case '\f' -> "\\f";
                case '\n' -> "\\n";
                case '\r' -> "\\r";
                case '\t' -> "\\t";
                case '/' -> "\\/";
                default -> chr <= '\u001f' ? SarifLogger.escapeUnicode1F(chr) : Character.toString(chr);
            };
            sb.append(replacement);
        }
        return sb.toString();
    }

    private static String escapeUnicode1F(char chr) {
        String hexString = Integer.toHexString(chr);
        return "\\u" + "0".repeat(4 - hexString.length()) + hexString.toUpperCase(Locale.US);
    }

    public static String readResource(String name) throws IOException {
        try (InputStream inputStream = SarifLogger.class.getResourceAsStream(name);){
            String string;
            try (ByteArrayOutputStream result = new ByteArrayOutputStream();){
                if (inputStream == null) {
                    throw new IOException("Cannot find the resource " + name);
                }
                byte[] buffer = new byte[1024];
                int length = 0;
                while (length != -1) {
                    result.write(buffer, 0, length);
                    length = inputStream.read(buffer);
                }
                string = result.toString(StandardCharsets.UTF_8);
            }
            return string;
        }
    }

    private record RuleKey(String sourceName, String moduleId) {
        private String toRuleId() {
            Object result = this.moduleId == null ? this.sourceName : this.sourceName + "#" + this.moduleId;
            return result;
        }
    }
}

