/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.xpath;

import com.puppycrawl.tools.checkstyle.TreeWalkerAuditEvent;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileText;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import com.puppycrawl.tools.checkstyle.utils.TokenUtil;
import com.puppycrawl.tools.checkstyle.utils.XpathUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class XpathQueryGenerator {
    private final DetailAST rootAst;
    private final int lineNumber;
    private final int columnNumber;
    private final int tokenType;
    private final FileText fileText;
    private final int tabWidth;

    public XpathQueryGenerator(TreeWalkerAuditEvent event, int tabWidth) {
        this(event.getRootAst(), event.getLine(), event.getColumn(), event.getTokenType(), event.getFileContents().getText(), tabWidth);
    }

    public XpathQueryGenerator(DetailAST rootAst, int lineNumber, int columnNumber, FileText fileText, int tabWidth) {
        this(rootAst, lineNumber, columnNumber, 0, fileText, tabWidth);
    }

    public XpathQueryGenerator(DetailAST rootAst, int lineNumber, int columnNumber, int tokenType, FileText fileText, int tabWidth) {
        this.rootAst = rootAst;
        this.lineNumber = lineNumber;
        this.columnNumber = columnNumber;
        this.tokenType = tokenType;
        this.fileText = fileText;
        this.tabWidth = tabWidth;
    }

    public List<String> generate() {
        return this.getMatchingAstElements().stream().map(XpathQueryGenerator::generateXpathQuery).toList();
    }

    @Nullable
    private static DetailAST findChildWithTextAttribute(DetailAST root) {
        return TokenUtil.findFirstTokenByPredicate(root, XpathUtil::supportsTextAttribute).orElse(null);
    }

    @Nullable
    private static DetailAST findChildWithTextAttributeRecursively(DetailAST root) {
        DetailAST res = XpathQueryGenerator.findChildWithTextAttribute(root);
        for (DetailAST ast = root.getFirstChild(); ast != null && res == null; ast = ast.getNextSibling()) {
            res = XpathQueryGenerator.findChildWithTextAttributeRecursively(ast);
        }
        return res;
    }

    public static String generateXpathQuery(DetailAST ast) {
        StringBuilder xpathQueryBuilder = new StringBuilder(XpathQueryGenerator.getXpathQuery(null, ast));
        if (!XpathQueryGenerator.isXpathQueryForNodeIsAccurateEnough(ast)) {
            xpathQueryBuilder.append('[');
            DetailAST child = XpathQueryGenerator.findChildWithTextAttributeRecursively(ast);
            if (child == null) {
                xpathQueryBuilder.append(XpathQueryGenerator.findPositionAmongSiblings(ast));
            } else {
                xpathQueryBuilder.append('.').append(XpathQueryGenerator.getXpathQuery(ast, child));
            }
            xpathQueryBuilder.append(']');
        }
        return xpathQueryBuilder.toString();
    }

    private static int findPositionAmongSiblings(DetailAST ast) {
        int pos = 0;
        for (DetailAST cur = ast; cur != null; cur = cur.getPreviousSibling()) {
            if (cur.getType() != ast.getType()) continue;
            ++pos;
        }
        return pos;
    }

    private static boolean isXpathQueryForNodeIsAccurateEnough(DetailAST ast) {
        return !XpathQueryGenerator.hasAtLeastOneSiblingWithSameTokenType(ast) || XpathUtil.supportsTextAttribute(ast) || XpathQueryGenerator.findChildWithTextAttribute(ast) != null;
    }

    private List<DetailAST> getMatchingAstElements() {
        ArrayList<DetailAST> result = new ArrayList<DetailAST>();
        DetailAST curNode = this.rootAst;
        while (curNode != null) {
            if (this.isMatchingByLineAndColumnAndTokenType(curNode)) {
                result.add(curNode);
            }
            DetailAST toVisit = curNode.getFirstChild();
            while (curNode != null && toVisit == null) {
                toVisit = curNode.getNextSibling();
                curNode = curNode.getParent();
            }
            curNode = toVisit;
        }
        return result;
    }

    private static String getXpathQuery(DetailAST root, DetailAST ast) {
        StringBuilder resultBuilder = new StringBuilder(1024);
        for (DetailAST cur = ast; cur != root; cur = cur.getParent()) {
            StringBuilder curNodeQueryBuilder = new StringBuilder(256);
            curNodeQueryBuilder.append('/').append(TokenUtil.getTokenName(cur.getType()));
            if (XpathUtil.supportsTextAttribute(cur)) {
                curNodeQueryBuilder.append("[@text='").append(XpathQueryGenerator.encode(XpathUtil.getTextAttributeValue(cur))).append("']");
            } else {
                DetailAST child = XpathQueryGenerator.findChildWithTextAttribute(cur);
                if (child != null && child != ast) {
                    curNodeQueryBuilder.append("[.").append(XpathQueryGenerator.getXpathQuery(cur, child)).append(']');
                }
            }
            resultBuilder.insert(0, curNodeQueryBuilder);
        }
        return resultBuilder.toString();
    }

    private static boolean hasAtLeastOneSiblingWithSameTokenType(DetailAST ast) {
        boolean result = false;
        for (DetailAST prev = ast.getPreviousSibling(); prev != null; prev = prev.getPreviousSibling()) {
            if (prev.getType() != ast.getType()) continue;
            result = true;
            break;
        }
        for (DetailAST next = ast.getNextSibling(); next != null; next = next.getNextSibling()) {
            if (next.getType() != ast.getType()) continue;
            result = true;
            break;
        }
        return result;
    }

    private int expandedTabColumn(DetailAST ast) {
        return 1 + CommonUtil.lengthExpandedTabs(this.fileText.get(this.lineNumber - 1), ast.getColumnNo(), this.tabWidth);
    }

    private boolean isMatchingByLineAndColumnAndTokenType(DetailAST ast) {
        return ast.getLineNo() == this.lineNumber && this.expandedTabColumn(ast) == this.columnNumber && (this.tokenType == 0 || this.tokenType == ast.getType());
    }

    private static String encode(String value) {
        StringBuilder sb = new StringBuilder(256);
        value.codePoints().forEach(chr -> sb.append(XpathQueryGenerator.encodeCharacter(Character.toChars(chr)[0])));
        return sb.toString();
    }

    private static String encodeCharacter(char chr) {
        return switch (chr) {
            case '<' -> "&lt;";
            case '>' -> "&gt;";
            case '\'' -> "&apos;&apos;";
            case '\"' -> "&quot;";
            case '&' -> "&amp;";
            default -> String.valueOf(chr);
        };
    }
}

