/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle;

import com.puppycrawl.tools.checkstyle.AbstractAutomaticBean;
import com.puppycrawl.tools.checkstyle.AuditEventDefaultFormatter;
import com.puppycrawl.tools.checkstyle.AuditEventFormatter;
import com.puppycrawl.tools.checkstyle.LocalizedMessage;
import com.puppycrawl.tools.checkstyle.api.AuditEvent;
import com.puppycrawl.tools.checkstyle.api.AuditListener;
import com.puppycrawl.tools.checkstyle.api.AutomaticBean;
import com.puppycrawl.tools.checkstyle.api.SeverityLevel;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;

public class DefaultLogger
extends AbstractAutomaticBean
implements AuditListener {
    public static final String ADD_EXCEPTION_MESSAGE = "DefaultLogger.addException";
    public static final String AUDIT_STARTED_MESSAGE = "DefaultLogger.auditStarted";
    public static final String AUDIT_FINISHED_MESSAGE = "DefaultLogger.auditFinished";
    private final PrintWriter infoWriter;
    private final boolean closeInfo;
    private final PrintWriter errorWriter;
    private final boolean closeError;
    private final AuditEventFormatter formatter;

    public DefaultLogger(OutputStream outputStream, AutomaticBean.OutputStreamOptions outputStreamOptions) {
        this(outputStream, AbstractAutomaticBean.OutputStreamOptions.valueOf(outputStreamOptions.name()));
    }

    public DefaultLogger(OutputStream outputStream, AbstractAutomaticBean.OutputStreamOptions outputStreamOptions) {
        this(outputStream, outputStreamOptions, outputStream, AbstractAutomaticBean.OutputStreamOptions.NONE);
    }

    public DefaultLogger(OutputStream infoStream, AbstractAutomaticBean.OutputStreamOptions infoStreamOptions, OutputStream errorStream, AbstractAutomaticBean.OutputStreamOptions errorStreamOptions) {
        this(infoStream, infoStreamOptions, errorStream, errorStreamOptions, new AuditEventDefaultFormatter());
    }

    public DefaultLogger(OutputStream infoStream, AbstractAutomaticBean.OutputStreamOptions infoStreamOptions, OutputStream errorStream, AbstractAutomaticBean.OutputStreamOptions errorStreamOptions, AuditEventFormatter messageFormatter) {
        if (infoStreamOptions == null) {
            throw new IllegalArgumentException(DefaultLogger.getLocalizedMessage(DefaultLogger.class, "DefaultLogger.infoStreamException", new Object[0]));
        }
        boolean bl = this.closeInfo = infoStreamOptions == AbstractAutomaticBean.OutputStreamOptions.CLOSE;
        if (errorStreamOptions == null) {
            throw new IllegalArgumentException(DefaultLogger.getLocalizedMessage(DefaultLogger.class, "DefaultLogger.errorStreamException", new Object[0]));
        }
        this.closeError = errorStreamOptions == AbstractAutomaticBean.OutputStreamOptions.CLOSE;
        OutputStreamWriter infoStreamWriter = new OutputStreamWriter(infoStream, StandardCharsets.UTF_8);
        this.infoWriter = new PrintWriter(infoStreamWriter);
        if (infoStream == errorStream) {
            this.errorWriter = this.infoWriter;
        } else {
            OutputStreamWriter errorStreamWriter = new OutputStreamWriter(errorStream, StandardCharsets.UTF_8);
            this.errorWriter = new PrintWriter(errorStreamWriter);
        }
        this.formatter = messageFormatter;
    }

    @Override
    protected void finishLocalSetup() {
    }

    @Override
    public void addError(AuditEvent event) {
        SeverityLevel severityLevel = event.getSeverityLevel();
        if (severityLevel != SeverityLevel.IGNORE) {
            String errorMessage = this.formatter.format(event);
            this.errorWriter.println(errorMessage);
        }
    }

    @Override
    public void addException(AuditEvent event, Throwable throwable) {
        this.errorWriter.println(DefaultLogger.getLocalizedMessage(DefaultLogger.class, ADD_EXCEPTION_MESSAGE, event.getFileName()));
        throwable.printStackTrace(this.errorWriter);
    }

    @Override
    public void auditStarted(AuditEvent event) {
        this.infoWriter.println(DefaultLogger.getLocalizedMessage(DefaultLogger.class, AUDIT_STARTED_MESSAGE, new Object[0]));
        this.infoWriter.flush();
    }

    @Override
    public void auditFinished(AuditEvent event) {
        this.infoWriter.println(DefaultLogger.getLocalizedMessage(DefaultLogger.class, AUDIT_FINISHED_MESSAGE, new Object[0]));
        this.closeStreams();
    }

    @Override
    public void fileStarted(AuditEvent event) {
    }

    @Override
    public void fileFinished(AuditEvent event) {
        this.infoWriter.flush();
    }

    private void closeStreams() {
        this.infoWriter.flush();
        if (this.closeInfo) {
            this.infoWriter.close();
        }
        this.errorWriter.flush();
        if (this.closeError) {
            this.errorWriter.close();
        }
    }

    private static String getLocalizedMessage(Class<?> caller, String messageKey, Object ... args) {
        LocalizedMessage localizedMessage = new LocalizedMessage("com.puppycrawl.tools.checkstyle.messages", caller, messageKey, args);
        return localizedMessage.getMessage();
    }
}

