/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.javadoc;

import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.DetailNode;
import com.puppycrawl.tools.checkstyle.checks.javadoc.AbstractJavadocCheck;

@StatelessCheck
public class JavadocMissingWhitespaceAfterAsteriskCheck
extends AbstractJavadocCheck {
    public static final String MSG_KEY = "javadoc.missing.whitespace";

    @Override
    public int[] getDefaultJavadocTokens() {
        return new int[]{1, 2};
    }

    @Override
    public int[] getRequiredJavadocTokens() {
        return this.getAcceptableJavadocTokens();
    }

    @Override
    public void visitJavadocToken(DetailNode detailNode) {
        String text;
        int lastAsteriskPosition;
        DetailNode nextNode = JavadocMissingWhitespaceAfterAsteriskCheck.resolveNextNode(detailNode);
        if (nextNode != null && !JavadocMissingWhitespaceAfterAsteriskCheck.isLast(lastAsteriskPosition = JavadocMissingWhitespaceAfterAsteriskCheck.getLastLeadingAsteriskPosition(text = nextNode.getText()), text) && !Character.isWhitespace(text.charAt(lastAsteriskPosition + 1))) {
            this.log(nextNode.getLineNumber(), nextNode.getColumnNumber(), MSG_KEY, new Object[0]);
        }
    }

    private static DetailNode resolveNextNode(DetailNode detailNode) {
        DetailNode baseNode = detailNode.getType() == 1 ? detailNode.getFirstChild() : detailNode.getNextSibling();
        DetailNode nextNode = baseNode;
        if (baseNode != null && baseNode.getFirstChild() != null) {
            nextNode = baseNode.getFirstChild();
        }
        return nextNode;
    }

    private static boolean isLast(int position, String text) {
        return position == text.length() - 1;
    }

    private static int getLastLeadingAsteriskPosition(String text) {
        int index = -1;
        for (int i = 0; i < text.length() && text.charAt(i) == '*'; ++i) {
            ++index;
        }
        return index;
    }
}

