/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.javadoc;

import com.puppycrawl.tools.checkstyle.FileStatefulCheck;
import com.puppycrawl.tools.checkstyle.api.DetailNode;
import com.puppycrawl.tools.checkstyle.checks.javadoc.AbstractJavadocCheck;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import com.puppycrawl.tools.checkstyle.utils.JavadocUtil;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Stream;

@FileStatefulCheck
public class SummaryJavadocCheck
extends AbstractJavadocCheck {
    public static final String MSG_SUMMARY_FIRST_SENTENCE = "summary.first.sentence";
    public static final String MSG_SUMMARY_JAVADOC = "summary.javaDoc";
    public static final String MSG_SUMMARY_JAVADOC_MISSING = "summary.javaDoc.missing";
    public static final String MSG_SUMMARY_MISSING_PERIOD = "summary.javaDoc.missing.period";
    private static final Pattern JAVADOC_MULTILINE_TO_SINGLELINE_PATTERN = Pattern.compile("\n +(\\*)|^ +(\\*)");
    private static final Pattern HTML_ELEMENTS = Pattern.compile("<[^>]*>");
    private static final String DEFAULT_PERIOD = ".";
    private Pattern forbiddenSummaryFragments = CommonUtil.createPattern("^$");
    private String period = ".";
    private boolean shouldValidateUntaggedSummary = true;

    public void setForbiddenSummaryFragments(Pattern pattern) {
        this.forbiddenSummaryFragments = pattern;
    }

    public void setPeriod(String period) {
        this.period = period;
    }

    @Override
    public int[] getDefaultJavadocTokens() {
        return new int[]{1, 81, 84};
    }

    @Override
    public int[] getRequiredJavadocTokens() {
        return this.getAcceptableJavadocTokens();
    }

    @Override
    public void visitJavadocToken(DetailNode ast) {
        if (SummaryJavadocCheck.isSummaryTag(ast) && SummaryJavadocCheck.isDefinedFirst(ast.getParent())) {
            this.shouldValidateUntaggedSummary = false;
            this.validateSummaryTag(ast);
        } else if (SummaryJavadocCheck.isInlineReturnTag(ast)) {
            this.shouldValidateUntaggedSummary = false;
            this.validateInlineReturnTag(ast);
        }
    }

    @Override
    public void leaveJavadocToken(DetailNode ast) {
        if (ast.getType() == 1) {
            if (this.shouldValidateUntaggedSummary && !SummaryJavadocCheck.startsWithInheritDoc(ast)) {
                this.validateUntaggedSummary(ast);
            }
            this.shouldValidateUntaggedSummary = true;
        }
    }

    private void validateUntaggedSummary(DetailNode ast) {
        String summaryDoc = SummaryJavadocCheck.getSummarySentence(ast);
        if (summaryDoc.isEmpty()) {
            this.log(ast.getLineNumber(), MSG_SUMMARY_JAVADOC_MISSING, new Object[0]);
        } else if (!this.period.isEmpty()) {
            if (summaryDoc.contains(this.period)) {
                Optional<String> firstSentence = SummaryJavadocCheck.getFirstSentence(ast, this.period);
                if (firstSentence.isPresent()) {
                    if (this.containsForbiddenFragment(firstSentence.get())) {
                        this.log(ast.getLineNumber(), MSG_SUMMARY_JAVADOC, new Object[0]);
                    }
                } else {
                    this.log(ast.getLineNumber(), MSG_SUMMARY_FIRST_SENTENCE, new Object[0]);
                }
            } else {
                this.log(ast.getLineNumber(), MSG_SUMMARY_FIRST_SENTENCE, new Object[0]);
            }
        }
    }

    private static boolean isDefinedFirst(DetailNode inlineTagNode) {
        boolean isDefinedFirst = true;
        block5: for (DetailNode currentAst = inlineTagNode.getPreviousSibling(); currentAst != null && isDefinedFirst; currentAst = currentAst.getPreviousSibling()) {
            switch (currentAst.getType()) {
                case 4: {
                    isDefinedFirst = currentAst.getText().isBlank();
                    continue block5;
                }
                case 68: {
                    isDefinedFirst = SummaryJavadocCheck.isHtmlTagWithoutText(currentAst);
                    continue block5;
                }
                case 2: 
                case 3: {
                    continue block5;
                }
                default: {
                    isDefinedFirst = false;
                }
            }
        }
        return isDefinedFirst;
    }

    public static boolean isHtmlTagWithoutText(DetailNode node) {
        boolean isEmpty = true;
        DetailNode htmlContentToken = JavadocUtil.findFirstToken(node, 70);
        if (htmlContentToken != null) {
            DetailNode child = htmlContentToken.getFirstChild();
            isEmpty = child.getType() == 68 && SummaryJavadocCheck.isHtmlTagWithoutText(child);
        }
        return isEmpty;
    }

    private static boolean isSummaryTag(DetailNode javadocInlineTag) {
        return javadocInlineTag.getType() == 81;
    }

    private static boolean isInlineReturnTag(DetailNode javadocInlineTag) {
        return javadocInlineTag.getType() == 84;
    }

    private void validateSummaryTag(DetailNode inlineSummaryTag) {
        DetailNode descriptionNode = JavadocUtil.findFirstToken(inlineSummaryTag, 64);
        String inlineSummary = SummaryJavadocCheck.getContentOfInlineCustomTag(descriptionNode);
        String summaryVisible = SummaryJavadocCheck.getVisibleContent(inlineSummary);
        if (summaryVisible.isEmpty()) {
            this.log(inlineSummaryTag.getLineNumber(), MSG_SUMMARY_JAVADOC_MISSING, new Object[0]);
        } else if (!this.period.isEmpty()) {
            boolean isPeriodNotAtEnd;
            boolean bl = isPeriodNotAtEnd = summaryVisible.lastIndexOf(this.period) != summaryVisible.length() - 1;
            if (isPeriodNotAtEnd) {
                this.log(inlineSummaryTag.getLineNumber(), MSG_SUMMARY_MISSING_PERIOD, new Object[0]);
            } else if (this.containsForbiddenFragment(inlineSummary)) {
                this.log(inlineSummaryTag.getLineNumber(), MSG_SUMMARY_JAVADOC, new Object[0]);
            }
        }
    }

    private void validateInlineReturnTag(DetailNode inlineReturnTag) {
        DetailNode descriptionNode = JavadocUtil.findFirstToken(inlineReturnTag, 64);
        String inlineReturn = SummaryJavadocCheck.getContentOfInlineCustomTag(descriptionNode);
        String returnVisible = SummaryJavadocCheck.getVisibleContent(inlineReturn);
        if (returnVisible.isEmpty()) {
            this.log(inlineReturnTag.getLineNumber(), MSG_SUMMARY_JAVADOC_MISSING, new Object[0]);
        } else if (this.containsForbiddenFragment(inlineReturn)) {
            this.log(inlineReturnTag.getLineNumber(), MSG_SUMMARY_JAVADOC, new Object[0]);
        }
    }

    public static String getContentOfInlineCustomTag(DetailNode descriptionNode) {
        StringBuilder customTagContent = new StringBuilder(256);
        DetailNode curNode = descriptionNode;
        while (curNode != null) {
            if (curNode.getFirstChild() == null && curNode.getType() != 2) {
                customTagContent.append(curNode.getText());
            }
            DetailNode toVisit = curNode.getFirstChild();
            while (curNode != descriptionNode && toVisit == null) {
                toVisit = curNode.getNextSibling();
                curNode = curNode.getParent();
            }
            curNode = toVisit;
        }
        return customTagContent.toString();
    }

    private static String getVisibleContent(String summary) {
        String visibleSummary = HTML_ELEMENTS.matcher(summary).replaceAll("");
        return visibleSummary.trim();
    }

    private boolean containsForbiddenFragment(String firstSentence) {
        String javadocText = JAVADOC_MULTILINE_TO_SINGLELINE_PATTERN.matcher(firstSentence).replaceAll(" ");
        return this.forbiddenSummaryFragments.matcher(SummaryJavadocCheck.trimExcessWhitespaces(javadocText)).find();
    }

    private static String trimExcessWhitespaces(String text) {
        StringBuilder result = new StringBuilder(256);
        boolean previousWhitespace = true;
        for (char letter : text.toCharArray()) {
            char print;
            if (Character.isWhitespace(letter)) {
                if (previousWhitespace) continue;
                previousWhitespace = true;
                print = ' ';
            } else {
                previousWhitespace = false;
                print = letter;
            }
            result.append(print);
        }
        return result.toString();
    }

    private static boolean startsWithInheritDoc(DetailNode root) {
        boolean found = false;
        for (DetailNode node = root.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getType() == 6 && node.getFirstChild().getType() == 80) {
                found = true;
            }
            if ((node.getType() == 4 || node.getType() == 68) && !CommonUtil.isBlank(node.getText())) break;
        }
        return found;
    }

    private static String getSummarySentence(DetailNode ast) {
        StringBuilder result = new StringBuilder(256);
        for (DetailNode node = ast.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getType() == 4) {
                result.append(node.getText());
                continue;
            }
            String summary = result.toString();
            if (!CommonUtil.isBlank(summary) || node.getType() != 68) continue;
            DetailNode htmlContentToken = JavadocUtil.findFirstToken(node, 70);
            result.append(SummaryJavadocCheck.getStringInsideHtmlTag(summary, htmlContentToken));
        }
        return result.toString().trim();
    }

    private static String getStringInsideHtmlTag(String result, DetailNode detailNode) {
        StringBuilder contents = new StringBuilder(result);
        if (detailNode != null) {
            for (DetailNode tempNode = detailNode.getFirstChild(); tempNode != null; tempNode = tempNode.getNextSibling()) {
                if (tempNode.getType() != 4) continue;
                contents.append(tempNode.getText());
            }
        }
        return contents.toString();
    }

    private static Optional<String> getFirstSentence(DetailNode ast, String period) {
        ArrayList<String> sentenceParts = new ArrayList<String>();
        Optional<String> result = Optional.empty();
        for (String text : SummaryJavadocCheck.streamTextParts(ast)::iterator) {
            Optional<String> sentenceEnding = SummaryJavadocCheck.findSentenceEnding(text, period);
            if (sentenceEnding.isPresent()) {
                sentenceParts.add(sentenceEnding.get());
                result = Optional.of(String.join((CharSequence)"", sentenceParts));
                break;
            }
            sentenceParts.add(text);
        }
        return result;
    }

    private static Stream<String> streamTextParts(DetailNode node) {
        Stream<String> result;
        if (node.getFirstChild() == null) {
            result = Stream.of(node.getText());
        } else {
            ArrayList<Stream<String>> childStreams = new ArrayList<Stream<String>>();
            for (DetailNode child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                childStreams.add(SummaryJavadocCheck.streamTextParts(child));
            }
            result = childStreams.stream().flatMap(Function.identity());
        }
        return result;
    }

    private static Optional<String> findSentenceEnding(String text, String period) {
        int periodIndex = text.indexOf(period);
        Optional<String> result = Optional.empty();
        while (periodIndex >= 0) {
            int afterPeriodIndex = periodIndex + period.length();
            if (!DEFAULT_PERIOD.equals(period) || afterPeriodIndex >= text.length() || Character.isWhitespace(text.charAt(afterPeriodIndex))) {
                String resultStr = text.substring(0, periodIndex);
                result = Optional.of(resultStr);
                break;
            }
            periodIndex = text.indexOf(period, afterPeriodIndex);
        }
        return result;
    }
}

