/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks;

import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractFileSetCheck;
import com.puppycrawl.tools.checkstyle.api.FileText;
import com.puppycrawl.tools.checkstyle.checks.LineSeparatorOption;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Locale;

@StatelessCheck
public class NewlineAtEndOfFileCheck
extends AbstractFileSetCheck {
    public static final String MSG_KEY_UNABLE_OPEN = "unable.open";
    public static final String MSG_KEY_NO_NEWLINE_EOF = "noNewlineAtEOF";
    public static final String MSG_KEY_WRONG_ENDING = "wrong.line.end";
    private LineSeparatorOption lineSeparator = LineSeparatorOption.LF_CR_CRLF;

    @Override
    protected void processFiltered(File file, FileText fileText) {
        try {
            this.readAndCheckFile(file);
        }
        catch (IOException ignored) {
            this.log(1, MSG_KEY_UNABLE_OPEN, file.getPath());
        }
    }

    public void setLineSeparator(String lineSeparatorParam) {
        this.lineSeparator = Enum.valueOf(LineSeparatorOption.class, lineSeparatorParam.trim().toUpperCase(Locale.ENGLISH));
    }

    private void readAndCheckFile(File file) throws IOException {
        try (RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");){
            if (this.lineSeparator == LineSeparatorOption.LF && NewlineAtEndOfFileCheck.endsWithNewline(randomAccessFile, LineSeparatorOption.CRLF)) {
                this.log(1, MSG_KEY_WRONG_ENDING, new Object[0]);
            } else if (!NewlineAtEndOfFileCheck.endsWithNewline(randomAccessFile, this.lineSeparator)) {
                this.log(1, MSG_KEY_NO_NEWLINE_EOF, new Object[0]);
            }
        }
    }

    private static boolean endsWithNewline(RandomAccessFile file, LineSeparatorOption separator) throws IOException {
        boolean result;
        int len = separator.length();
        if (file.length() == 0L) {
            result = true;
        } else if (file.length() < (long)len) {
            result = false;
        } else {
            file.seek(file.length() - (long)len);
            byte[] lastBytes = new byte[len];
            int readBytes = file.read(lastBytes);
            if (readBytes != len) {
                throw new IOException("Unable to read " + len + " bytes, got " + readBytes);
            }
            result = separator.matches(lastBytes);
        }
        return result;
    }
}

