/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle;

import com.puppycrawl.tools.checkstyle.DetailNodeTreeStringPrinter;
import com.puppycrawl.tools.checkstyle.JavaParser;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.DetailNode;
import com.puppycrawl.tools.checkstyle.utils.JavadocUtil;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import picocli.CommandLine;

public final class JavadocPropertiesGenerator {
    private static final Pattern END_OF_SENTENCE_PATTERN = Pattern.compile("(([^.?!]|[.?!](?!\\s|$))*+[.?!])(\\s|$)");

    private JavadocPropertiesGenerator() {
    }

    public static void main(String ... args) throws CheckstyleException {
        CliOptions cliOptions = new CliOptions();
        CommandLine cmd = new CommandLine((Object)cliOptions);
        try {
            CommandLine.ParseResult parseResult = cmd.parseArgs(args);
            if (parseResult.isUsageHelpRequested()) {
                cmd.usage(System.out);
            } else {
                JavadocPropertiesGenerator.writePropertiesFile(cliOptions);
            }
        }
        catch (CommandLine.ParameterException exc) {
            System.err.println(exc.getMessage());
            exc.getCommandLine().usage(System.err);
        }
    }

    private static void writePropertiesFile(CliOptions options) throws CheckstyleException {
        try (PrintWriter writer = new PrintWriter(options.outputFile, StandardCharsets.UTF_8);){
            DetailAST top = JavaParser.parseFile(options.inputFile, JavaParser.Options.WITH_COMMENTS).getFirstChild();
            DetailAST objBlock = JavadocPropertiesGenerator.getClassBody(top);
            if (objBlock != null) {
                JavadocPropertiesGenerator.iteratePublicStaticIntFields(objBlock, writer::println);
            }
        }
        catch (IOException exc) {
            throw new CheckstyleException("Failed to write javadoc properties of '" + String.valueOf(options.inputFile) + "' to '" + String.valueOf(options.outputFile) + "'", exc);
        }
    }

    private static void iteratePublicStaticIntFields(DetailAST objBlock, Consumer<String> consumer) throws CheckstyleException {
        for (DetailAST member = objBlock.getFirstChild(); member != null; member = member.getNextSibling()) {
            DetailAST modifiers;
            String firstJavadocSentence;
            if (!JavadocPropertiesGenerator.isPublicStaticFinalIntField(member) || (firstJavadocSentence = JavadocPropertiesGenerator.getFirstJavadocSentence(modifiers = member.findFirstToken(5))) == null) continue;
            consumer.accept(JavadocPropertiesGenerator.getName(member) + "=" + firstJavadocSentence.trim());
        }
    }

    private static DetailAST getClassBody(DetailAST top) {
        DetailAST ast;
        for (ast = top; ast != null && ast.getType() != 14; ast = ast.getNextSibling()) {
        }
        DetailAST objBlock = null;
        if (ast != null) {
            objBlock = ast.findFirstToken(6);
        }
        return objBlock;
    }

    private static boolean isPublicStaticFinalIntField(DetailAST ast) {
        boolean result;
        boolean bl = result = ast.getType() == 10;
        if (result) {
            DetailAST type = ast.findFirstToken(13);
            DetailAST arrayDeclarator = type.getFirstChild().getNextSibling();
            boolean bl2 = result = arrayDeclarator == null && type.getFirstChild().getType() == 54;
            if (result) {
                DetailAST modifiers = ast.findFirstToken(5);
                result = modifiers.findFirstToken(62) != null && modifiers.findFirstToken(64) != null && modifiers.findFirstToken(39) != null;
            }
        }
        return result;
    }

    private static String getName(DetailAST ast) {
        return ast.findFirstToken(58).getText();
    }

    private static String getFirstJavadocSentence(DetailAST ast) throws CheckstyleException {
        String firstSentence = null;
        for (DetailAST child = ast.getFirstChild(); child != null && firstSentence == null; child = child.getNextSibling()) {
            if (child.getType() == 159) {
                firstSentence = JavadocPropertiesGenerator.getFirstJavadocSentence(child);
                continue;
            }
            if (child.getType() != 145 || !JavadocUtil.isJavadocComment(child)) continue;
            DetailNode tree = DetailNodeTreeStringPrinter.parseJavadocAsDetailNode(child);
            firstSentence = JavadocPropertiesGenerator.getFirstJavadocSentence(tree);
        }
        return firstSentence;
    }

    private static String getFirstJavadocSentence(DetailNode tree) throws CheckstyleException {
        String firstSentence = null;
        StringBuilder builder = new StringBuilder(128);
        for (DetailNode node = tree.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getType() == 4) {
                Matcher matcher = END_OF_SENTENCE_PATTERN.matcher(node.getText());
                if (matcher.find()) {
                    firstSentence = builder.append(matcher.group(1)).toString();
                    break;
                }
                builder.append(node.getText());
                continue;
            }
            if (node.getType() == 6) {
                JavadocPropertiesGenerator.formatInlineCodeTag(builder, node);
                continue;
            }
            JavadocPropertiesGenerator.formatHtmlElement(builder, node);
        }
        return firstSentence;
    }

    private static void formatInlineCodeTag(StringBuilder builder, DetailNode inlineTag) throws CheckstyleException {
        int tagType = inlineTag.getFirstChild().getType();
        if (tagType != 85 && tagType != 76) {
            throw new CheckstyleException("Unsupported inline tag " + JavadocUtil.getTokenName(tagType));
        }
        boolean wrapWithCodeTag = tagType == 76;
        block4: for (DetailNode node = inlineTag.getFirstChild().getFirstChild(); node != null; node = node.getNextSibling()) {
            switch (node.getType()) {
                case 4: {
                    if (wrapWithCodeTag) {
                        builder.append("<code>").append(node.getText().trim()).append("</code>");
                        continue block4;
                    }
                    builder.append(node.getText().trim());
                    continue block4;
                }
                case 7: 
                case 8: 
                case 26: {
                    continue block4;
                }
                default: {
                    throw new CheckstyleException("Unsupported child in the inline tag " + JavadocUtil.getTokenName(node.getType()));
                }
            }
        }
    }

    private static void formatHtmlElement(StringBuilder builder, DetailNode node) {
        switch (node.getType()) {
            case 4: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: {
                builder.append(node.getText());
                break;
            }
            default: {
                for (DetailNode child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                    JavadocPropertiesGenerator.formatHtmlElement(builder, child);
                }
            }
        }
    }

    @CommandLine.Command(name="java com.puppycrawl.tools.checkstyle.JavadocPropertiesGenerator", mixinStandardHelpOptions=true)
    private static final class CliOptions {
        @CommandLine.Option(names={"--destfile"}, required=true, description={"The output file."})
        private File outputFile;
        @CommandLine.Parameters(index="0", description={"The input file."})
        private File inputFile;

        private CliOptions() {
        }
    }
}

