/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.site;

import com.puppycrawl.tools.checkstyle.api.DetailNode;
import com.puppycrawl.tools.checkstyle.meta.JavadocMetadataScraper;
import com.puppycrawl.tools.checkstyle.site.ModuleJavadocParsingUtil;
import com.puppycrawl.tools.checkstyle.site.SiteUtil;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.maven.doxia.macro.AbstractMacro;
import org.apache.maven.doxia.macro.Macro;
import org.apache.maven.doxia.macro.MacroExecutionException;
import org.apache.maven.doxia.macro.MacroRequest;
import org.apache.maven.doxia.sink.Sink;
import org.codehaus.plexus.component.annotations.Component;

@Component(role=Macro.class, hint="notes")
public class NotesMacro
extends AbstractMacro {
    public static final Pattern NOTES_LINE_WITH_NEWLINE = Pattern.compile("\r?\n\\s?Notes:");

    public void execute(Sink sink, MacroRequest request) throws MacroExecutionException {
        Path modulePath = Paths.get((String)request.getParameter("modulePath"), new String[0]);
        String moduleName = CommonUtil.getFileNameWithoutExtension(modulePath.toString());
        Set<String> propertyNames = ModuleJavadocParsingUtil.getPropertyNames(moduleName);
        DetailNode moduleJavadoc = SiteUtil.getModuleJavadoc(moduleName, modulePath);
        if (moduleJavadoc == null) {
            throw new MacroExecutionException("Javadoc of module " + moduleName + " is not found.");
        }
        int notesStartIndex = ModuleJavadocParsingUtil.getNotesSectionStartIndex(moduleJavadoc);
        int notesEndIndex = NotesMacro.getNotesEndIndex(moduleJavadoc, propertyNames);
        String unprocessedModuleNotes = JavadocMetadataScraper.constructSubTreeText(moduleJavadoc, notesStartIndex, notesEndIndex);
        String moduleNotes = NOTES_LINE_WITH_NEWLINE.matcher(unprocessedModuleNotes).replaceAll("");
        ModuleJavadocParsingUtil.writeOutJavadocPortion(moduleNotes, sink);
    }

    private static int getNotesEndIndex(DetailNode moduleJavadoc, Set<String> propertyNamesSet) {
        int notesEndIndex = -1;
        notesEndIndex = propertyNamesSet.isEmpty() ? (notesEndIndex += ModuleJavadocParsingUtil.getParentSectionStartIndex(moduleJavadoc)) : (notesEndIndex += ModuleJavadocParsingUtil.getPropertySectionStartIndex(moduleJavadoc, propertyNamesSet));
        return notesEndIndex;
    }
}

