/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle;

import com.puppycrawl.tools.checkstyle.ThreadModeSettings;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.Configuration;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class DefaultConfiguration
implements Configuration {
    private static final long serialVersionUID = 1157875385356127169L;
    private static final Configuration[] EMPTY_CONFIGURATION_ARRAY = new Configuration[0];
    private final String name;
    private final List<Configuration> children = new ArrayList<Configuration>();
    private final Map<String, String> propertyMap = new HashMap<String, String>();
    private final Map<String, String> messages = new HashMap<String, String>();
    private final ThreadModeSettings threadModeSettings;

    public DefaultConfiguration(String name) {
        this(name, ThreadModeSettings.SINGLE_THREAD_MODE_INSTANCE);
    }

    public DefaultConfiguration(String name, ThreadModeSettings threadModeSettings) {
        this.name = name;
        this.threadModeSettings = threadModeSettings;
    }

    @Override
    public String[] getAttributeNames() {
        return this.getPropertyNames();
    }

    @Override
    public String getAttribute(String attributeName) throws CheckstyleException {
        return this.getProperty(attributeName);
    }

    @Override
    public String[] getPropertyNames() {
        Set<String> keySet = this.propertyMap.keySet();
        return keySet.toArray(CommonUtil.EMPTY_STRING_ARRAY);
    }

    @Override
    public String getProperty(String propertyName) throws CheckstyleException {
        if (!this.propertyMap.containsKey(propertyName)) {
            throw new CheckstyleException("missing key '" + propertyName + "' in " + this.name);
        }
        return this.propertyMap.get(propertyName);
    }

    @Override
    public Configuration[] getChildren() {
        return this.children.toArray(EMPTY_CONFIGURATION_ARRAY);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void addChild(Configuration configuration) {
        this.children.add(configuration);
    }

    public void removeChild(Configuration configuration) {
        this.children.remove(configuration);
    }

    @Deprecated(since="8.45")
    public void addAttribute(String attributeName, String value) {
        this.addProperty(attributeName, value);
    }

    public void addProperty(String propertyName, String value) {
        String current = this.propertyMap.get(propertyName);
        Object newValue = current == null ? value : current + "," + value;
        this.propertyMap.put(propertyName, (String)newValue);
    }

    public void addMessage(String key, String value) {
        this.messages.put(key, value);
    }

    @Override
    public Map<String, String> getMessages() {
        return new HashMap<String, String>(this.messages);
    }

    public ThreadModeSettings getThreadModeSettings() {
        return this.threadModeSettings;
    }
}

