/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.Optional;

@StatelessCheck
public class UnnecessaryNullCheckWithInstanceOfCheck
extends AbstractCheck {
    public static final String MSG_UNNECESSARY_NULLCHECK = "unnecessary.nullcheck.with.instanceof";

    @Override
    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{121};
    }

    @Override
    public void visitToken(DetailAST instanceofNode) {
        UnnecessaryNullCheckWithInstanceOfCheck.findUnnecessaryNullCheck(instanceofNode).ifPresent(violationNode -> this.log((DetailAST)violationNode, MSG_UNNECESSARY_NULLCHECK, new Object[0]));
    }

    private static Optional<DetailAST> findUnnecessaryNullCheck(DetailAST instanceOfNode) {
        DetailAST currentParent = instanceOfNode;
        while (currentParent.getParent().getType() == 111) {
            currentParent = currentParent.getParent();
        }
        return UnnecessaryNullCheckWithInstanceOfCheck.findRedundantNullCheck(currentParent, instanceOfNode).map(DetailAST::getFirstChild);
    }

    private static Optional<DetailAST> findRedundantNullCheck(DetailAST logicalAndNode, DetailAST instanceOfNode) {
        DetailAST nullCheckNode = null;
        DetailAST instanceOfIdent = instanceOfNode.findFirstToken(58);
        if (instanceOfIdent != null && !UnnecessaryNullCheckWithInstanceOfCheck.containsVariableDereference(logicalAndNode, instanceOfIdent.getText())) {
            for (DetailAST currentChild = logicalAndNode.getFirstChild(); currentChild != null; currentChild = currentChild.getNextSibling()) {
                if (UnnecessaryNullCheckWithInstanceOfCheck.isNotEqual(currentChild) && UnnecessaryNullCheckWithInstanceOfCheck.isNullCheckRedundant(instanceOfIdent, currentChild)) {
                    nullCheckNode = currentChild;
                    continue;
                }
                if (nullCheckNode != null || currentChild.getType() != 111) continue;
                nullCheckNode = UnnecessaryNullCheckWithInstanceOfCheck.findRedundantNullCheck(currentChild, instanceOfNode).orElse(null);
            }
        }
        return Optional.ofNullable(nullCheckNode);
    }

    private static boolean containsVariableDereference(DetailAST node, String variableName) {
        boolean found = false;
        if (node.getType() == 59 || node.getType() == 27 || node.getType() == 111) {
            for (DetailAST firstChild = node.getFirstChild(); firstChild != null; firstChild = firstChild.getNextSibling()) {
                if ((!variableName.equals(firstChild.getText()) || firstChild.getNextSibling().getType() == 34) && !UnnecessaryNullCheckWithInstanceOfCheck.containsVariableDereference(firstChild, variableName)) continue;
                found = true;
                break;
            }
        }
        return found;
    }

    private static boolean isNotEqual(DetailAST node) {
        return node.getType() == 115;
    }

    private static boolean isNullLiteral(DetailAST node) {
        return node.getType() == 135;
    }

    private static boolean isNullCheckRedundant(DetailAST instanceOfIdent, DetailAST nullCheckNode) {
        DetailAST nullCheckIdent = nullCheckNode.findFirstToken(58);
        return nullCheckIdent != null && (UnnecessaryNullCheckWithInstanceOfCheck.isNullLiteral(nullCheckNode.getFirstChild().getNextSibling()) || UnnecessaryNullCheckWithInstanceOfCheck.isNullLiteral(nullCheckNode.getFirstChild())) && instanceOfIdent.getText().equals(nullCheckIdent.getText());
    }
}

