/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.TokenUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@StatelessCheck
public class MissingNullCaseInSwitchCheck
extends AbstractCheck {
    public static final String MSG_KEY = "missing.switch.nullcase";

    @Override
    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{89};
    }

    @Override
    public void visitToken(DetailAST ast) {
        List<DetailAST> caseLabels = MissingNullCaseInSwitchCheck.getAllCaseLabels(ast);
        boolean hasNullCaseLabel = caseLabels.stream().anyMatch(MissingNullCaseInSwitchCheck::hasLiteralNull);
        if (!hasNullCaseLabel) {
            boolean hasPatternCaseLabel = caseLabels.stream().anyMatch(MissingNullCaseInSwitchCheck::hasPatternCaseLabel);
            boolean hasStringCaseLabel = caseLabels.stream().anyMatch(MissingNullCaseInSwitchCheck::hasStringCaseLabel);
            if (hasPatternCaseLabel || hasStringCaseLabel) {
                this.log(ast, MSG_KEY, new Object[0]);
            }
        }
    }

    private static List<DetailAST> getAllCaseLabels(DetailAST switchAST) {
        ArrayList caseLabels = new ArrayList();
        for (DetailAST ast = switchAST.getFirstChild(); ast != null; ast = ast.getNextSibling()) {
            TokenUtil.forEachChild(ast, 93, caseLabels::add);
        }
        return Collections.unmodifiableList(caseLabels);
    }

    private static boolean hasLiteralNull(DetailAST caseAST) {
        return Optional.ofNullable(caseAST.findFirstToken(28)).map(exp -> exp.findFirstToken(135)).isPresent();
    }

    private static boolean hasPatternCaseLabel(DetailAST caseAST) {
        return caseAST.findFirstToken(215) != null || caseAST.findFirstToken(198) != null || caseAST.findFirstToken(213) != null;
    }

    private static boolean hasStringCaseLabel(DetailAST caseAST) {
        DetailAST curNode = caseAST;
        boolean hasStringCaseLabel = false;
        boolean exitCaseLabelExpression = false;
        while (!exitCaseLabelExpression) {
            DetailAST toVisit = curNode.getFirstChild();
            if (curNode.getType() == 139) {
                hasStringCaseLabel = true;
                break;
            }
            while (toVisit == null) {
                toVisit = curNode.getNextSibling();
                curNode = curNode.getParent();
            }
            curNode = toVisit;
            exitCaseLabelExpression = TokenUtil.isOfType(curNode, 82, 181);
        }
        return hasStringCaseLabel;
    }
}

