/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks;

import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractFileSetCheck;
import com.puppycrawl.tools.checkstyle.api.FileText;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@StatelessCheck
public class UniquePropertiesCheck
extends AbstractFileSetCheck {
    public static final String MSG_KEY = "properties.duplicate.property";
    public static final String MSG_IO_EXCEPTION_KEY = "unable.open.cause";
    private static final Pattern SPACE_PATTERN = Pattern.compile(" ");

    public UniquePropertiesCheck() {
        this.setFileExtensions("properties");
    }

    @Override
    protected void processFiltered(File file, FileText fileText) {
        UniqueProperties properties = new UniqueProperties();
        try (InputStream inputStream = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            properties.load(inputStream);
        }
        catch (IOException exc) {
            this.log(1, MSG_IO_EXCEPTION_KEY, file.getPath(), exc.getLocalizedMessage());
        }
        for (Map.Entry<String, Integer> duplication : properties.getDuplicatedKeys().entrySet()) {
            String keyName = duplication.getKey();
            int lineNumber = UniquePropertiesCheck.getLineNumber(fileText, keyName);
            this.log(lineNumber, MSG_KEY, keyName, duplication.getValue() + 1);
        }
    }

    private static int getLineNumber(FileText fileText, String keyName) {
        Pattern keyPattern = UniquePropertiesCheck.getKeyPattern(keyName);
        int lineNumber = 1;
        Matcher matcher = keyPattern.matcher("");
        for (int index = 0; index < fileText.size(); ++index) {
            String line = fileText.get(index);
            matcher.reset(line);
            if (matcher.matches()) break;
            ++lineNumber;
        }
        if (lineNumber > fileText.size() - 1) {
            lineNumber = 1;
        }
        return lineNumber;
    }

    private static Pattern getKeyPattern(String keyName) {
        String keyPatternString = "^" + SPACE_PATTERN.matcher(keyName).replaceAll(Matcher.quoteReplacement("\\\\ ")) + "[\\s:=].*$";
        return Pattern.compile(keyPatternString);
    }

    private static final class UniqueProperties
    extends Properties {
        private static final long serialVersionUID = 1L;
        private final Map<String, Integer> duplicatedKeys = new HashMap<String, Integer>();

        private UniqueProperties() {
        }

        @Override
        public synchronized Object put(Object key, Object value) {
            Object oldValue = super.put(key, value);
            if (oldValue != null && key instanceof String) {
                String keyString = (String)key;
                this.duplicatedKeys.put(keyString, this.duplicatedKeys.getOrDefault(keyString, 0) + 1);
            }
            return oldValue;
        }

        public Map<String, Integer> getDuplicatedKeys() {
            return new HashMap<String, Integer>(this.duplicatedKeys);
        }
    }
}

