/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.imports;

import com.puppycrawl.tools.checkstyle.FileStatefulCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.checks.imports.ImportOrderOption;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import com.puppycrawl.tools.checkstyle.utils.UnmodifiableCollectionUtil;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@FileStatefulCheck
public class ImportOrderCheck
extends AbstractCheck {
    public static final String MSG_SEPARATION = "import.separation";
    public static final String MSG_ORDERING = "import.ordering";
    public static final String MSG_SEPARATED_IN_GROUP = "import.groups.separated.internally";
    private static final String WILDCARD_GROUP_NAME = "*";
    private static final String FORWARD_SLASH = "/";
    private static final Pattern[] EMPTY_PATTERN_ARRAY = new Pattern[0];
    private String[] groups = CommonUtil.EMPTY_STRING_ARRAY;
    private String[] staticGroups = CommonUtil.EMPTY_STRING_ARRAY;
    private boolean separated;
    private boolean separatedStaticGroups;
    private boolean ordered = true;
    private boolean caseSensitive = true;
    private int lastGroup;
    private int lastImportLine;
    private String lastImport;
    private boolean lastImportStatic;
    private boolean beforeFirstImport;
    private boolean staticImportsApart;
    private boolean sortStaticImportsAlphabetically;
    private boolean useContainerOrderingForStatic;
    private ImportOrderOption option = ImportOrderOption.UNDER;
    private Pattern[] groupsReg = EMPTY_PATTERN_ARRAY;
    private Pattern[] staticGroupsReg = EMPTY_PATTERN_ARRAY;

    public void setOption(String optionStr) {
        this.option = ImportOrderOption.valueOf(optionStr.trim().toUpperCase(Locale.ENGLISH));
    }

    public void setGroups(String ... packageGroups) {
        this.groups = UnmodifiableCollectionUtil.copyOfArray(packageGroups, packageGroups.length);
        this.groupsReg = ImportOrderCheck.compilePatterns(packageGroups);
    }

    public void setStaticGroups(String ... packageGroups) {
        this.staticGroups = UnmodifiableCollectionUtil.copyOfArray(packageGroups, packageGroups.length);
        this.staticGroupsReg = ImportOrderCheck.compilePatterns(packageGroups);
    }

    public void setOrdered(boolean ordered) {
        this.ordered = ordered;
    }

    public void setSeparated(boolean separated) {
        this.separated = separated;
    }

    public void setSeparatedStaticGroups(boolean separatedStaticGroups) {
        this.separatedStaticGroups = separatedStaticGroups;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public void setSortStaticImportsAlphabetically(boolean sortAlphabetically) {
        this.sortStaticImportsAlphabetically = sortAlphabetically;
    }

    public void setUseContainerOrderingForStatic(boolean useContainerOrdering) {
        this.useContainerOrderingForStatic = useContainerOrdering;
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{30, 152};
    }

    @Override
    public void beginTree(DetailAST rootAST) {
        this.lastGroup = Integer.MIN_VALUE;
        this.lastImportLine = Integer.MIN_VALUE;
        this.lastImportStatic = false;
        this.beforeFirstImport = true;
        this.staticImportsApart = this.option == ImportOrderOption.TOP || this.option == ImportOrderOption.BOTTOM;
    }

    @Override
    public void visitToken(DetailAST ast) {
        boolean isStatic;
        FullIdent ident;
        if (ast.getType() == 30) {
            ident = FullIdent.createFullIdentBelow(ast);
            isStatic = false;
        } else {
            ident = FullIdent.createFullIdent(ast.getFirstChild().getNextSibling());
            isStatic = true;
        }
        if (this.option == ImportOrderOption.TOP || this.option == ImportOrderOption.ABOVE) {
            boolean isStaticAndNotLastImport = isStatic && !this.lastImportStatic;
            this.doVisitToken(ident, isStatic, isStaticAndNotLastImport, ast);
        } else if (this.option == ImportOrderOption.BOTTOM || this.option == ImportOrderOption.UNDER) {
            boolean isLastImportAndNonStatic = this.lastImportStatic && !isStatic;
            this.doVisitToken(ident, isStatic, isLastImportAndNonStatic, ast);
        } else if (this.option == ImportOrderOption.INFLOW) {
            this.doVisitToken(ident, isStatic, true, ast);
        } else {
            throw new IllegalStateException("Unexpected option for static imports: " + this.option);
        }
        this.lastImportLine = ast.findFirstToken(45).getLineNo();
        this.lastImportStatic = isStatic;
        this.beforeFirstImport = false;
    }

    private void doVisitToken(FullIdent ident, boolean isStatic, boolean previous, DetailAST ast) {
        String name;
        int groupIdx = this.getGroupNumber(isStatic && this.staticImportsApart, name = ident.getText());
        if (groupIdx > this.lastGroup) {
            if (!this.beforeFirstImport && ast.getLineNo() - this.lastImportLine < 2 && this.needSeparator(isStatic)) {
                this.log(ast, MSG_SEPARATION, name);
            }
        } else if (groupIdx == this.lastGroup) {
            this.doVisitTokenInSameGroup(isStatic, previous, name, ast);
        } else {
            this.log(ast, MSG_ORDERING, name);
        }
        if (this.isSeparatorInGroup(groupIdx, isStatic, ast.getLineNo())) {
            this.log(ast, MSG_SEPARATED_IN_GROUP, name);
        }
        this.lastGroup = groupIdx;
        this.lastImport = name;
    }

    private boolean needSeparator(boolean isStatic) {
        boolean typeImportSeparator;
        boolean bl = typeImportSeparator = !isStatic && this.separated;
        boolean staticImportSeparator = this.staticImportsApart ? isStatic && this.separatedStaticGroups : this.separated;
        boolean separatorBetween = isStatic != this.lastImportStatic && (this.separated || this.separatedStaticGroups);
        return typeImportSeparator || staticImportSeparator || separatorBetween;
    }

    private boolean isSeparatorInGroup(int groupIdx, boolean isStatic, int line) {
        boolean inSameGroup = groupIdx == this.lastGroup;
        return (inSameGroup || !this.needSeparator(isStatic)) && this.isSeparatorBeforeImport(line);
    }

    private boolean isSeparatorBeforeImport(int line) {
        return line - this.lastImportLine > 1;
    }

    private void doVisitTokenInSameGroup(boolean isStatic, boolean previous, String name, DetailAST ast) {
        if (this.ordered) {
            if (this.option == ImportOrderOption.INFLOW) {
                if (this.isWrongOrder(name, isStatic)) {
                    this.log(ast, MSG_ORDERING, name);
                }
            } else {
                boolean shouldFireError;
                boolean bl = shouldFireError = previous || this.lastImportStatic == isStatic && this.isWrongOrder(name, isStatic);
                if (shouldFireError) {
                    this.log(ast, MSG_ORDERING, name);
                }
            }
        }
    }

    private boolean isWrongOrder(String name, boolean isStatic) {
        boolean result = isStatic ? (this.useContainerOrderingForStatic ? ImportOrderCheck.compareContainerOrder(this.lastImport, name, this.caseSensitive) > 0 : (this.staticImportsApart ? this.sortStaticImportsAlphabetically && ImportOrderCheck.compare(this.lastImport, name, this.caseSensitive) > 0 : ImportOrderCheck.compare(this.lastImport, name, this.caseSensitive) > 0)) : ImportOrderCheck.compare(this.lastImport, name, this.caseSensitive) > 0;
        return result;
    }

    private static int compareContainerOrder(String importName1, String importName2, boolean caseSensitive) {
        String container1 = ImportOrderCheck.getImportContainer(importName1);
        String container2 = ImportOrderCheck.getImportContainer(importName2);
        int compareContainersOrderResult = caseSensitive ? container1.compareTo(container2) : container1.compareToIgnoreCase(container2);
        int result = compareContainersOrderResult == 0 ? ImportOrderCheck.compare(importName1, importName2, caseSensitive) : compareContainersOrderResult;
        return result;
    }

    private static String getImportContainer(String qualifiedImportName) {
        int lastDotIndex = qualifiedImportName.lastIndexOf(46);
        return qualifiedImportName.substring(0, lastDotIndex);
    }

    private int getGroupNumber(boolean isStatic, String name) {
        Pattern[] patterns = isStatic ? this.staticGroupsReg : this.groupsReg;
        int number = ImportOrderCheck.getGroupNumber(patterns, name);
        if (isStatic && this.option == ImportOrderOption.BOTTOM) {
            number += this.groups.length + 1;
        } else if (!isStatic && this.option == ImportOrderOption.TOP) {
            number += this.staticGroups.length + 1;
        }
        return number;
    }

    private static int getGroupNumber(Pattern[] patterns, String name) {
        int bestIndex = patterns.length;
        int bestEnd = -1;
        int bestPos = Integer.MAX_VALUE;
        for (int i = 0; i < patterns.length; ++i) {
            Matcher matcher = patterns[i].matcher(name);
            if (!matcher.find()) continue;
            if (matcher.start() < bestPos) {
                bestIndex = i;
                bestEnd = matcher.end();
                bestPos = matcher.start();
                continue;
            }
            if (matcher.start() != bestPos || matcher.end() <= bestEnd) continue;
            bestIndex = i;
            bestEnd = matcher.end();
        }
        return bestIndex;
    }

    private static int compare(String string1, String string2, boolean caseSensitive) {
        int result = caseSensitive ? string1.compareTo(string2) : string1.compareToIgnoreCase(string2);
        return result;
    }

    private static Pattern[] compilePatterns(String ... packageGroups) {
        Pattern[] patterns = new Pattern[packageGroups.length];
        for (int i = 0; i < packageGroups.length; ++i) {
            Pattern grp;
            String pkg = packageGroups[i];
            if (WILDCARD_GROUP_NAME.equals(pkg)) {
                grp = Pattern.compile("");
            } else if (pkg.startsWith(FORWARD_SLASH)) {
                if (!pkg.endsWith(FORWARD_SLASH)) {
                    throw new IllegalArgumentException("Invalid group: " + pkg);
                }
                pkg = pkg.substring(1, pkg.length() - 1);
                grp = Pattern.compile(pkg);
            } else {
                StringBuilder pkgBuilder = new StringBuilder(pkg);
                if (!pkg.endsWith(".")) {
                    pkgBuilder.append('.');
                }
                grp = Pattern.compile("^" + Pattern.quote(pkgBuilder.toString()));
            }
            patterns[i] = grp;
        }
        return patterns;
    }
}

