/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.grammar;

import java.util.ArrayDeque;
import java.util.Deque;
import org.antlr.v4.runtime.Lexer;

public final class CompositeLexerContextCache {
    private final Deque<StringTemplateContext> stringTemplateContextStack = new ArrayDeque<StringTemplateContext>();
    private final Lexer lexer;

    public CompositeLexerContextCache(Lexer lexer) {
        this.lexer = lexer;
    }

    public void enterTemplateContext(int mode) {
        StringTemplateContext newContext = new StringTemplateContext(mode, 0);
        this.stringTemplateContextStack.push(newContext);
        this.lexer.pushMode(mode);
    }

    public void exitTemplateContext() {
        this.stringTemplateContextStack.pop();
        this.lexer.popMode();
    }

    public void updateLeftCurlyBraceContext() {
        if (this.isInStringTemplateContext()) {
            StringTemplateContext currentContext = this.stringTemplateContextStack.pop();
            StringTemplateContext newContext = new StringTemplateContext(currentContext.getMode(), currentContext.getCurlyBraceDepth() + 1);
            this.stringTemplateContextStack.push(newContext);
        }
    }

    public void updateRightCurlyBraceContext() {
        if (this.isInStringTemplateContext()) {
            StringTemplateContext currentContext = this.stringTemplateContextStack.pop();
            if (currentContext.getCurlyBraceDepth() == 0) {
                this.stringTemplateContextStack.push(currentContext);
                this.lexer.setType(223);
                this.lexer.pushMode(currentContext.getMode());
            } else {
                StringTemplateContext newContext = new StringTemplateContext(currentContext.getMode(), currentContext.getCurlyBraceDepth() - 1);
                this.stringTemplateContextStack.push(newContext);
            }
        }
    }

    private boolean isInStringTemplateContext() {
        return !this.stringTemplateContextStack.isEmpty();
    }

    private static final class StringTemplateContext {
        private final int mode;
        private final int curlyBraceDepth;

        private StringTemplateContext(int mode, int curlyBraceDepth) {
            this.mode = mode;
            this.curlyBraceDepth = curlyBraceDepth;
        }

        public int getMode() {
            return this.mode;
        }

        public int getCurlyBraceDepth() {
            return this.curlyBraceDepth;
        }
    }
}

