/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.whitespace;

import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.whitespace.WrapOption;
import com.puppycrawl.tools.checkstyle.utils.CodePointUtil;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import java.util.Arrays;
import java.util.Locale;

@StatelessCheck
public class SeparatorWrapCheck
extends AbstractCheck {
    public static final String MSG_LINE_PREVIOUS = "line.previous";
    public static final String MSG_LINE_NEW = "line.new";
    private WrapOption option = WrapOption.EOL;

    public void setOption(String optionStr) {
        this.option = WrapOption.valueOf(optionStr.trim().toUpperCase(Locale.ENGLISH));
    }

    @Override
    public int[] getDefaultTokens() {
        return new int[]{59, 74};
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{59, 74, 45, 171, 170, 76, 77, 17, 48, 180};
    }

    @Override
    public int[] getRequiredTokens() {
        return CommonUtil.EMPTY_INT_ARRAY;
    }

    @Override
    public void visitToken(DetailAST ast) {
        String text = ast.getText();
        int colNo = ast.getColumnNo();
        int lineNo = ast.getLineNo();
        int[] currentLine = this.getLineCodePoints(lineNo - 1);
        boolean isLineEmptyAfterToken = CodePointUtil.isBlank(Arrays.copyOfRange(currentLine, colNo + text.length(), currentLine.length));
        boolean isLineEmptyBeforeToken = CodePointUtil.isBlank(Arrays.copyOfRange(currentLine, 0, colNo));
        if (this.option == WrapOption.NL && isLineEmptyAfterToken) {
            this.log(ast, MSG_LINE_NEW, text);
        } else if (this.option == WrapOption.EOL && isLineEmptyBeforeToken) {
            this.log(ast, MSG_LINE_PREVIOUS, text);
        }
    }
}

