/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.naming;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.naming.AbstractAccessControlNameCheck;
import com.puppycrawl.tools.checkstyle.utils.AnnotationUtil;

public class MethodNameCheck
extends AbstractAccessControlNameCheck {
    public static final String MSG_KEY = "method.name.equals.class.name";
    private boolean allowClassName;

    public MethodNameCheck() {
        super("^[a-z][a-zA-Z0-9]*$");
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{9};
    }

    @Override
    public void visitToken(DetailAST ast) {
        if (!AnnotationUtil.hasOverrideAnnotation(ast)) {
            super.visitToken(ast);
        }
        if (!this.allowClassName) {
            DetailAST method = ast.findFirstToken(58);
            DetailAST classDefOrNew = ast.getParent().getParent();
            DetailAST classIdent = classDefOrNew.findFirstToken(58);
            if (classIdent != null && method.getText().equals(classIdent.getText())) {
                this.log(method, MSG_KEY, method.getText());
            }
        }
    }

    public void setAllowClassName(boolean allowClassName) {
        this.allowClassName = allowClassName;
    }
}

