/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.modifier;

import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.ScopeUtil;

@StatelessCheck
public class InterfaceMemberImpliedModifierCheck
extends AbstractCheck {
    public static final String MSG_KEY = "interface.implied.modifier";
    private static final String PUBLIC_ACCESS_MODIFIER = "public";
    private static final String ABSTRACT_KEYWORD = "abstract";
    private static final String STATIC_KEYWORD = "static";
    private static final String FINAL_KEYWORD = "final";
    private boolean violateImpliedPublicField = true;
    private boolean violateImpliedStaticField = true;
    private boolean violateImpliedFinalField = true;
    private boolean violateImpliedPublicMethod = true;
    private boolean violateImpliedAbstractMethod = true;
    private boolean violateImpliedPublicNested = true;
    private boolean violateImpliedStaticNested = true;

    public void setViolateImpliedPublicField(boolean violateImpliedPublicField) {
        this.violateImpliedPublicField = violateImpliedPublicField;
    }

    public void setViolateImpliedStaticField(boolean violateImpliedStaticField) {
        this.violateImpliedStaticField = violateImpliedStaticField;
    }

    public void setViolateImpliedFinalField(boolean violateImpliedFinalField) {
        this.violateImpliedFinalField = violateImpliedFinalField;
    }

    public void setViolateImpliedPublicMethod(boolean violateImpliedPublicMethod) {
        this.violateImpliedPublicMethod = violateImpliedPublicMethod;
    }

    public void setViolateImpliedAbstractMethod(boolean violateImpliedAbstractMethod) {
        this.violateImpliedAbstractMethod = violateImpliedAbstractMethod;
    }

    public void setViolateImpliedPublicNested(boolean violateImpliedPublicNested) {
        this.violateImpliedPublicNested = violateImpliedPublicNested;
    }

    public void setViolateImpliedStaticNested(boolean violateImpliedStaticNested) {
        this.violateImpliedStaticNested = violateImpliedStaticNested;
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{9, 10, 15, 14, 154};
    }

    @Override
    public void visitToken(DetailAST ast) {
        if (ScopeUtil.isInInterfaceBlock(ast) && !ScopeUtil.isInCodeBlock(ast)) {
            switch (ast.getType()) {
                case 9: {
                    this.processMethod(ast);
                    break;
                }
                case 10: {
                    this.processField(ast);
                    break;
                }
                case 14: 
                case 15: 
                case 154: {
                    this.processNestedType(ast);
                    break;
                }
                default: {
                    throw new IllegalStateException(ast.toString());
                }
            }
        }
    }

    private void processMethod(DetailAST ast) {
        DetailAST modifiers = ast.findFirstToken(5);
        if (this.violateImpliedPublicMethod && modifiers.findFirstToken(61) == null && modifiers.findFirstToken(62) == null) {
            this.log(ast, MSG_KEY, PUBLIC_ACCESS_MODIFIER);
        }
        if (this.violateImpliedAbstractMethod && modifiers.findFirstToken(61) == null && modifiers.findFirstToken(64) == null && modifiers.findFirstToken(94) == null && modifiers.findFirstToken(40) == null) {
            this.log(ast, MSG_KEY, ABSTRACT_KEYWORD);
        }
    }

    private void processField(DetailAST ast) {
        DetailAST modifiers = ast.findFirstToken(5);
        if (this.violateImpliedPublicField && modifiers.findFirstToken(62) == null) {
            this.log(ast, MSG_KEY, PUBLIC_ACCESS_MODIFIER);
        }
        if (this.violateImpliedStaticField && modifiers.findFirstToken(64) == null) {
            this.log(ast, MSG_KEY, STATIC_KEYWORD);
        }
        if (this.violateImpliedFinalField && modifiers.findFirstToken(39) == null) {
            this.log(ast, MSG_KEY, FINAL_KEYWORD);
        }
    }

    private void processNestedType(DetailAST ast) {
        DetailAST modifiers = ast.findFirstToken(5);
        if (this.violateImpliedPublicNested && modifiers.findFirstToken(62) == null) {
            this.log(ast, MSG_KEY, PUBLIC_ACCESS_MODIFIER);
        }
        if (this.violateImpliedStaticNested && modifiers.findFirstToken(64) == null) {
            this.log(ast, MSG_KEY, STATIC_KEYWORD);
        }
    }
}

