/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.retry;

import com.pubnub.api.PubNubError;
import com.pubnub.api.PubNubException;
import com.pubnub.api.logging.LogConfig;
import com.pubnub.api.logging.LogMessage;
import com.pubnub.api.logging.LogMessageContent;
import com.pubnub.api.retry.RetryConfiguration;
import com.pubnub.api.retry.RetryableEndpointGroup;
import com.pubnub.internal.PubNubRetryableException;
import com.pubnub.internal.logging.LoggerManager;
import com.pubnub.internal.logging.PNLogger;
import com.pubnub.internal.retry.RetryableBase;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import retrofit2.Call;
import retrofit2.Response;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ!\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u0010H\u0000\u00a2\u0006\u0002\b\u0018J\"\u0010\u0019\u001a\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0016\u0012\f\u0012\n\u0018\u00010\u001bj\u0004\u0018\u0001`\u001c0\u001aH\u0002J\u0014\u0010\u001d\u001a\u00020\b2\n\u0010\u001e\u001a\u00060\u001bj\u0002`\u001cH\u0002J\u0016\u0010\u001f\u001a\u00020\b2\f\u0010 \u001a\b\u0012\u0004\u0012\u00028\u00000\u0016H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0010X\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006!"}, d2={"Lcom/pubnub/internal/retry/RetryableRestCaller;", "T", "Lcom/pubnub/internal/retry/RetryableBase;", "retryConfiguration", "Lcom/pubnub/api/retry/RetryConfiguration;", "endpointGroupName", "Lcom/pubnub/api/retry/RetryableEndpointGroup;", "isEndpointRetryable", "", "logConfig", "Lcom/pubnub/api/logging/LogConfig;", "<init>", "(Lcom/pubnub/api/retry/RetryConfiguration;Lcom/pubnub/api/retry/RetryableEndpointGroup;ZLcom/pubnub/api/logging/LogConfig;)V", "log", "Lcom/pubnub/internal/logging/PNLogger;", "call", "Lretrofit2/Call;", "getCall$pubnub_kotlin_impl", "()Lretrofit2/Call;", "setCall$pubnub_kotlin_impl", "(Lretrofit2/Call;)V", "execute", "Lretrofit2/Response;", "callToBeExecuted", "execute$pubnub_kotlin_impl", "executeRestCall", "Lkotlin/Pair;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "isExceptionRetryable", "e", "shouldRetry", "response", "pubnub-kotlin-impl"})
@SourceDebugExtension(value={"SMAP\nRetryableRestCaller.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RetryableRestCaller.kt\ncom/pubnub/internal/retry/RetryableRestCaller\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,95:1\n1761#2,3:96\n*S KotlinDebug\n*F\n+ 1 RetryableRestCaller.kt\ncom/pubnub/internal/retry/RetryableRestCaller\n*L\n86#1:96,3\n*E\n"})
public final class RetryableRestCaller<T>
extends RetryableBase<T> {
    private final boolean isEndpointRetryable;
    @NotNull
    private final LogConfig logConfig;
    @NotNull
    private final PNLogger log;
    public Call<T> call;

    public RetryableRestCaller(@NotNull RetryConfiguration retryConfiguration, @NotNull RetryableEndpointGroup endpointGroupName, boolean isEndpointRetryable, @NotNull LogConfig logConfig) {
        Intrinsics.checkNotNullParameter((Object)retryConfiguration, (String)"retryConfiguration");
        Intrinsics.checkNotNullParameter((Object)endpointGroupName, (String)"endpointGroupName");
        Intrinsics.checkNotNullParameter((Object)logConfig, (String)"logConfig");
        super(retryConfiguration, endpointGroupName);
        this.isEndpointRetryable = isEndpointRetryable;
        this.logConfig = logConfig;
        this.log = LoggerManager.Companion.getInstance().getLogger(this.logConfig, this.getClass());
    }

    @NotNull
    public final Call<T> getCall$pubnub_kotlin_impl() {
        Call<T> call = this.call;
        if (call != null) {
            return call;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"call");
        return null;
    }

    public final void setCall$pubnub_kotlin_impl(@NotNull Call<T> call) {
        Intrinsics.checkNotNullParameter(call, (String)"<set-?>");
        this.call = call;
    }

    @NotNull
    public final Response<T> execute$pubnub_kotlin_impl(@NotNull Call<T> callToBeExecuted) {
        Intrinsics.checkNotNullParameter(callToBeExecuted, (String)"callToBeExecuted");
        this.setCall$pubnub_kotlin_impl(callToBeExecuted);
        int numberOfAttempts = 0;
        while (true) {
            Pair<Response<T>, Exception> pair = this.executeRestCall();
            Response response = (Response)pair.component1();
            Exception exception = (Exception)pair.component2();
            if (!this.shouldRetry(response) || numberOfAttempts++ >= this.getMaxRetryNumberFromConfiguration()) {
                if (response.isSuccessful() || exception == null) {
                    return response;
                }
                throw exception;
            }
            int randomDelayInMillis = this.getRandom().nextInt(1000);
            long effectiveDelayInMillis = Duration.getInWholeMilliseconds-impl((long)this.getDelayBasedOnResponse-5sfh64U$pubnub_kotlin_impl(response)) + (long)randomDelayInMillis;
            this.log.trace(new LogMessage((LogMessageContent)new LogMessageContent.Text("Added random delay so effective retry delay is " + effectiveDelayInMillis), null, null, null, null, null, null, 126, null));
            Thread.sleep(effectiveDelayInMillis);
            this.setCall$pubnub_kotlin_impl(this.getCall$pubnub_kotlin_impl().clone());
        }
    }

    private final Pair<Response<T>, Exception> executeRestCall() {
        Exception pubNubException = null;
        try {
            Pair pair;
            try {
                Response response = this.getCall$pubnub_kotlin_impl().execute();
                pair = new Pair((Object)response, pubNubException);
            }
            catch (Exception e) {
                PubNubError pubNubError = PubNubError.PARSING_ERROR;
                String string = e.toString();
                Call<T> call = this.getCall$pubnub_kotlin_impl();
                pubNubException = (Exception)((Object)new PubNubException(string, pubNubError, null, 0, call, null, null, null, null, null, null, 2028, null));
                if (this.isExceptionRetryable(e)) {
                    pubNubError = PubNubError.CONNECT_EXCEPTION;
                    string = e.toString();
                    throw new PubNubRetryableException(string, pubNubError, 503);
                }
                throw pubNubException;
            }
            return pair;
        }
        catch (PubNubRetryableException e) {
            int n = e.getStatusCode();
            String string = e.getErrorMessage();
            if (string == null || (string = ResponseBody.Companion.create$default((ResponseBody.Companion)ResponseBody.Companion, (String)string, null, (int)1, null)) == null) {
                string = ResponseBody.Companion.create$default((ResponseBody.Companion)ResponseBody.Companion, (String)"", null, (int)1, null);
            }
            return new Pair((Object)Response.error((int)n, (ResponseBody)string), pubNubException);
        }
    }

    private final boolean isExceptionRetryable(Exception e) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = RetryableBase.Companion.getRetryableExceptions$pubnub_kotlin_impl();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Class it = (Class)element$iv;
                    boolean bl2 = false;
                    if (!it.isInstance(e)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean shouldRetry(Response<T> response) {
        return !response.isSuccessful() && this.isErrorCodeRetryable(response.raw().code()) && this.isRetryConfSetForThisRestCall$pubnub_kotlin_impl() && this.isEndpointRetryable;
    }
}

