/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.logging.networkLogging;

import com.pubnub.api.enums.PNLogVerbosity;
import com.pubnub.api.logging.HttpMethod;
import com.pubnub.api.logging.LogMessage;
import com.pubnub.api.logging.LogMessageContent;
import com.pubnub.api.logging.LogMessageType;
import com.pubnub.internal.logging.PNLogger;
import com.pubnub.internal.managers.MapperManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.slf4j.event.Level;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J,\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\n\u0010\u0017\u001a\u00060\u0018j\u0002`\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/pubnub/internal/logging/networkLogging/CustomPnHttpLoggingInterceptor;", "Lokhttp3/Interceptor;", "logger", "Lcom/pubnub/internal/logging/PNLogger;", "mapperManager", "Lcom/pubnub/internal/managers/MapperManager;", "logVerbosity", "Lcom/pubnub/api/enums/PNLogVerbosity;", "<init>", "(Lcom/pubnub/internal/logging/PNLogger;Lcom/pubnub/internal/managers/MapperManager;Lcom/pubnub/api/enums/PNLogVerbosity;)V", "intercept", "Lokhttp3/Response;", "chain", "Lokhttp3/Interceptor$Chain;", "logRequest", "", "request", "Lokhttp3/Request;", "location", "", "logResponse", "response", "logError", "error", "Ljava/lang/Exception;", "Lkotlin/Exception;", "requestStartTime", "", "pubnub-kotlin-impl"})
@SourceDebugExtension(value={"SMAP\nCustomPnHttpLoggingInterceptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CustomPnHttpLoggingInterceptor.kt\ncom/pubnub/internal/logging/networkLogging/CustomPnHttpLoggingInterceptor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,174:1\n1285#2,2:175\n1299#2,4:177\n1563#2:182\n1634#2,3:183\n1#3:181\n*S KotlinDebug\n*F\n+ 1 CustomPnHttpLoggingInterceptor.kt\ncom/pubnub/internal/logging/networkLogging/CustomPnHttpLoggingInterceptor\n*L\n56#1:175,2\n56#1:177,4\n144#1:182\n144#1:183,3\n*E\n"})
public final class CustomPnHttpLoggingInterceptor
implements Interceptor {
    @NotNull
    private final PNLogger logger;
    @NotNull
    private final MapperManager mapperManager;
    @NotNull
    private final PNLogVerbosity logVerbosity;

    public CustomPnHttpLoggingInterceptor(@NotNull PNLogger logger, @NotNull MapperManager mapperManager, @NotNull PNLogVerbosity logVerbosity) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)mapperManager, (String)"mapperManager");
        Intrinsics.checkNotNullParameter((Object)logVerbosity, (String)"logVerbosity");
        this.logger = logger;
        this.mapperManager = mapperManager;
        this.logVerbosity = logVerbosity;
    }

    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) {
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Request request = chain.request();
        long requestStartTime = System.currentTimeMillis();
        String string = (String)CollectionsKt.firstOrNull((List)request.url().pathSegments());
        if (string == null) {
            string = "unknown";
        }
        String location = string;
        this.logRequest(request, location);
        Response response = null;
        try {
            response = chain.proceed(request);
            Response modifiedResponse = this.logResponse(response, location);
            return modifiedResponse;
        }
        catch (Exception e) {
            this.logError(request, location, e, requestStartTime);
            throw e;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void logRequest(Request request, String location) {
        Map it;
        String string;
        HttpUrl url = request.url();
        String origin = url.scheme() + "://" + url.host();
        String path = url.encodedPath() + (url.encodedQuery() != null ? '?' + url.encodedQuery() : "");
        Iterable $this$associateWith$iv = url.queryParameterNames();
        boolean $i$f$associateWith = false;
        Map result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Object $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        Iterator iterator = $this$associateWithTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it2;
            Object element$iv$iv = iterator.next();
            String string2 = (String)element$iv$iv;
            Object t = element$iv$iv;
            Map map = result$iv;
            boolean bl = false;
            String string3 = url.queryParameter((String)it2);
            if (string3 == null) {
                string3 = "";
            }
            string = string3;
            map.put(t, string);
        }
        Map queryParams = result$iv;
        Map headers = MapsKt.toMap((Iterable)((Iterable)request.headers()));
        result$iv = queryParams;
        $this$associateWithTo$iv$iv = result$iv;
        String string4 = path;
        string = origin;
        boolean bl = false;
        boolean bl2 = !it.isEmpty();
        Map map = bl2 ? result$iv : null;
        String string5 = request.method().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toLowerCase(...)");
        it = result$iv = headers;
        HttpMethod httpMethod = HttpMethod.Companion.fromString(string5);
        Map map2 = map;
        boolean bl3 = false;
        boolean bl4 = !it.isEmpty();
        Map map3 = bl4 ? result$iv : null;
        boolean bl5 = false;
        boolean bl6 = false;
        String string6 = null;
        Long l = null;
        String string7 = String.valueOf(request.body());
        Map map4 = null;
        Map map5 = map3;
        HttpMethod httpMethod2 = httpMethod;
        Map map6 = map2;
        String string8 = string4;
        String string9 = string;
        LogMessageContent.NetworkRequest networkRequest = new LogMessageContent.NetworkRequest(string9, string8, map6, httpMethod2, map5, map4, string7, l, string6, bl6, bl5);
        LogMessage logMessage = new LogMessage((LogMessageContent)networkRequest, "HTTP Request", null, location, null, null, null, 116, null);
        this.logger.debug(logMessage);
        if (this.logVerbosity == PNLogVerbosity.BODY) {
            String jsonMessage = this.mapperManager.toJson(logMessage);
            System.out.println((Object)("[pubnub.okhttp] REQUEST: " + jsonMessage));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Response logResponse(Response response, String location) {
        void it;
        Object responseBody;
        ResponseBody responseBody2;
        Map headers;
        int status;
        String url;
        block10: {
            block9: {
                Pair pair;
                url = response.request().url().toString();
                status = response.code();
                headers = MapsKt.toMap((Iterable)((Iterable)response.headers()));
                responseBody2 = response.body();
                if (responseBody2 == null) break block9;
                responseBody = responseBody2;
                boolean bl = false;
                Object object = responseBody.contentType();
                if (object == null || (object = object.toString()) == null) {
                    object = "";
                }
                Object contentType = object;
                try {
                    Pair pair2;
                    Response newResponse;
                    ResponseBody clonedResponseBody;
                    if (StringsKt.contains$default((CharSequence)((CharSequence)contentType), (CharSequence)"application/json", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)contentType, (String)"text/", (boolean)false, (int)2, null)) {
                        String bodyString = responseBody.string();
                        clonedResponseBody = ResponseBody.Companion.create(bodyString, responseBody.contentType());
                        newResponse = response.newBuilder().body(clonedResponseBody).build();
                        pair2 = TuplesKt.to((Object)bodyString, (Object)newResponse);
                    } else {
                        byte[] bytes = responseBody.bytes();
                        clonedResponseBody = ResponseBody.Companion.create(bytes, responseBody.contentType());
                        newResponse = response.newBuilder().body(clonedResponseBody).build();
                        pair2 = TuplesKt.to((Object)Base64.getEncoder().encodeToString(bytes), (Object)newResponse);
                    }
                    pair = pair2;
                }
                catch (IOException e) {
                    pair = TuplesKt.to((Object)("[Error reading response body: " + e.getMessage() + ']'), (Object)response);
                }
                Pair pair3 = pair;
                responseBody2 = pair3;
                if (pair3 != null) break block10;
            }
            responseBody2 = TuplesKt.to(null, (Object)response);
        }
        ResponseBody responseBody3 = responseBody2;
        String body = (String)responseBody3.component1();
        Response modifiedResponse = (Response)responseBody3.component2();
        Object bl = responseBody = headers;
        int n = status;
        String string = url;
        boolean bl2 = false;
        boolean bl3 = !it.isEmpty();
        Object object = bl3 ? responseBody : null;
        String string2 = body;
        Object object2 = object;
        int n2 = n;
        String string3 = string;
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n3 = 116;
        String string4 = null;
        Level level = null;
        String string5 = null;
        String string6 = location;
        LogMessageType logMessageType = null;
        String string7 = "HTTP Response";
        LogMessageContent logMessageContent = (LogMessageContent)new LogMessageContent.NetworkResponse(string3, n2, (Map)object2, string2);
        LogMessage logMessage = new LogMessage(logMessageContent, string7, logMessageType, string6, string5, level, string4, n3, defaultConstructorMarker);
        this.logger.debug(logMessage);
        if (this.logVerbosity == PNLogVerbosity.BODY) {
            String jsonMessage = this.mapperManager.toJson(logMessage);
            System.out.println((Object)("[pubnub.okhttp] RESPONSE: " + jsonMessage));
        }
        return modifiedResponse;
    }

    /*
     * WARNING - void declaration
     */
    private final void logError(Request request, String location, Exception error, long requestStartTime) {
        String jsonMessage;
        boolean isCancellation;
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        long duration = System.currentTimeMillis() - requestStartTime;
        String string = error.getClass().getSimpleName();
        String string2 = error.getMessage();
        if (string2 == null) {
            string2 = "Unknown error";
        }
        StackTraceElement[] stackTraceElementArray = error.getStackTrace();
        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
        Iterable iterable = ArraysKt.take((Object[])stackTraceElementArray, (int)10);
        String string3 = string2;
        String string4 = string;
        boolean $i$f$map = false;
        void var11_10 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            StackTraceElement stackTraceElement = (StackTraceElement)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String string5 = it.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toString(...)");
            collection.add(string5);
        }
        collection = (List)destination$iv$iv;
        List list = collection;
        String string6 = string3;
        String string7 = string4;
        LogMessageContent.Error errorDetails = new LogMessageContent.Error(string7, string6, list);
        LogMessage logMessage = new LogMessage((LogMessageContent)errorDetails, "HTTP Request failed after " + duration + "ms: " + error.getMessage(), null, location, null, null, null, 116, null);
        boolean bl = isCancellation = error instanceof IOException && Intrinsics.areEqual((Object)error.getMessage(), (Object)"Canceled");
        if (isCancellation) {
            this.logger.debug(logMessage);
            if (this.logVerbosity == PNLogVerbosity.BODY) {
                jsonMessage = this.mapperManager.toJson(logMessage);
                System.out.println((Object)("[pubnub.okhttp] DEBUG: " + jsonMessage));
            }
        } else {
            this.logger.error(logMessage);
            if (this.logVerbosity == PNLogVerbosity.BODY) {
                jsonMessage = this.mapperManager.toJson(logMessage);
                System.out.println((Object)("[pubnub.okhttp] ERROR: " + jsonMessage));
            }
        }
    }
}

