/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.endpoints.files;

import com.pubnub.api.PubNubError;
import com.pubnub.api.PubNubException;
import com.pubnub.api.crypto.CryptoModule;
import com.pubnub.api.endpoints.files.SendFile;
import com.pubnub.api.endpoints.remoteaction.ComposableRemoteAction;
import com.pubnub.api.endpoints.remoteaction.ExtendedRemoteAction;
import com.pubnub.api.endpoints.remoteaction.MappingRemoteActionKt;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.models.consumer.files.PNBaseFile;
import com.pubnub.api.models.consumer.files.PNFileUploadResult;
import com.pubnub.api.models.consumer.files.PNPublishFileMessageResult;
import com.pubnub.api.v2.callbacks.Result;
import com.pubnub.internal.crypto.cryptor.InputStreamSeparator;
import com.pubnub.internal.endpoints.files.GenerateUploadUrlEndpoint;
import com.pubnub.internal.endpoints.files.PublishFileMessageEndpoint;
import com.pubnub.internal.endpoints.files.UploadFileEndpoint;
import com.pubnub.internal.models.server.files.FileUploadRequestDetails;
import java.io.Closeable;
import java.io.InputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0089\u0001\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\b\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u0012\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u0018\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\b\u0010 \u001a\u00020\u001fH\u0016J\u001c\u0010!\u001a\u00020\"2\u0012\u0010#\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001f0%0$H\u0016J\b\u0010&\u001a\u00020\"H\u0002J8\u0010'\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0002J\u0018\u0010(\u001a\u00020\u001f2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0002J\b\u0010-\u001a\u00020\"H\u0016J\b\u0010.\u001a\u00020\"H\u0016J\b\u0010/\u001a\u000200H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001bR\u0012\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001cR\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/pubnub/internal/endpoints/files/SendFileEndpoint;", "Lcom/pubnub/api/endpoints/files/SendFile;", "channel", "", "fileName", "inputStream", "Ljava/io/InputStream;", "message", "", "meta", "ttl", "", "shouldStore", "", "customMessageType", "executorService", "Ljava/util/concurrent/ExecutorService;", "generateUploadUrlFactory", "Lcom/pubnub/internal/endpoints/files/GenerateUploadUrlEndpoint$Factory;", "publishFileMessageFactory", "Lcom/pubnub/internal/endpoints/files/PublishFileMessageEndpoint$Factory;", "sendFileToS3Factory", "Lcom/pubnub/internal/endpoints/files/UploadFileEndpoint$Factory;", "cryptoModule", "Lcom/pubnub/api/crypto/CryptoModule;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/io/InputStream;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Integer;Ljava/lang/Boolean;Ljava/lang/String;Ljava/util/concurrent/ExecutorService;Lcom/pubnub/internal/endpoints/files/GenerateUploadUrlEndpoint$Factory;Lcom/pubnub/internal/endpoints/files/PublishFileMessageEndpoint$Factory;Lcom/pubnub/internal/endpoints/files/UploadFileEndpoint$Factory;Lcom/pubnub/api/crypto/CryptoModule;)V", "Ljava/lang/Integer;", "Ljava/lang/Boolean;", "sendFileMultistepAction", "Lcom/pubnub/api/endpoints/remoteaction/ExtendedRemoteAction;", "Lcom/pubnub/api/models/consumer/files/PNFileUploadResult;", "sync", "async", "", "callback", "Ljava/util/function/Consumer;", "Lcom/pubnub/api/v2/callbacks/Result;", "validate", "sendFileComposedActions", "mapPublishFileMessageToFileUpload", "requestDetails", "Lcom/pubnub/internal/models/server/files/FileUploadRequestDetails;", "res", "Lcom/pubnub/api/models/consumer/files/PNPublishFileMessageResult;", "retry", "silentCancel", "operationType", "Lcom/pubnub/api/enums/PNOperationType;", "pubnub-kotlin-impl"})
public final class SendFileEndpoint
implements SendFile {
    @NotNull
    private final String channel;
    @NotNull
    private final String fileName;
    @Nullable
    private final Object message;
    @Nullable
    private final Object meta;
    @Nullable
    private final Integer ttl;
    @Nullable
    private final Boolean shouldStore;
    @Nullable
    private final String customMessageType;
    @NotNull
    private final ExecutorService executorService;
    @NotNull
    private final ExtendedRemoteAction<PNFileUploadResult> sendFileMultistepAction;

    public SendFileEndpoint(@NotNull String channel, @NotNull String fileName, @NotNull InputStream inputStream, @Nullable Object message, @Nullable Object meta, @Nullable Integer ttl, @Nullable Boolean shouldStore, @Nullable String customMessageType, @NotNull ExecutorService executorService, @NotNull GenerateUploadUrlEndpoint.Factory generateUploadUrlFactory, @NotNull PublishFileMessageEndpoint.Factory publishFileMessageFactory, @NotNull UploadFileEndpoint.Factory sendFileToS3Factory, @Nullable CryptoModule cryptoModule) {
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Intrinsics.checkNotNullParameter((Object)executorService, (String)"executorService");
        Intrinsics.checkNotNullParameter((Object)generateUploadUrlFactory, (String)"generateUploadUrlFactory");
        Intrinsics.checkNotNullParameter((Object)publishFileMessageFactory, (String)"publishFileMessageFactory");
        Intrinsics.checkNotNullParameter((Object)sendFileToS3Factory, (String)"sendFileToS3Factory");
        this.channel = channel;
        this.fileName = fileName;
        this.message = message;
        this.meta = meta;
        this.ttl = ttl;
        this.shouldStore = shouldStore;
        this.customMessageType = customMessageType;
        this.executorService = executorService;
        this.sendFileMultistepAction = this.sendFileComposedActions(generateUploadUrlFactory, publishFileMessageFactory, sendFileToS3Factory, inputStream, cryptoModule);
    }

    public /* synthetic */ SendFileEndpoint(String string, String string2, InputStream inputStream, Object object, Object object2, Integer n, Boolean bl, String string3, ExecutorService executorService, GenerateUploadUrlEndpoint.Factory factory, PublishFileMessageEndpoint.Factory factory2, UploadFileEndpoint.Factory factory3, CryptoModule cryptoModule, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            object = null;
        }
        if ((n2 & 0x10) != 0) {
            object2 = null;
        }
        if ((n2 & 0x20) != 0) {
            n = null;
        }
        if ((n2 & 0x40) != 0) {
            bl = null;
        }
        if ((n2 & 0x80) != 0) {
            string3 = null;
        }
        if ((n2 & 0x1000) != 0) {
            cryptoModule = null;
        }
        this(string, string2, inputStream, object, object2, n, bl, string3, executorService, factory, factory2, factory3, cryptoModule);
    }

    @NotNull
    public PNFileUploadResult sync() throws PubNubException {
        this.validate();
        return (PNFileUploadResult)this.sendFileMultistepAction.sync();
    }

    public void async(@NotNull Consumer<Result<PNFileUploadResult>> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.executorService.execute(() -> SendFileEndpoint.async$lambda$0(this, callback));
    }

    private final void validate() throws PubNubException {
        if (((CharSequence)this.channel).length() == 0) {
            throw new PubNubException(PubNubError.CHANNEL_MISSING, null, 2, null);
        }
        if (((CharSequence)this.fileName).length() == 0) {
            throw PubNubException.copy$default((PubNubException)new PubNubException(PubNubError.INVALID_ARGUMENTS, null, 2, null), (String)"File name cannot be null nor empty", null, null, (int)0, null, null, null, null, null, null, null, (int)2046, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ExtendedRemoteAction<PNFileUploadResult> sendFileComposedActions(GenerateUploadUrlEndpoint.Factory generateUploadUrlFactory, PublishFileMessageEndpoint.Factory publishFileMessageFactory, UploadFileEndpoint.Factory sendFileToS3Factory, InputStream inputStream, CryptoModule cryptoModule) {
        Object object;
        boolean isEncrypted;
        AtomicReference result;
        block9: {
            block8: {
                byte[] byArray;
                result = new AtomicReference();
                isEncrypted = cryptoModule != null;
                object = cryptoModule;
                if (object == null || (object = object.encryptStream((InputStream)new InputStreamSeparator(inputStream))) == null) break block8;
                Closeable closeable = (Closeable)object;
                Throwable throwable = null;
                try {
                    InputStream it = (InputStream)closeable;
                    boolean bl = false;
                    byArray = ByteStreamsKt.readBytes((InputStream)it);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                object = byArray;
                if (byArray != null) break block9;
            }
            object = ByteStreamsKt.readBytes((InputStream)inputStream);
        }
        Object content = object;
        return MappingRemoteActionKt.map((ExtendedRemoteAction)((ExtendedRemoteAction)ComposableRemoteAction.Companion.firstDo(generateUploadUrlFactory.create(this.channel, this.fileName)).then(arg_0 -> SendFileEndpoint.sendFileComposedActions$lambda$2(result, sendFileToS3Factory, this, (byte[])content, isEncrypted, arg_0)).checkpoint().then(arg_0 -> SendFileEndpoint.sendFileComposedActions$lambda$3(result, publishFileMessageFactory, this, arg_0))), arg_0 -> SendFileEndpoint.sendFileComposedActions$lambda$4(this, result, arg_0));
    }

    private final PNFileUploadResult mapPublishFileMessageToFileUpload(FileUploadRequestDetails requestDetails, PNPublishFileMessageResult res) {
        return new PNFileUploadResult(res.getTimetoken(), 200, new PNBaseFile(requestDetails.getData().getId(), requestDetails.getData().getName()));
    }

    public void retry() {
        this.sendFileMultistepAction.retry();
    }

    public void silentCancel() {
        this.sendFileMultistepAction.silentCancel();
    }

    @NotNull
    public PNOperationType operationType() {
        return (PNOperationType)PNOperationType.FileOperation.INSTANCE;
    }

    private static final void async$lambda$0(SendFileEndpoint this$0, Consumer $callback) {
        try {
            this$0.validate();
            this$0.sendFileMultistepAction.async($callback);
        }
        catch (PubNubException ex) {
            $callback.accept(Result.Companion.failure(ex));
        }
    }

    private static final ExtendedRemoteAction sendFileComposedActions$lambda$2(AtomicReference $result, UploadFileEndpoint.Factory $sendFileToS3Factory, SendFileEndpoint this$0, byte[] $content, boolean $isEncrypted, FileUploadRequestDetails res) {
        Intrinsics.checkNotNullParameter((Object)res, (String)"res");
        $result.set(res);
        return (ExtendedRemoteAction)$sendFileToS3Factory.create(this$0.fileName, $content, res, $isEncrypted);
    }

    private static final ExtendedRemoteAction sendFileComposedActions$lambda$3(AtomicReference $result, PublishFileMessageEndpoint.Factory $publishFileMessageFactory, SendFileEndpoint this$0, Unit it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        FileUploadRequestDetails details = (FileUploadRequestDetails)$result.get();
        return $publishFileMessageFactory.create(this$0.channel, details.getData().getName(), details.getData().getId(), this$0.message, this$0.meta, this$0.ttl, this$0.shouldStore, this$0.customMessageType);
    }

    private static final PNFileUploadResult sendFileComposedActions$lambda$4(SendFileEndpoint this$0, AtomicReference $result, PNPublishFileMessageResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object v = $result.get();
        Intrinsics.checkNotNullExpressionValue(v, (String)"get(...)");
        return this$0.mapPublishFileMessageToFileUpload((FileUploadRequestDetails)v, it);
    }
}

