/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.endpoints.channel_groups;

import com.pubnub.api.PubNubError;
import com.pubnub.api.PubNubException;
import com.pubnub.api.endpoints.channel_groups.RemoveChannelChannelGroup;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.logging.LogMessage;
import com.pubnub.api.logging.LogMessageContent;
import com.pubnub.api.models.consumer.channel_group.PNChannelGroupsRemoveChannelResult;
import com.pubnub.api.retry.RetryableEndpointGroup;
import com.pubnub.internal.EndpointCore;
import com.pubnub.internal.PubNubImpl;
import com.pubnub.internal.PubNubUtilKt;
import com.pubnub.internal.logging.LoggerManager;
import com.pubnub.internal.logging.PNLogger;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import retrofit2.Call;
import retrofit2.Response;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u00020\u0004B'\b\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\b0\nH\u0014J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\b0\nH\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0014J2\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u00182\"\u0010\u0019\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u001aj\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b`\u001bH\u0014J\u0016\u0010\u001c\u001a\u00020\u00032\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00020\u001eH\u0014J\b\u0010\u001f\u001a\u00020 H\u0016J\u001c\u0010!\u001a\u00020\u00162\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\"H\u0002J\b\u0010#\u001a\u00020$H\u0014R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/pubnub/internal/endpoints/channel_groups/RemoveChannelChannelGroupEndpoint;", "Lcom/pubnub/internal/EndpointCore;", "Ljava/lang/Void;", "Lcom/pubnub/api/models/consumer/channel_group/PNChannelGroupsRemoveChannelResult;", "Lcom/pubnub/api/endpoints/channel_groups/RemoveChannelChannelGroup;", "pubnub", "Lcom/pubnub/internal/PubNubImpl;", "channelGroup", "", "channels", "", "<init>", "(Lcom/pubnub/internal/PubNubImpl;Ljava/lang/String;Ljava/util/List;)V", "getChannelGroup", "()Ljava/lang/String;", "getChannels", "()Ljava/util/List;", "log", "Lcom/pubnub/internal/logging/PNLogger;", "getAffectedChannels", "getAffectedChannelGroups", "validateParams", "", "doWork", "Lretrofit2/Call;", "queryParams", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "createResponse", "input", "Lretrofit2/Response;", "operationType", "Lcom/pubnub/api/enums/PNOperationType$PNRemoveChannelsFromGroupOperation;", "addQueryParams", "", "getEndpointGroupName", "Lcom/pubnub/api/retry/RetryableEndpointGroup;", "pubnub-kotlin-impl"})
public final class RemoveChannelChannelGroupEndpoint
extends EndpointCore<Void, PNChannelGroupsRemoveChannelResult>
implements RemoveChannelChannelGroup {
    @NotNull
    private final String channelGroup;
    @NotNull
    private final List<String> channels;
    @NotNull
    private final PNLogger log;

    public RemoveChannelChannelGroupEndpoint(@NotNull PubNubImpl pubnub, @NotNull String channelGroup, @NotNull List<String> channels) {
        Intrinsics.checkNotNullParameter((Object)pubnub, (String)"pubnub");
        Intrinsics.checkNotNullParameter((Object)channelGroup, (String)"channelGroup");
        Intrinsics.checkNotNullParameter(channels, (String)"channels");
        super(pubnub);
        this.channelGroup = channelGroup;
        this.channels = channels;
        this.log = LoggerManager.Companion.getInstance().getLogger(pubnub.getLogConfig(), this.getClass());
    }

    @NotNull
    public String getChannelGroup() {
        return this.channelGroup;
    }

    @NotNull
    public List<String> getChannels() {
        return this.channels;
    }

    @Override
    @NotNull
    protected List<String> getAffectedChannels() {
        return this.getChannels();
    }

    @Override
    @NotNull
    protected List<String> getAffectedChannelGroups() {
        return CollectionsKt.listOf((Object)this.getChannelGroup());
    }

    @Override
    protected void validateParams() {
        super.validateParams();
        if (StringsKt.isBlank((CharSequence)this.getChannelGroup())) {
            throw new PubNubException(PubNubError.GROUP_MISSING, null, 2, null);
        }
        if (this.getChannels().isEmpty()) {
            throw new PubNubException(PubNubError.CHANNEL_MISSING, null, 2, null);
        }
    }

    @Override
    @NotNull
    protected Call<Void> doWork(@NotNull HashMap<String, String> queryParams) {
        Intrinsics.checkNotNullParameter(queryParams, (String)"queryParams");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"channelGroup", (Object)this.getChannelGroup()), TuplesKt.to((Object)"channels", this.getChannels())};
        this.log.debug(new LogMessage((LogMessageContent)new LogMessageContent.Object(MapsKt.mapOf((Pair[])pairArray), Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName()), "RemoveChannelChannelGroup API call", null, null, null, null, null, 124, null));
        this.addQueryParams((Map<String, String>)queryParams);
        return this.getRetrofitManager().getChannelGroupService$pubnub_kotlin_impl().removeChannel(this.getConfiguration().getSubscribeKey(), this.getChannelGroup(), (Map<String, String>)queryParams);
    }

    @Override
    @NotNull
    protected PNChannelGroupsRemoveChannelResult createResponse(@NotNull Response<Void> input) {
        Intrinsics.checkNotNullParameter(input, (String)"input");
        return new PNChannelGroupsRemoveChannelResult();
    }

    @NotNull
    public PNOperationType.PNRemoveChannelsFromGroupOperation operationType() {
        return PNOperationType.PNRemoveChannelsFromGroupOperation.INSTANCE;
    }

    private final void addQueryParams(Map<String, String> queryParams) {
        if (!((Collection)this.getChannels()).isEmpty()) {
            queryParams.put("remove", PubNubUtilKt.toCsv(this.getChannels()));
        }
    }

    @Override
    @NotNull
    protected RetryableEndpointGroup getEndpointGroupName() {
        return RetryableEndpointGroup.CHANNEL_GROUP;
    }
}

